/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder;

import java.io.InputStream;
import org.apache.avalon.meta.info.Service;
import org.apache.avalon.meta.info.builder.SerializedServiceCreator;
import org.apache.avalon.meta.info.builder.ServiceCreator;
import org.apache.avalon.meta.info.builder.XMLServiceCreator;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public final class ServiceBuilder {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$meta$info$builder$ServiceBuilder == null ? (class$org$apache$avalon$meta$info$builder$ServiceBuilder = ServiceBuilder.class$("org.apache.avalon.meta.info.builder.ServiceBuilder")) : class$org$apache$avalon$meta$info$builder$ServiceBuilder));
    private final ServiceCreator m_xmlServiceCreator = ServiceBuilder.createXMLServiceCreator();
    private final ServiceCreator m_serialServiceCreator = new SerializedServiceCreator();
    static /* synthetic */ Class class$org$apache$avalon$meta$info$builder$ServiceBuilder;

    public Service build(Class clazz) throws Exception {
        return this.build(clazz.getName(), clazz.getClassLoader());
    }

    public Service build(String classname, ClassLoader classLoader) throws Exception {
        Service info = this.buildFromSerDescriptor(classname, classLoader);
        if (null != info) {
            return info;
        }
        return this.buildFromXMLDescriptor(classname, classLoader);
    }

    private Service buildFromSerDescriptor(String classname, ClassLoader classLoader) throws Exception {
        String xinfo = classname.replace('.', '/') + ".sinfo";
        InputStream inputStream = classLoader.getResourceAsStream(xinfo);
        if (null == inputStream) {
            return null;
        }
        return this.m_serialServiceCreator.createService(classname, inputStream);
    }

    private Service buildFromXMLDescriptor(String classname, ClassLoader classLoader) throws Exception {
        String xservice = classname.replace('.', '/') + ".xservice";
        InputStream inputStream = classLoader.getResourceAsStream(xservice);
        if (null == inputStream) {
            String message = REZ.getString("builder.missing-info.error", (Object)classname);
            throw new Exception(message);
        }
        ServiceCreator xmlServiceCreator = this.getXMLServiceCreator(classname);
        return xmlServiceCreator.createService(classname, inputStream);
    }

    private ServiceCreator getXMLServiceCreator(String classname) throws Exception {
        if (null != this.m_xmlServiceCreator) {
            return this.m_xmlServiceCreator;
        }
        String message = REZ.getString("builder.missing-xml-creator.error", (Object)classname);
        throw new Exception(message);
    }

    private static ServiceCreator createXMLServiceCreator() {
        XMLServiceCreator xmlServiceCreator = null;
        try {
            xmlServiceCreator = new XMLServiceCreator();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlServiceCreator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

