/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.verifier;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.avalon.meta.info.verifier.VerifyException;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class TypeVerifier {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$meta$info$verifier$TypeVerifier == null ? (class$org$apache$avalon$meta$info$verifier$TypeVerifier = TypeVerifier.class$("org.apache.avalon.meta.info.verifier.TypeVerifier")) : class$org$apache$avalon$meta$info$verifier$TypeVerifier));
    private static final Class[] EMPTY_TYPES = new Class[0];
    private static final Class[] FRAMEWORK_CLASSES = new Class[]{class$org$apache$avalon$framework$logger$LogEnabled == null ? (class$org$apache$avalon$framework$logger$LogEnabled = TypeVerifier.class$("org.apache.avalon.framework.logger.LogEnabled")) : class$org$apache$avalon$framework$logger$LogEnabled, class$org$apache$avalon$framework$context$Contextualizable == null ? (class$org$apache$avalon$framework$context$Contextualizable = TypeVerifier.class$("org.apache.avalon.framework.context.Contextualizable")) : class$org$apache$avalon$framework$context$Contextualizable, class$org$apache$avalon$framework$context$Recontextualizable == null ? (class$org$apache$avalon$framework$context$Recontextualizable = TypeVerifier.class$("org.apache.avalon.framework.context.Recontextualizable")) : class$org$apache$avalon$framework$context$Recontextualizable, class$org$apache$avalon$framework$component$Composable == null ? (class$org$apache$avalon$framework$component$Composable = TypeVerifier.class$("org.apache.avalon.framework.component.Composable")) : class$org$apache$avalon$framework$component$Composable, class$org$apache$avalon$framework$component$Recomposable == null ? (class$org$apache$avalon$framework$component$Recomposable = TypeVerifier.class$("org.apache.avalon.framework.component.Recomposable")) : class$org$apache$avalon$framework$component$Recomposable, class$org$apache$avalon$framework$service$Serviceable == null ? (class$org$apache$avalon$framework$service$Serviceable = TypeVerifier.class$("org.apache.avalon.framework.service.Serviceable")) : class$org$apache$avalon$framework$service$Serviceable, class$org$apache$avalon$framework$configuration$Configurable == null ? (class$org$apache$avalon$framework$configuration$Configurable = TypeVerifier.class$("org.apache.avalon.framework.configuration.Configurable")) : class$org$apache$avalon$framework$configuration$Configurable, class$org$apache$avalon$framework$configuration$Reconfigurable == null ? (class$org$apache$avalon$framework$configuration$Reconfigurable = TypeVerifier.class$("org.apache.avalon.framework.configuration.Reconfigurable")) : class$org$apache$avalon$framework$configuration$Reconfigurable, class$org$apache$avalon$framework$parameters$Parameterizable == null ? (class$org$apache$avalon$framework$parameters$Parameterizable = TypeVerifier.class$("org.apache.avalon.framework.parameters.Parameterizable")) : class$org$apache$avalon$framework$parameters$Parameterizable, class$org$apache$avalon$framework$parameters$Reparameterizable == null ? (class$org$apache$avalon$framework$parameters$Reparameterizable = TypeVerifier.class$("org.apache.avalon.framework.parameters.Reparameterizable")) : class$org$apache$avalon$framework$parameters$Reparameterizable, class$org$apache$avalon$framework$activity$Initializable == null ? (class$org$apache$avalon$framework$activity$Initializable = TypeVerifier.class$("org.apache.avalon.framework.activity.Initializable")) : class$org$apache$avalon$framework$activity$Initializable, class$org$apache$avalon$framework$activity$Startable == null ? (class$org$apache$avalon$framework$activity$Startable = TypeVerifier.class$("org.apache.avalon.framework.activity.Startable")) : class$org$apache$avalon$framework$activity$Startable, class$org$apache$avalon$framework$activity$Suspendable == null ? (class$org$apache$avalon$framework$activity$Suspendable = TypeVerifier.class$("org.apache.avalon.framework.activity.Suspendable")) : class$org$apache$avalon$framework$activity$Suspendable, class$org$apache$avalon$framework$activity$Disposable == null ? (class$org$apache$avalon$framework$activity$Disposable = TypeVerifier.class$("org.apache.avalon.framework.activity.Disposable")) : class$org$apache$avalon$framework$activity$Disposable};
    static /* synthetic */ Class class$org$apache$avalon$meta$info$verifier$TypeVerifier;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$LogEnabled;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Contextualizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Recontextualizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$Composable;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$Recomposable;
    static /* synthetic */ Class class$org$apache$avalon$framework$service$Serviceable;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configurable;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Reconfigurable;
    static /* synthetic */ Class class$org$apache$avalon$framework$parameters$Parameterizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$parameters$Reparameterizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Initializable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Startable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Suspendable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Disposable;

    public void verifyType(String name, Class implementation, Class[] services) throws VerifyException {
        this.verifyClass(name, implementation);
        this.verifyLifecycles(name, implementation);
        this.verifyServices(name, services);
        this.verifyImplementsServices(name, implementation, services);
    }

    public void verifyImplementsServices(String name, Class implementation, Class[] services) throws VerifyException {
        for (int i = 0; i < services.length; ++i) {
            if (services[i].isAssignableFrom(implementation)) continue;
            String message = REZ.getString("verifier.noimpl-service.error", (Object)name, (Object)implementation.getName(), (Object)services[i].getName());
            throw new VerifyException(message);
        }
    }

    public void verifyClass(String name, Class clazz) throws VerifyException {
        this.verifyPublicConstructor(name, clazz);
        this.verifyNonAbstract(name, clazz);
        this.verifyNonArray(name, clazz);
        this.verifyNonInterface(name, clazz);
        this.verifyNonPrimitive(name, clazz);
        this.verifyPublic(name, clazz);
    }

    public void verifyServices(String name, Class[] classes) throws VerifyException {
        for (int i = 0; i < classes.length; ++i) {
            this.verifyService(name, classes[i]);
        }
    }

    public void verifyService(String name, Class clazz) throws VerifyException {
        this.verifyServiceIsPublic(name, clazz);
    }

    public void verifyLifecycles(String name, Class implementation) throws VerifyException {
        boolean composable = (class$org$apache$avalon$framework$component$Composable == null ? (class$org$apache$avalon$framework$component$Composable = TypeVerifier.class$("org.apache.avalon.framework.component.Composable")) : class$org$apache$avalon$framework$component$Composable).isAssignableFrom(implementation) || (class$org$apache$avalon$framework$component$Recomposable == null ? (class$org$apache$avalon$framework$component$Recomposable = TypeVerifier.class$("org.apache.avalon.framework.component.Recomposable")) : class$org$apache$avalon$framework$component$Recomposable).isAssignableFrom(implementation);
        boolean serviceable = (class$org$apache$avalon$framework$service$Serviceable == null ? (class$org$apache$avalon$framework$service$Serviceable = TypeVerifier.class$("org.apache.avalon.framework.service.Serviceable")) : class$org$apache$avalon$framework$service$Serviceable).isAssignableFrom(implementation);
        if (serviceable && composable) {
            String message = REZ.getString("verifier.incompat-serviceable.error", (Object)name, (Object)implementation.getName());
            throw new VerifyException(message);
        }
    }

    public void verifyServiceIsaInterface(String name, Class clazz) throws VerifyException {
        if (!clazz.isInterface()) {
            String message = REZ.getString("verifier.non-interface-service.error", (Object)name, (Object)clazz.getName());
            throw new VerifyException(message);
        }
    }

    public void verifyServiceIsPublic(String name, Class clazz) throws VerifyException {
        boolean isPublic = Modifier.isPublic(clazz.getModifiers());
        if (!isPublic) {
            String message = REZ.getString("verifier.non-public-service.error", (Object)name, (Object)clazz.getName());
            throw new VerifyException(message);
        }
    }

    public void verifyServiceNotALifecycle(String name, Class clazz) throws VerifyException {
        for (int i = 0; i < FRAMEWORK_CLASSES.length; ++i) {
            Class lifecycle = FRAMEWORK_CLASSES[i];
            if (!lifecycle.isAssignableFrom(clazz)) continue;
            String message = REZ.getString("verifier.service-isa-lifecycle.error", (Object)name, (Object)clazz.getName(), (Object)lifecycle.getName());
            throw new VerifyException(message);
        }
    }

    public void verifyPublicConstructor(String name, Class clazz) throws VerifyException {
        Constructor<?>[] ctors = clazz.getConstructors();
        if (ctors.length < 1) {
            String message = REZ.getString("verifier.non-public-ctor.error", (Object)name, (Object)clazz.getName());
            throw new VerifyException(message);
        }
    }

    public void verifyNonAbstract(String name, Class clazz) throws VerifyException {
        boolean isAbstract = Modifier.isAbstract(clazz.getModifiers());
        if (isAbstract) {
            String message = REZ.getString("verifier.abstract-class.error", (Object)name, (Object)clazz.getName());
            throw new VerifyException(message);
        }
    }

    public void verifyPublic(String name, Class clazz) throws VerifyException {
        boolean isPublic = Modifier.isPublic(clazz.getModifiers());
        if (!isPublic) {
            String message = REZ.getString("verifier.nonpublic-class.error", (Object)name, (Object)clazz.getName());
            throw new VerifyException(message);
        }
    }

    public void verifyNonPrimitive(String name, Class clazz) throws VerifyException {
        if (clazz.isPrimitive()) {
            String message = REZ.getString("verifier.primitive-class.error", (Object)name, (Object)clazz.getName());
            throw new VerifyException(message);
        }
    }

    public void verifyNonInterface(String name, Class clazz) throws VerifyException {
        if (clazz.isInterface()) {
            String message = REZ.getString("verifier.interface-class.error", (Object)name, (Object)clazz.getName());
            throw new VerifyException(message);
        }
    }

    public void verifyNonArray(String name, Class clazz) throws VerifyException {
        if (clazz.isArray()) {
            String message = REZ.getString("verifier.array-class.error", (Object)name, (Object)clazz.getName());
            throw new VerifyException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

