/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.avalon.meta.info.CategoryDescriptor;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.Descriptor;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.meta.info.ExtensionDescriptor;
import org.apache.avalon.meta.info.InfoDescriptor;
import org.apache.avalon.meta.info.PermissionDescriptor;
import org.apache.avalon.meta.info.SecurityDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.info.writer.TypeWriter;

public class XMLTypeWriter
implements TypeWriter {
    private static final String CONTEXT_CLASS = "org.apache.avalon.framework.context.Context";

    public void writeType(Type type, OutputStream outputStream) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        this.writeHeader(writer);
        this.writeDoctype(writer, "type");
        writer.write("\n\n<type>");
        this.writeInfo(writer, type.getInfo());
        this.writeSecurity(writer, type.getSecurity());
        this.writeLoggers(writer, type.getCategories());
        this.writeContext(writer, type.getContext());
        this.writeServices(writer, type.getServices());
        this.writeDependencies(writer, type.getDependencies());
        this.writeStages(writer, type.getStages());
        this.writeExtensions(writer, type.getExtensions());
        writer.write("\n</type>");
        ((Writer)writer).flush();
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
    }

    private void writeDoctype(Writer writer, String root) throws IOException {
        String doctype = "\n<!DOCTYPE " + root + " PUBLIC \"-//AVALON/Type DTD Version 1.0//EN\" " + "\"http://avalon.apache.org/dtds/meta/type_1_1.dtd\" >";
        writer.write(doctype);
    }

    private void writeInfo(Writer writer, InfoDescriptor info) throws IOException {
        writer.write("\n  <info>");
        writer.write("\n    <name>");
        writer.write(info.getName());
        writer.write("</name>");
        writer.write("\n    <version>");
        writer.write(info.getVersion().toString());
        writer.write("</version>");
        if (info.getConfigurationSchema() != null) {
            writer.write("\n    <schema>");
            writer.write(info.getConfigurationSchema());
            writer.write("</schema>");
        }
        writer.write("\n    <lifestyle>");
        writer.write(info.getLifestyle());
        writer.write("</lifestyle>");
        writer.write("\n    <collection>");
        writer.write(InfoDescriptor.getCollectionPolicyKey((int)info.getCollectionPolicy()));
        writer.write("</collection>");
        if (0 == info.getAttributeNames().length) {
            writer.write("\n  </info>");
        } else {
            this.writeAttributes(writer, (Descriptor)info);
            writer.write("\n  </info>");
        }
    }

    private void writeSecurity(Writer writer, SecurityDescriptor descriptor) throws IOException {
        PermissionDescriptor[] permissions = descriptor.getPermissions();
        if (0 == descriptor.getAttributeNames().length && 0 == permissions.length) {
            return;
        }
        writer.write("\n  <security>");
        for (int i = 0; i < permissions.length; ++i) {
            this.writePermission(writer, permissions[i]);
        }
        writer.write("\n  </security>");
    }

    private void writePermission(Writer writer, PermissionDescriptor permission) throws IOException {
        writer.write("\n    <permission class=\"");
        writer.write(permission.getClassname());
        writer.write("\" ");
        if (null != permission.getName()) {
            writer.write("name=\"");
            writer.write(permission.getName());
            writer.write("\"");
        }
        if (0 == permission.getActions().length) {
            writer.write("/>");
        } else {
            writer.write(">");
            String[] actions = permission.getActions();
            for (int i = 0; i < actions.length; ++i) {
                String action = actions[i];
                writer.write("\n      <action>");
                writer.write(action);
                writer.write("</action>");
            }
            writer.write("\n    </permission>");
        }
    }

    private void writeLoggers(Writer writer, CategoryDescriptor[] loggers) throws IOException {
        if (0 == loggers.length) {
            return;
        }
        writer.write("\n  <loggers>");
        for (int i = 0; i < loggers.length; ++i) {
            this.writeLogger(writer, loggers[i]);
        }
        writer.write("\n  </loggers>");
    }

    private void writeLogger(Writer writer, CategoryDescriptor logger) throws IOException {
        writer.write("\n    <logger name=\"");
        writer.write(logger.getName());
        if (0 == logger.getAttributeNames().length) {
            writer.write("\"/>");
        } else {
            writer.write("\">");
            this.writeAttributes(writer, (Descriptor)logger);
            writer.write("\n    </logger>");
        }
    }

    private void writeContext(Writer writer, ContextDescriptor context) throws IOException {
        String type = context.getContextInterfaceClassname();
        EntryDescriptor[] entrys = context.getEntries();
        int count = context.getAttributeNames().length;
        if (CONTEXT_CLASS.equals(type) && 0 == count && 0 == entrys.length) {
            return;
        }
        writer.write("\n  <context");
        if (!CONTEXT_CLASS.equals(type)) {
            writer.write(" type=\"");
            writer.write(type);
            writer.write("\"");
        }
        if (0 == count && 0 == entrys.length) {
            writer.write("/>");
        } else {
            writer.write(">");
            for (int i = 0; i < entrys.length; ++i) {
                this.writeEntry(writer, entrys[i]);
            }
            this.writeAttributes(writer, (Descriptor)context);
            writer.write("\n  </context>");
        }
    }

    private void writeEntry(Writer writer, EntryDescriptor entry) throws IOException {
        writer.write("\n    <entry key=\"");
        writer.write(entry.getKey());
        writer.write("\" ");
        if (!entry.getClassname().equals("java.lang.String")) {
            writer.write("type=\"");
            writer.write(entry.getClassname());
            writer.write("\" ");
        }
        if (entry.getAlias() != null && !entry.getAlias().equals(entry.getKey())) {
            writer.write("alias=\"");
            writer.write(entry.getAlias());
            writer.write("\" ");
        }
        if (entry.isOptional()) {
            writer.write("optional=\"true\" ");
        }
        if (entry.isVolatile()) {
            writer.write("volatile=\"true\" ");
        }
        writer.write("/>");
    }

    private void writeServices(Writer writer, ServiceDescriptor[] services) throws IOException {
        if (0 == services.length) {
            return;
        }
        writer.write("\n  <services>");
        for (int i = 0; i < services.length; ++i) {
            int count;
            ServiceDescriptor service = services[i];
            writer.write("\n    <service type=\"");
            writer.write(service.getReference().getClassname());
            if (service.getReference().getVersion().getMajor() > -1) {
                writer.write("\" version=\"");
                writer.write(service.getReference().getVersion().toString());
            }
            if (0 == (count = service.getAttributeNames().length)) {
                writer.write("\"/>");
                continue;
            }
            writer.write("\">");
            this.writeAttributes(writer, (Descriptor)service);
            writer.write("\n    </service>");
        }
        writer.write("\n  </services>");
    }

    private void writeDependencies(Writer writer, DependencyDescriptor[] dependencies) throws IOException {
        if (0 == dependencies.length) {
            return;
        }
        writer.write("\n  <dependencies>");
        for (int i = 0; i < dependencies.length; ++i) {
            int count;
            DependencyDescriptor dependency = dependencies[i];
            writer.write("\n    <dependency ");
            if (!dependency.getKey().equals(dependency.getReference().getClassname())) {
                writer.write("key=\"");
                writer.write(dependency.getKey());
                writer.write("\" ");
            }
            writer.write("type=\"");
            writer.write(dependency.getReference().getClassname());
            if (dependency.getReference().getVersion().getMajor() > -1) {
                writer.write("\" version=\"");
                writer.write(dependency.getReference().getVersion().toString());
            }
            if (dependency.isOptional()) {
                writer.write("\" optional=\"true");
            }
            if (dependency.getPosition() > -1) {
                writer.write("\" index=\"" + dependency.getPosition());
            }
            if (0 == (count = dependency.getAttributeNames().length)) {
                writer.write("\"/>");
                continue;
            }
            writer.write("\">");
            this.writeAttributes(writer, (Descriptor)dependency);
            writer.write("\n    </dependency>");
        }
        writer.write("\n  </dependencies>");
    }

    private void writeAttributes(Writer writer, Descriptor descriptor) throws IOException {
        String[] names = descriptor.getAttributeNames();
        if (names.length > 0) {
            writer.write("\n    <attributes>");
            for (int i = 0; i < names.length; ++i) {
                this.writeAttribute(writer, names[i], descriptor.getAttribute(names[i]));
            }
            writer.write("\n    </attributes>");
        }
    }

    private void writeAttribute(Writer writer, String key, String value) throws IOException {
        writer.write("\n      <attribute key=\"");
        writer.write(key);
        writer.write("\" value=\"");
        writer.write(value);
        writer.write("\"/>");
    }

    private void writeStages(Writer writer, StageDescriptor[] stages) throws IOException {
        if (0 == stages.length) {
            return;
        }
        writer.write("\n  <stages>");
        for (int i = 0; i < stages.length; ++i) {
            StageDescriptor stage = stages[i];
            writer.write("\n    <stage ");
            writer.write("id=\"");
            writer.write(stage.getKey());
            int count = stage.getAttributeNames().length;
            if (0 == count) {
                writer.write("\"/>");
                continue;
            }
            writer.write("\">");
            this.writeAttributes(writer, (Descriptor)stage);
            writer.write("\n    </stage>");
        }
        writer.write("\n  </stages>");
    }

    private void writeExtensions(Writer writer, ExtensionDescriptor[] extensions) throws IOException {
        if (0 == extensions.length) {
            return;
        }
        writer.write("\n  <extensions>");
        for (int i = 0; i < extensions.length; ++i) {
            ExtensionDescriptor extension = extensions[i];
            writer.write("\n    <extension ");
            writer.write("id=\"");
            writer.write(extension.getKey());
            int count = extension.getAttributeNames().length;
            if (0 == count) {
                writer.write("\"/>");
                continue;
            }
            writer.write("\">");
            this.writeAttributes(writer, (Descriptor)extension);
            writer.write("\n    </extension>");
        }
        writer.write("\n  </extensions>");
    }
}

