/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.util.Properties;
import org.apache.avalon.defaults.Defaults;
import org.apache.avalon.defaults.DefaultsFinder;
import org.apache.avalon.defaults.SimpleDefaultsFinder;
import org.apache.avalon.defaults.SystemDefaultsFinder;
import org.apache.avalon.repository.ProxyContext;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryConfig;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.RepositoryFactory;
import org.apache.avalon.repository.impl.DefaultFileRepository;

public class DefaultFactory
implements RepositoryFactory {
    public static final String DEFAULTS = "repository.properties";
    private static final String[] s_singles = new String[]{"local.repository.path", "proxyHost", "proxyPort", "proxyUsername", "proxyPassword"};
    public static final String LOCAL_BASE = s_singles[0];
    public static final String PROXY_HOST = s_singles[1];
    public static final String PROXY_PORT = s_singles[2];
    public static final String PROXY_USERNAME = s_singles[3];
    public static final String PROXY_PASSWORD = s_singles[4];
    public static final String[] s_multiple = new String[]{"remote.repository.url"};
    public static final String REMOTE_REPO_BASE = s_multiple[0];
    static /* synthetic */ Class class$org$apache$avalon$repository$Repository;

    public RepositoryConfig getDefaultConfig() throws RepositoryException {
        Properties l_bootstrap = new Properties();
        ProxyContext l_proxy = null;
        RepositoryConfig l_config = new RepositoryConfig();
        InputStream l_in = (class$org$apache$avalon$repository$Repository == null ? (class$org$apache$avalon$repository$Repository = DefaultFactory.class$("org.apache.avalon.repository.Repository")) : class$org$apache$avalon$repository$Repository).getResourceAsStream(DEFAULTS);
        try {
            l_bootstrap.load(l_in);
            String l_userHome = System.getProperty("user.home");
            File l_user = new File(l_userHome, ".repository.properties");
            if (l_user.exists()) {
                l_in = new FileInputStream(l_user);
                l_bootstrap.load(l_in);
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to load defaults", (Throwable)e);
        }
        DefaultsFinder[] l_finders = new DefaultsFinder[]{new SimpleDefaultsFinder(new Properties[]{l_bootstrap}, false), new SystemDefaultsFinder()};
        final Defaults l_defaults = new Defaults(s_singles, s_multiple, l_finders);
        Defaults.macroExpand((Properties)l_defaults, null);
        l_config.setLocalRepository(l_defaults.getProperty(LOCAL_BASE));
        try {
            l_config.setRemoteRepositoryUrls(l_defaults.getEnumerated(REMOTE_REPO_BASE));
        }
        catch (MalformedURLException e) {
            throw new RepositoryException("Failed to set remote repos", (Throwable)e);
        }
        if (l_defaults.containsKey(PROXY_HOST)) {
            int l_port = Integer.parseInt(l_defaults.getProperty(PROXY_PORT));
            String l_host = l_defaults.getProperty(PROXY_HOST);
            Authenticator l_authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    PasswordAuthentication l_pwdAuth = new PasswordAuthentication(l_defaults.getProperty(PROXY_USERNAME), l_defaults.getProperty(PROXY_PASSWORD).toCharArray());
                    return l_pwdAuth;
                }
            };
            l_proxy = new ProxyContext(l_host, l_port, l_authenticator);
        }
        l_config.setProxyContext(l_proxy);
        return l_config;
    }

    public Repository create(RepositoryConfig a_config) {
        DefaultFileRepository l_repository = null;
        File l_base = new File(a_config.getLocalRepository());
        if (null == a_config.getProxyContext() && null == a_config.getRemoteRepositories()) {
            l_repository = new DefaultFileRepository(l_base);
        } else if (null == a_config.getProxyContext()) {
            l_repository = new DefaultFileRepository(l_base, a_config.getRemoteRepositories());
        }
        l_repository = new DefaultFileRepository(l_base, a_config.getProxyContext(), a_config.getRemoteRepositories());
        return l_repository;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

