/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.avalon.repository.BlockManifest;
import org.apache.avalon.repository.ProxyContext;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.impl.DefaultBlockManifest;
import org.apache.avalon.repository.impl.HttpController;

public class DefaultFileRepository
implements Repository {
    private final File m_base;
    private final URL[] m_hosts;

    public DefaultFileRepository(File base) {
        this(base, null, new URL[0]);
    }

    public DefaultFileRepository(File base, URL[] hosts) {
        this(base, null, hosts);
    }

    public DefaultFileRepository(File base, ProxyContext context, URL[] hosts) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        this.m_base = base;
        if (hosts == null) {
            this.m_hosts = new URL[0];
        } else {
            this.m_hosts = new URL[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                URL url = hosts[i];
                String path = url.toString();
                if (!path.endsWith("/")) {
                    try {
                        this.m_hosts[i] = new URL(path + "/");
                        continue;
                    }
                    catch (Throwable e) {
                        String error = "Could not coerce supplied URL to a directory reference: " + path;
                        throw new IllegalArgumentException(error);
                    }
                }
                this.m_hosts[i] = hosts[i];
            }
        }
        if (context != null) {
            ((Hashtable)System.getProperties()).put("proxySet", "true");
            ((Hashtable)System.getProperties()).put("proxyHost", context.getHost());
            ((Hashtable)System.getProperties()).put("proxyPort", context.getPort());
            if (context.getAuthenticator() != null) {
                Authenticator.setDefault(context.getAuthenticator());
            }
        }
    }

    public String getLocation() {
        return this.m_base.toString();
    }

    public BlockManifest install(URL url, StringBuffer buffer) throws RepositoryException {
        String path = url.getFile();
        try {
            File temp = File.createTempFile("avalon-", "-bar");
            temp.delete();
            HttpController.getFile(url.toString(), temp, true);
            temp.deleteOnExit();
            return this.expand(temp.toURL(), buffer);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Throwable e) {
            String error = "Cannot install target: " + url;
            throw new RepositoryException(error, e);
        }
    }

    private BlockManifest expand(URL url, StringBuffer buffer) throws RepositoryException {
        try {
            URL jurl = new URL("jar:" + url.toString() + "!/");
            JarURLConnection connection = (JarURLConnection)jurl.openConnection();
            DefaultBlockManifest manifest = new DefaultBlockManifest(connection.getManifest());
            String group = manifest.getBlockGroup();
            buffer.append("\nBlock Group: " + group);
            File root = new File(this.m_base, group);
            buffer.append("\nLocal target: " + root);
            JarFile jar = connection.getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().startsWith("META-INF")) continue;
                this.installEntry(buffer, root, jar, entry);
            }
            buffer.append("\nInstall successful.");
            return manifest;
        }
        catch (Throwable e) {
            String error = "Could not install block: " + url;
            throw new RepositoryException(error, e);
        }
    }

    public URL getArtifact(String artifact, String version, String type) throws RepositoryException {
        int n = this.verify(artifact);
        String group = this.getGroupName(artifact, n);
        String name = this.getResourceName(artifact, n);
        return this.getArtifact(group, name, version, type);
    }

    public URL getArtifact(String group, String name, String version, String type) throws RepositoryException {
        if (this.m_hosts == null) {
            throw new IllegalStateException("hosts");
        }
        if (group == null) {
            throw new NullPointerException("group");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        String path = group + "/" + type + "s/" + name;
        if (version != null && version.length() != 0) {
            path = path + "-" + version;
        }
        path = path + "." + type;
        RepositoryException repositoryException = null;
        try {
            return this.getLocalArtifact(group, name, version, type);
        }
        catch (RepositoryException e) {
            repositoryException = e;
            for (int i = 0; i < this.m_hosts.length; ++i) {
                URL source = this.m_hosts[i];
                String host = source.toString();
                File local = new File(this.m_base, path);
                String url = host + path;
                try {
                    if (!HttpController.getFile(url, local, true)) continue;
                    return this.getLocalArtifact(group, name, version, type);
                }
                catch (Throwable anything) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to resolve artifact: " + path;
            throw new RepositoryException(error, e);
        }
        throw repositoryException;
    }

    private URL getLocalArtifact(String group, String name, String version, String type) throws RepositoryException {
        File resource;
        File application = new File(this.m_base, group);
        if (!application.exists()) {
            String error = "Unknown group: '" + group + "' relative to the repository base: '" + this.m_base + "'.";
            throw new RepositoryException(error);
        }
        File types = new File(application, type + "s");
        if (!types.exists()) {
            String error = "No resources of the type: '" + type + "' in the group: '" + group + "'. File: '" + types + "'.";
            throw new RepositoryException(error);
        }
        String resourceName = name;
        if (version != null && version.length() != 0) {
            resourceName = resourceName + "-" + version;
        }
        if (!(resource = new File(types, resourceName + "." + type)).exists()) {
            String error = "No resources of the type: '" + type + "' in the group: '" + group + "' with the name: '" + name + "' and version: '" + version + ". File: '" + resource + "'.";
            throw new RepositoryException(error);
        }
        try {
            return resource.toURL();
        }
        catch (Throwable e) {
            String error = "Unable to resolve URL for resource: " + resource;
            throw new RepositoryException(error);
        }
    }

    private int verify(String artifact) throws RepositoryException {
        int n = artifact.indexOf(":");
        if (n < 1) {
            String error = "Invalid artifact name: " + artifact;
            throw new RepositoryException(error);
        }
        return n;
    }

    private String getGroupName(String artifact, int index) {
        return artifact.substring(0, index);
    }

    private String getResourceName(String artifact, int index) {
        return artifact.substring(index + 1);
    }

    private void installEntry(StringBuffer buffer, File root, JarFile jar, ZipEntry entry) throws Exception {
        int length;
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        File file = new File(root, name);
        long timestamp = entry.getTime();
        if (file.exists()) {
            if (file.lastModified() == timestamp) {
                buffer.append("\nEntry: " + name + " (already exists)");
                return;
            }
            if (file.lastModified() > timestamp) {
                buffer.append("\nEntry: " + name + " (local version is more recent)");
                return;
            }
            buffer.append("\nEntry: " + name + " (updating local version)");
        } else {
            buffer.append("\nEntry: " + name);
        }
        InputStream is = jar.getInputStream(entry);
        if (is == null) {
            String error = "Entry returned a null input stream: " + name;
            buffer.append("\n  " + error);
            throw new IOException(error);
        }
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buf = new byte[102400];
        while ((length = is.read(buf)) >= 0) {
            fos.write(buf, 0, length);
        }
        fos.close();
        is.close();
        if (timestamp < 0L) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            file.setLastModified(timestamp);
        }
    }
}

