/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.impl.DefaultBlockManifest;
import org.apache.avalon.repository.impl.DefaultRepository;
import org.apache.avalon.repository.impl.ProxyContext;
import org.apache.avalon.repository.provider.BlockManifest;
import org.apache.avalon.repository.provider.CacheManager;
import org.apache.avalon.repository.util.LoaderUtils;

public class DefaultCacheManager
implements CacheManager {
    private final File m_base;
    private final String[] m_hosts;

    public DefaultCacheManager(File base, ProxyContext context, String[] hosts) {
        if (null == base) {
            throw new NullPointerException("base");
        }
        this.m_base = base;
        this.m_hosts = hosts;
        if (context != null) {
            ((Hashtable)System.getProperties()).put("proxySet", "true");
            ((Hashtable)System.getProperties()).put("proxyHost", context.getHost());
            ((Hashtable)System.getProperties()).put("proxyPort", context.getPort());
            if (context.getAuthenticator() != null) {
                Authenticator.setDefault(context.getAuthenticator());
            }
        }
    }

    public File getCacheDirectory() {
        return this.m_base;
    }

    public String[] getDefaultHosts() {
        return this.m_hosts;
    }

    public Repository createRepository() {
        return this.createRepository(this.m_hosts);
    }

    public Repository createRepository(String[] hosts) {
        return new DefaultRepository(this, hosts);
    }

    public BlockManifest install(URL url, StringBuffer buffer) throws RepositoryException {
        String path = url.getFile();
        try {
            File temp = File.createTempFile("avalon-", "-bar");
            temp.delete();
            LoaderUtils.getResource((String)url.toString(), (File)temp, (boolean)true);
            temp.deleteOnExit();
            return this.expand(temp.toURL(), buffer);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Throwable e) {
            String error = "Cannot install target: " + url;
            throw new RepositoryException(error, e);
        }
    }

    public String toString() {
        return "cache:" + this.m_base.toString();
    }

    private BlockManifest expand(URL url, StringBuffer buffer) throws RepositoryException {
        try {
            URL jurl = new URL("jar:" + url.toString() + "!/");
            JarURLConnection connection = (JarURLConnection)jurl.openConnection();
            DefaultBlockManifest manifest = new DefaultBlockManifest(connection.getManifest());
            String group = manifest.getBlockGroup();
            buffer.append("\nBlock Group: " + group);
            File root = new File(this.m_base, group);
            buffer.append("\nLocal target: " + root);
            JarFile jar = connection.getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().startsWith("META-INF")) continue;
                this.installEntry(buffer, root, jar, entry);
            }
            buffer.append("\nInstall successful.");
            return manifest;
        }
        catch (Throwable e) {
            String error = "Could not install block: " + url;
            throw new RepositoryException(error, e);
        }
    }

    private void installEntry(StringBuffer buffer, File root, JarFile jar, ZipEntry entry) throws Exception {
        int length;
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        File file = new File(root, name);
        long timestamp = entry.getTime();
        if (file.exists()) {
            if (file.lastModified() == timestamp) {
                buffer.append("\nEntry: " + name + " (already exists)");
                return;
            }
            if (file.lastModified() > timestamp) {
                buffer.append("\nEntry: " + name + " (local version is more recent)");
                return;
            }
            buffer.append("\nEntry: " + name + " (updating local version)");
        } else {
            buffer.append("\nEntry: " + name);
        }
        InputStream is = jar.getInputStream(entry);
        if (is == null) {
            String error = "Entry returned a null input stream: " + name;
            buffer.append("\n  " + error);
            throw new IOException(error);
        }
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buf = new byte[102400];
        while ((length = is.read(buf)) >= 0) {
            fos.write(buf, 0, length);
        }
        fos.close();
        is.close();
        if (timestamp < 0L) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            file.setLastModified(timestamp);
        }
    }
}

