/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.impl;

import java.io.File;
import java.util.Map;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.repository.RepositoryRuntimeException;
import org.apache.avalon.repository.impl.DefaultAuthenticator;
import org.apache.avalon.repository.impl.DefaultCacheManager;
import org.apache.avalon.repository.impl.DefaultRepositoryCriteria;
import org.apache.avalon.repository.impl.ProxyContext;
import org.apache.avalon.repository.provider.Factory;
import org.apache.avalon.repository.provider.InitialContext;

public class DefaultFactory
implements Factory {
    private static Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$repository$impl$DefaultFactory == null ? (class$org$apache$avalon$repository$impl$DefaultFactory = DefaultFactory.class$("org.apache.avalon.repository.impl.DefaultFactory")) : class$org$apache$avalon$repository$impl$DefaultFactory));
    private String[] m_hosts;
    private final InitialContext m_context;
    static /* synthetic */ Class class$org$apache$avalon$repository$impl$DefaultFactory;

    public DefaultFactory(InitialContext context) {
        if (null == context) {
            throw new NullPointerException("context");
        }
        this.m_context = context;
    }

    public Map createDefaultCriteria() {
        try {
            return new DefaultRepositoryCriteria(this.m_context);
        }
        catch (Throwable e) {
            String error = "Could not create default factory criteria.";
            throw new RepositoryRuntimeException("Could not create default factory criteria.", e);
        }
    }

    public Object create() throws Exception {
        return this.create(this.createDefaultCriteria());
    }

    public Object create(Map map) throws Exception {
        if (null == map) {
            throw new NullPointerException("map");
        }
        File root = this.getCache(map);
        String[] hosts = this.getHosts(map);
        ProxyContext proxy = this.createProxyContext(map);
        return new DefaultCacheManager(root, proxy, hosts);
    }

    private File getCache(Map map) {
        return (File)map.get("avalon.repository.cache");
    }

    private String[] getHosts(Map map) {
        return (String[])map.get("avalon.repository.hosts");
    }

    private ProxyContext createProxyContext(Map map) {
        String proxyHostName = (String)map.get("avalon.repository.proxy.host");
        if (null == proxyHostName) {
            return null;
        }
        String proxyUsername = (String)map.get("avalon.repository.proxy.username");
        String proxyPassword = (String)map.get("avalon.repository.proxy.password");
        DefaultAuthenticator authenticator = new DefaultAuthenticator(proxyUsername, proxyPassword);
        Integer proxyPort = (Integer)map.get("avalon.repository.proxy.port");
        if (null == proxyPort) {
            proxyPort = new Integer(0);
        }
        return new ProxyContext(proxyHostName, proxyPort, authenticator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

