/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.impl;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import javax.naming.directory.Attributes;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.RepositoryRuntimeException;
import org.apache.avalon.repository.meta.FactoryDescriptor;
import org.apache.avalon.repository.meta.MetaException;
import org.apache.avalon.repository.provider.CacheManager;
import org.apache.avalon.repository.util.LoaderUtils;
import org.apache.avalon.repository.util.RepositoryUtils;

public class DefaultRepository
implements Repository {
    private final URL[] m_hosts;
    private final String[] m_roots;
    private final CacheManager m_cache;

    public DefaultRepository(CacheManager cache, String[] hosts) {
        if (cache == null) {
            throw new NullPointerException("cache");
        }
        if (hosts == null) {
            throw new NullPointerException("hosts");
        }
        this.m_cache = cache;
        this.m_roots = RepositoryUtils.getCleanPaths((String[])hosts);
        this.m_hosts = this.getHosts(this.m_roots);
    }

    public Attributes getAttributes(Artifact artifact) throws RepositoryException {
        if (null == artifact) {
            throw new NullPointerException("artifact");
        }
        try {
            return RepositoryUtils.getAsAttributes((Properties)RepositoryUtils.getProperties((URL)this.getResource(artifact, "meta")));
        }
        catch (Throwable e) {
            String error = "Unable to retrieve the metadata for the artifact :" + artifact;
            throw new RepositoryException(error, e);
        }
    }

    public URL getResource(Artifact artifact) throws RepositoryException {
        return LoaderUtils.getResource((Artifact)artifact, (String[])this.m_roots, (File)this.m_cache.getCacheDirectory(), (boolean)true);
    }

    private URL getResource(Artifact artifact, String mime) throws RepositoryException {
        return LoaderUtils.getResource((Artifact)artifact, (String)mime, (String[])this.m_roots, (File)this.m_cache.getCacheDirectory(), (boolean)true);
    }

    public ClassLoader getClassLoader(Artifact artifact) throws RepositoryException {
        return this.getClassLoader(ClassLoader.getSystemClassLoader(), artifact);
    }

    public ClassLoader getClassLoader(ClassLoader parent, Artifact artifact) throws RepositoryException {
        if (null == parent) {
            throw new NullPointerException("parent");
        }
        if (null == artifact) {
            throw new NullPointerException("artifact");
        }
        Attributes attributes = this.getAttributes(artifact);
        FactoryDescriptor relational = null;
        try {
            relational = new FactoryDescriptor(attributes);
        }
        catch (MetaException me) {
            String error = "Could not create a relational descriptor from the artifact: " + artifact;
            throw new RepositoryException(error, (Throwable)me);
        }
        URL[] apis = this.getURLs(relational.getDependencies("avalon.artifact.dependency.api"));
        ClassLoader api = this.buildClassLoader(apis, parent);
        URL[] spis = this.getURLs(relational.getDependencies("avalon.artifact.dependency.spi"));
        ClassLoader spi = this.buildClassLoader(spis, api);
        URL[] imps = this.getURLs(artifact, relational.getDependencies("avalon.artifact.dependency"));
        return this.buildClassLoader(imps, spi);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.m_cache.toString());
        for (int i = 0; i < this.m_hosts.length; ++i) {
            buffer.append(", ");
            buffer.append(this.m_hosts[i]);
        }
        return buffer.toString();
    }

    private URL[] getHosts(String[] paths) {
        URL[] hosts = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            try {
                hosts[i] = new URL(path);
                continue;
            }
            catch (Throwable e) {
                String error = "Internal error while attempting to construct url for host: " + path;
                throw new RepositoryRuntimeException(error, e);
            }
        }
        return hosts;
    }

    private ClassLoader buildClassLoader(URL[] urls, ClassLoader parent) {
        if (0 == urls.length) {
            return parent;
        }
        return new URLClassLoader(urls, parent);
    }

    private URL[] getURLs(Artifact[] artifacts) throws RepositoryException {
        URL[] urls = new URL[artifacts.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = this.getResource(artifacts[i]);
        }
        return urls;
    }

    private URL[] getURLs(Artifact primary, Artifact[] artifacts) throws RepositoryException {
        URL[] urls = new URL[artifacts.length + 1];
        for (int i = 0; i < artifacts.length; ++i) {
            urls[i] = this.getResource(artifacts[i]);
        }
        urls[artifacts.length] = this.getResource(primary);
        return urls;
    }
}

