/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.impl;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.criteria.Criteria;
import org.apache.avalon.util.criteria.PackedParameter;
import org.apache.avalon.util.criteria.Parameter;
import org.apache.avalon.util.defaults.Defaults;
import org.apache.avalon.util.defaults.DefaultsFinder;
import org.apache.avalon.util.defaults.SimpleDefaultsFinder;
import org.apache.avalon.util.defaults.SystemDefaultsFinder;

public class DefaultRepositoryCriteria
extends Criteria {
    public static final String REPOSITORY_CACHE_DIR = "avalon.repository.cache";
    private static final Parameter REPOSITORY_CACHE_DIR_PARAM = new Parameter("avalon.repository.cache", class$java$io$File == null ? (class$java$io$File = DefaultRepositoryCriteria.class$("java.io.File")) : class$java$io$File, null);
    public static final String REPOSITORY_PROXY_HOST = "avalon.repository.proxy.host";
    private static final Parameter REPOSITORY_PROXY_HOST_PARAM = new Parameter("avalon.repository.proxy.host", class$java$lang$String == null ? (class$java$lang$String = DefaultRepositoryCriteria.class$("java.lang.String")) : class$java$lang$String, null);
    public static final String REPOSITORY_PROXY_PORT = "avalon.repository.proxy.port";
    private static final Parameter REPOSITORY_PROXY_PORT_PARAM = new Parameter("avalon.repository.proxy.port", class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultRepositoryCriteria.class$("java.lang.Integer")) : class$java$lang$Integer, null);
    public static final String REPOSITORY_PROXY_USERNAME = "avalon.repository.proxy.username";
    private static final Parameter REPOSITORY_PROXY_USERNAME_PARAM = new Parameter("avalon.repository.proxy.username", class$java$lang$String == null ? (class$java$lang$String = DefaultRepositoryCriteria.class$("java.lang.String")) : class$java$lang$String, null);
    public static final String REPOSITORY_PROXY_PASSWORD = "avalon.repository.proxy.password";
    private static final Parameter REPOSITORY_PROXY_PASSWORD_PARAM = new Parameter("avalon.repository.proxy.password", class$java$lang$String == null ? (class$java$lang$String = DefaultRepositoryCriteria.class$("java.lang.String")) : class$java$lang$String, null);
    public static final String REPOSITORY_REMOTE_HOSTS = "avalon.repository.hosts";
    public static final Parameter REPOSITORY_REMOTE_HOSTS_PARAM = new PackedParameter("avalon.repository.hosts", ",", null);
    public static final Parameter[] PARAMS = new Parameter[]{REPOSITORY_CACHE_DIR_PARAM, REPOSITORY_REMOTE_HOSTS_PARAM, REPOSITORY_PROXY_HOST_PARAM, REPOSITORY_PROXY_PORT_PARAM, REPOSITORY_PROXY_USERNAME_PARAM, REPOSITORY_PROXY_PASSWORD_PARAM};
    public static final String DEFAULTS = "avalon.properties";
    private static final String[] SINGLE_KEYS = Parameter.getKeys((Parameter[])PARAMS);
    public static final String[] MULTI_VALUE_KEYS = new String[0];
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$apache$avalon$repository$impl$DefaultRepositoryCriteria;

    public DefaultRepositoryCriteria(InitialContext context) throws RepositoryException {
        super(PARAMS);
        this.put(REPOSITORY_CACHE_DIR, context.getInitialCacheDirectory());
        this.put(REPOSITORY_REMOTE_HOSTS, context.getInitialHosts());
        Properties bootstrap = this.getDefaultProperties();
        DefaultsFinder[] finders = new DefaultsFinder[]{new SimpleDefaultsFinder(new Properties[]{bootstrap}, false), new SystemDefaultsFinder()};
        Defaults defaults = new Defaults(SINGLE_KEYS, MULTI_VALUE_KEYS, finders);
        Defaults.macroExpand((Properties)defaults, (Properties[])new Properties[]{System.getProperties()});
        String cache = defaults.getProperty(REPOSITORY_CACHE_DIR);
        if (null != cache) {
            this.put(REPOSITORY_CACHE_DIR, new File(cache));
        }
        try {
            String hosts = defaults.getProperty(REPOSITORY_REMOTE_HOSTS);
            if (null != hosts) {
                this.put(REPOSITORY_REMOTE_HOSTS, hosts);
            }
        }
        catch (Throwable e) {
            String error = "Failed to set remote repositories.";
            throw new RepositoryException("Failed to set remote repositories.", e);
        }
        if (defaults.containsKey(REPOSITORY_PROXY_HOST)) {
            this.put(REPOSITORY_PROXY_HOST, new Integer(defaults.getProperty(REPOSITORY_PROXY_HOST)));
            if (defaults.containsKey(REPOSITORY_PROXY_PORT)) {
                this.put(REPOSITORY_PROXY_PORT, new Integer(defaults.getProperty(REPOSITORY_PROXY_PORT)));
            }
            if (defaults.containsKey(REPOSITORY_PROXY_USERNAME)) {
                this.put(REPOSITORY_PROXY_USERNAME, defaults.getProperty(REPOSITORY_PROXY_USERNAME));
            }
            if (defaults.containsKey(REPOSITORY_PROXY_PASSWORD)) {
                this.put(REPOSITORY_PROXY_PASSWORD, defaults.getProperty(REPOSITORY_PROXY_PASSWORD));
            }
        }
    }

    public String toString() {
        return "[repository: " + super.toString() + "]";
    }

    private Properties getDefaultProperties() throws RepositoryException {
        try {
            return Defaults.getStaticProperties((Class)(class$org$apache$avalon$repository$impl$DefaultRepositoryCriteria == null ? (class$org$apache$avalon$repository$impl$DefaultRepositoryCriteria = DefaultRepositoryCriteria.class$("org.apache.avalon.repository.impl.DefaultRepositoryCriteria")) : class$org$apache$avalon$repository$impl$DefaultRepositoryCriteria), (String)DEFAULTS);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to load implementation defaults resource: avalon.properties", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

