/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.defaults;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.util.defaults.DefaultsFinder;

public class Defaults
extends Properties {
    private final String[] m_singles;
    private final String[] m_enumerated;
    private final DefaultsFinder[] m_finders;

    public Defaults(String[] a_singles, String[] a_enumerated, DefaultsFinder[] a_finders) {
        this.m_finders = a_finders;
        this.m_singles = a_singles;
        this.m_enumerated = a_enumerated;
        for (int ii = 0; ii < this.m_finders.length; ++ii) {
            this.m_finders[ii].find(this);
        }
    }

    public String[] getEnumerated() {
        return this.m_enumerated;
    }

    public DefaultsFinder[] getFinders() {
        return this.m_finders;
    }

    public String[] getSingles() {
        return this.m_singles;
    }

    public String[] getEnumerated(String a_base) {
        ArrayList<String> l_values = new ArrayList<String>();
        Enumeration l_list = ((Hashtable)this).keys();
        while (l_list.hasMoreElements()) {
            String l_key = (String)l_list.nextElement();
            if (!l_key.startsWith(a_base)) continue;
            l_values.add(this.getProperty(l_key));
        }
        return l_values.toArray(new String[0]);
    }

    public boolean getBoolean(String a_key) {
        String l_value = this.getProperty(a_key);
        return (l_value = l_value.trim().toLowerCase()).equals("1") || l_value.equals("on") || l_value.equals("yes") || l_value.equals("true");
    }

    public static void discover(Defaults a_defaults, Properties[] a_sources, boolean a_haltOnDiscovery) {
        int ii;
        if (null == a_sources || null == a_defaults) {
            return;
        }
        String[] l_keys = a_defaults.getSingles();
        for (ii = 0; ii < l_keys.length; ++ii) {
            String l_key = l_keys[ii];
            String l_value = Defaults.discover(l_key, a_sources, a_haltOnDiscovery);
            if (l_value == null) continue;
            a_defaults.setProperty(l_key, l_value);
        }
        l_keys = a_defaults.getEnumerated();
        for (ii = 0; ii < l_keys.length; ++ii) {
            String l_base = l_keys[ii];
            for (int jj = 0; jj < a_sources.length; ++jj) {
                Enumeration<?> l_list = a_sources[jj].propertyNames();
                while (l_list.hasMoreElements()) {
                    String l_value;
                    String l_key = (String)l_list.nextElement();
                    if (!l_key.startsWith(l_base) || (l_value = Defaults.discover(l_key, a_sources, a_haltOnDiscovery)) == null) continue;
                    a_defaults.setProperty(l_key, l_value);
                }
            }
        }
    }

    public static String discover(String l_key, Properties[] a_sources, boolean a_haltOnDiscovery) {
        String l_retval = null;
        for (int ii = 0; ii < a_sources.length; ++ii) {
            if (!((Hashtable)a_sources[ii]).containsKey(l_key)) continue;
            l_retval = a_sources[ii].getProperty(l_key);
            if (a_haltOnDiscovery) break;
        }
        return l_retval;
    }

    public static void macroExpand(Properties a_expanded, Properties[] a_optionals) {
        if (null == a_optionals) {
            a_optionals = new Properties[]{};
        }
        Enumeration<?> l_list = a_expanded.propertyNames();
        block0: while (l_list.hasMoreElements()) {
            int m;
            String l_key = (String)l_list.nextElement();
            String l_macro = a_expanded.getProperty(l_key);
            int n = l_macro.indexOf("${");
            if (n < 0 || (m = l_macro.indexOf("}", n + 2)) < 0) continue;
            String symbol = l_macro.substring(n + 2, m);
            if (((Hashtable)a_expanded).containsKey(symbol)) {
                String value = a_expanded.getProperty(symbol);
                String head = l_macro.substring(0, n);
                String tail = l_macro.substring(m + 1);
                String resolved = head + value + tail;
                ((Hashtable)a_expanded).put(l_key, resolved);
                continue;
            }
            for (int ii = 0; ii < a_optionals.length; ++ii) {
                if (!((Hashtable)a_optionals[ii]).containsKey(symbol)) continue;
                String value = a_optionals[ii].getProperty(symbol);
                String head = l_macro.substring(0, n);
                String tail = l_macro.substring(m + 1);
                String resolved = head + value + tail;
                ((Hashtable)a_expanded).put(l_key, resolved);
                continue block0;
            }
        }
    }

    public static Properties getStaticProperties(Class ref) throws IOException {
        Properties properties = new Properties();
        String address = ref.toString().replace('.', '/');
        String path = address + ".properties";
        InputStream input = ref.getResourceAsStream(path);
        if (null != input) {
            properties.load(input);
        }
        return properties;
    }

    public static Properties getStaticProperties(Class ref, String path) throws IOException {
        Properties bootstrap = new Properties();
        InputStream input = ref.getResourceAsStream(path);
        if (input == null) {
            String error = "Internal error, unable to locate enbedded resource: " + path + " from the resource: " + ref.getProtectionDomain().getCodeSource().getLocation();
            throw new IllegalStateException(error);
        }
        bootstrap.load(input);
        return bootstrap;
    }
}

