/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.i18n;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.apache.avalon.util.i18n.Resources;

public class ResourceManager {
    private static final RuntimePermission CLEAR_CACHE_PERMISSION = new RuntimePermission("i18n.clearCompleteCache");
    private static final HashMap c_resources = new HashMap();

    public static final Resources getBaseResources(String baseName) {
        return ResourceManager.getBaseResources(baseName, null);
    }

    public static final synchronized Resources getBaseResources(String baseName, ClassLoader classLoader) {
        Resources resources = ResourceManager.getCachedResource(baseName);
        if (null == resources) {
            resources = new Resources(baseName, classLoader);
            ResourceManager.putCachedResource(baseName, resources);
        }
        return resources;
    }

    public static final synchronized void clearResourceCache() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(CLEAR_CACHE_PERMISSION);
        }
        c_resources.clear();
    }

    private static final synchronized void putCachedResource(String baseName, Resources resources) {
        c_resources.put(baseName, new WeakReference<Resources>(resources));
    }

    private static final synchronized Resources getCachedResource(String baseName) {
        WeakReference weakReference = (WeakReference)c_resources.get(baseName);
        if (null == weakReference) {
            return null;
        }
        return (Resources)weakReference.get();
    }

    public static final Resources getResources(String name) {
        return ResourceManager.getBaseResources(name + ".Resources");
    }

    public static final Resources getPackageResources(Class clazz) {
        return ResourceManager.getBaseResources(ResourceManager.getPackageResourcesBaseName(clazz), clazz.getClassLoader());
    }

    public static final Resources getClassResources(Class clazz) {
        return ResourceManager.getBaseResources(ResourceManager.getClassResourcesBaseName(clazz), clazz.getClassLoader());
    }

    public static final String getPackageResourcesBaseName(Class clazz) {
        String name;
        Package pkg = clazz.getPackage();
        String baseName = null == pkg ? (-1 == (name = clazz.getName()).lastIndexOf(".") ? "Resources" : name.substring(0, name.lastIndexOf(".")) + ".Resources") : pkg.getName() + ".Resources";
        return baseName;
    }

    public static final String getClassResourcesBaseName(Class clazz) {
        return clazz.getName() + "Resources";
    }

    private ResourceManager() {
    }
}

