/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.appliance.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.appliance.ApplianceRepository;
import org.apache.avalon.assembly.appliance.CascadingIOException;

public class BlockURLConnection
extends URLConnection {
    private ApplianceRepository m_repository;
    private URL m_url;

    public BlockURLConnection(URL url, ApplianceRepository repository) {
        super(url);
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.m_repository = repository;
        this.m_url = url;
    }

    public void connect() throws IOException {
    }

    public Object getContent() throws IOException {
        return this.getContent(new Class[0]);
    }

    public Object getContent(Class[] classes) throws IOException {
        Appliance appliance = this.m_repository.resolveAppliance(this.m_url.getPath());
        String ref = this.m_url.getRef();
        try {
            return appliance.resolve((Object)this.m_url, ref);
        }
        catch (Throwable e) {
            String error = "URL content resolution error in: " + this.m_url;
            throw new CascadingIOException(error, e);
        }
    }
}

