/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.appliance.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.avalon.assembly.appliance.ApplianceRepository;
import org.apache.avalon.assembly.appliance.impl.BlockURLConnection;

public final class BlockURLHandler
extends URLStreamHandler {
    private ApplianceRepository m_repository;
    private boolean debug = false;

    public BlockURLHandler(ApplianceRepository repository) {
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        this.m_repository = repository;
    }

    protected URLConnection openConnection(URL url) throws IOException {
        return new BlockURLConnection(url, this.m_repository);
    }

    protected void parseURL(URL url, String spec, int start, int limit) {
        int port;
        String ref = url.getRef();
        String remainder = spec.substring(start, limit);
        int refLoc = spec.indexOf("#", start);
        if (refLoc > -1) {
            ref = spec.substring(refLoc + 1);
            remainder = spec.substring(start, refLoc);
        }
        String query = url.getQuery();
        int queryLoc = remainder.indexOf("?");
        if (queryLoc > -1) {
            query = remainder.substring(queryLoc + 1, remainder.length());
            remainder = remainder.substring(0, queryLoc);
        }
        if (remainder.startsWith("//")) {
            remainder = remainder.substring(2, remainder.length());
        }
        String path = url.getPath();
        path = remainder.startsWith("/") ? remainder : (remainder.startsWith("./") ? path + remainder.substring(2) : path + remainder);
        path = this.clean(this.compactPath(path));
        String user = url.getUserInfo();
        String host = url.getHost();
        if (host == null) {
            host = "localhost";
        }
        if ((port = url.getPort()) == -1) {
            port = this.getDefaultPort();
        }
        String authority = null;
        authority = port == this.getDefaultPort() ? host : host + ":" + port;
        this.setURL(url, "block", host, port, authority, user, path, query, ref);
        if (this.debug) {
            System.out.println("BASE: " + url);
            System.out.println("HOST: " + host);
            System.out.println("PORT: " + port);
            System.out.println("AUTHORITY: " + authority);
            System.out.println("USER: " + user);
            System.out.println("PATH: " + path);
            System.out.println("QUERY: " + query);
            System.out.println("REF: " + ref);
        }
    }

    private String clean(String path) {
        int flag = path.indexOf("/./");
        if (flag == -1) {
            return path;
        }
        String head = path.substring(0, flag);
        String tail = path.substring(flag + 2);
        return this.clean(head + tail);
    }

    private String compactPath(String path) {
        int n;
        int p = path.indexOf("/../");
        if (p == -1) {
            return path;
        }
        String header = path.substring(0, p);
        String stub = header.substring(0, (n = header.lastIndexOf("/")) + 1);
        if (stub.length() > 0) {
            String result = stub + path.substring(p + 4);
            return this.compactPath(result);
        }
        throw new IllegalArgumentException("Invalid path: " + path);
    }

    protected int getDefaultPort() {
        return 0;
    }

    protected String toExternalForm(URL url) {
        StringBuffer result = new StringBuffer(url.getProtocol());
        result.append("://");
        result.append(url.getHost());
        if (url.getUserInfo() != null) {
            result.append("@");
            result.append(url.getUserInfo());
        }
        if (url.getFile() != null) {
            result.append(url.getFile());
        }
        if (url.getRef() != null) {
            result.append("#");
            result.append(url.getRef());
        }
        return result.toString();
    }
}

