/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.appliance.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.assembly.engine.service.ServiceRepository;
import org.apache.avalon.assembly.engine.service.UnknownServiceException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.meta.info.Service;
import org.apache.avalon.meta.model.ContextDirective;
import org.apache.avalon.meta.model.Entry;
import org.apache.avalon.meta.model.Import;

class ContextBuilder {
    ContextBuilder() {
    }

    static Map buildContextMap(ClassLoader classloader, ServiceRepository services, ContextDescriptor descriptor, ContextDirective directive, Context context) throws ContextException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urn:avalon:name", context.get((Object)"urn:avalon:name"));
        map.put("urn:avalon:home", context.get((Object)"urn:avalon:home"));
        map.put("urn:avalon:work", context.get((Object)"urn:avalon:work"));
        map.put("urn:avalon:partition", context.get((Object)"urn:avalon:partition"));
        map.put("urn:avalon:partition.name", context.get((Object)"urn:avalon:partition"));
        map.put("app.name", context.get((Object)"urn:avalon:partition"));
        map.put("block.name", context.get((Object)"urn:avalon:name"));
        map.put("app.home", context.get((Object)"urn:avalon:home"));
        EntryDescriptor[] entries = ContextBuilder.getMergedEntries(services, descriptor);
        int i = 0;
        while (i < entries.length) {
            block13: {
                EntryDescriptor entry = entries[i];
                String key = entry.getKey();
                Object object = ContextBuilder.getContextValue(context, key);
                if (object == null && directive != null) {
                    Entry ent;
                    String error;
                    String name;
                    Import imp = directive.getImport(key);
                    if (imp != null && (object = ContextBuilder.getContextValue(context, name = imp.getImportName())) == null && entry.isRequired()) {
                        error = "Import directive for key: " + key + " via name: " + name + " cannot be resolved.";
                        throw new ContextException(error);
                    }
                    if (object == null && (ent = directive.getEntry(key)) != null) {
                        try {
                            object = ent.getValue(classloader, map);
                        }
                        catch (Throwable e) {
                            String error2 = "Rresolution error for context entry directive: " + ent;
                            throw new ContextException(error2, e);
                        }
                        if (object == null) {
                            error = "Unable to build a context value for the entry: '" + key + "' type: " + entry.getClassname();
                            if (entry.isRequired()) {
                                throw new ContextException(error);
                            }
                        }
                    }
                }
                if (object != null) {
                    String error;
                    try {
                        boolean ok = ContextBuilder.objectImplementsType(classloader, object, entry.getClassname());
                        if (ok) {
                            map.put(key, object);
                            break block13;
                        }
                        error = "Object resolved for the key '" + key + "' of class '" + object.getClass().getName() + "' does not implement the type '" + entry.getClassname();
                        throw new ContextException(error);
                    }
                    catch (ClassNotFoundException cnfe) {
                        error = "Context criteria for the key '" + key + "' specifies an unknown type '" + entry.getClassname() + "'.";
                        throw new ContextException(error);
                    }
                }
                if (entry.isRequired()) {
                    String error = "Unable to resolve a context value for the entry: '" + key + "' type: " + entry.getClassname();
                    throw new ContextException(error);
                }
            }
            ++i;
        }
        return map;
    }

    private static EntryDescriptor[] getMergedEntries(ServiceRepository services, ContextDescriptor descriptor) throws IllegalArgumentException {
        try {
            Service service = services.getService(descriptor.getReference());
            EntryDescriptor[] result = descriptor.merge(service.getEntries());
            return result;
        }
        catch (UnknownServiceException e) {
            return descriptor.getEntries();
        }
    }

    protected static Object getContextValue(Context context, String key) {
        if (context == null) {
            return null;
        }
        try {
            return context.get((Object)key);
        }
        catch (ContextException e) {
            return null;
        }
    }

    private static boolean objectImplementsType(ClassLoader classloader, Object value, String type) throws ClassNotFoundException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (type.endsWith("[]") && value instanceof Object[]) {
            Object[] array = (Object[])value;
            if (array.length == 0) {
                return true;
            }
            Object sample = array[0];
            String subtype = type.substring(0, type.length() - 2);
            return ContextBuilder.objectImplementsType(classloader, sample, subtype);
        }
        Class<?> clazz = value.getClass();
        Class<?> typeClass = classloader.loadClass(type);
        return typeClass.isAssignableFrom(clazz);
    }
}

