/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.appliance.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.appliance.ApplianceContext;
import org.apache.avalon.assembly.appliance.ApplianceException;
import org.apache.avalon.assembly.appliance.ApplianceRepository;
import org.apache.avalon.assembly.appliance.ApplianceRuntimeException;
import org.apache.avalon.assembly.appliance.DependencyGraph;
import org.apache.avalon.assembly.appliance.UnknownServiceException;
import org.apache.avalon.assembly.appliance.impl.ContextBuilder;
import org.apache.avalon.assembly.engine.RepositoryManager;
import org.apache.avalon.assembly.engine.impl.EngineClassLoader;
import org.apache.avalon.assembly.engine.service.ServiceRepository;
import org.apache.avalon.assembly.lifecycle.DeploymentService;
import org.apache.avalon.assembly.lifecycle.impl.DefaultDeploymentService;
import org.apache.avalon.assembly.lifestyle.LifestyleHandler;
import org.apache.avalon.assembly.lifestyle.impl.AbstractLifestyleHandler;
import org.apache.avalon.assembly.lifestyle.impl.PooledLifestyleHandler;
import org.apache.avalon.assembly.lifestyle.impl.SingletonLifestyleHandler;
import org.apache.avalon.assembly.lifestyle.impl.ThreadLocalLifestyleHandler;
import org.apache.avalon.assembly.lifestyle.impl.TransientLifestyleHandler;
import org.apache.avalon.assembly.locator.Contextualizable;
import org.apache.avalon.assembly.locator.Locator;
import org.apache.avalon.assembly.locator.Resolvable;
import org.apache.avalon.assembly.locator.impl.DefaultLocator;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.ContextDirective;
import org.apache.avalon.meta.model.LoggingDirective;
import org.apache.excalibur.mpool.PoolManager;

public class DefaultAppliance
extends AbstractLogEnabled
implements Appliance,
Contextualizable,
Initializable {
    protected static String PROTOCOL = "block";
    static final String APPLIANCE_ENGINE_KEY = "urn:assembly:engine";
    static final String APPLIANCE_SYSTEM_KEY = "urn:assembly:appliance.system";
    static final String APPLIANCE_REPOSITORY_KEY = "urn:assembly:appliance.repository";
    private ApplianceContext m_applianceContext;
    private EngineClassLoader m_engine;
    private Locator m_system;
    private Map m_context;
    private LifestyleHandler m_handler;
    private boolean m_enabled = true;
    private Appliance m_contextProvider;
    private final Hashtable m_providers = new Hashtable();
    private final Hashtable m_managers = new Hashtable();
    private String m_name;
    private String m_path;
    private URL m_url;
    private boolean m_assembled;
    private Class m_class;
    private DependencyGraph m_graph;
    private ArrayList m_visited = new ArrayList();
    private ApplianceRepository m_repository;
    private boolean m_contextualized = false;
    private boolean m_initialized = false;
    private boolean m_deployed = false;
    private boolean m_terminated = false;
    static /* synthetic */ Class class$org$apache$avalon$assembly$locator$Contextualizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Contextualizable;

    public void contextualize(Locator context) throws ContextException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("contextualization");
        }
        this.m_applianceContext = (ApplianceContext)context.get((Object)"urn:assembly:appliance.context");
        this.m_engine = (EngineClassLoader)context.get((Object)APPLIANCE_ENGINE_KEY);
        this.m_system = (Locator)context.get((Object)APPLIANCE_SYSTEM_KEY);
        this.m_repository = (ApplianceRepository)context.get((Object)APPLIANCE_REPOSITORY_KEY);
        this.m_contextualized = true;
    }

    public void initialize() throws Exception {
        if (!this.m_contextualized) {
            throw new IllegalStateException("contextualization");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("initialization");
        }
        String classname = this.getType().getInfo().getClassname();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("classname: " + classname);
        }
        try {
            this.m_class = this.m_engine.loadClass(classname);
        }
        catch (Throwable e) {
            String error = "Cannot load class for appliance " + (Object)((Object)this) + " from classname: " + classname;
            throw new ApplianceException(error, e);
        }
        this.m_name = this.m_applianceContext.getName();
        this.m_path = this.m_applianceContext.getPartitionName() + this.m_name;
        this.m_initialized = true;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("lifestyle: " + this.getType().getInfo().getLifestyle());
        }
        DefaultLocator context = new DefaultLocator();
        context.put("urn:assembly:appliance", new ApplianceHolder(this));
        context.put("urn:assembly:lifecycle.deployment", this.createDeploymentService());
        context.put("urn:avalon:classloader", this.m_engine);
        AbstractLifestyleHandler lifestyle = null;
        String policy = this.getType().getInfo().getLifestyle();
        if (policy.equals("singleton")) {
            lifestyle = new SingletonLifestyleHandler();
        } else if (policy.equals("transient")) {
            lifestyle = new TransientLifestyleHandler();
        } else if (policy.equals("thread")) {
            lifestyle = new ThreadLocalLifestyleHandler();
        } else if (policy.equals("pooled")) {
            lifestyle = new PooledLifestyleHandler();
            context.put(PoolManager.ROLE, this.m_system.get((Object)PoolManager.ROLE));
        }
        context.makeReadOnly();
        try {
            ((LogEnabled)lifestyle).enableLogging(this.getLogger());
            ((Contextualizable)lifestyle).contextualize((Locator)context);
            ((Initializable)lifestyle).initialize();
            this.m_handler = lifestyle;
        }
        catch (Throwable e) {
            String error = "Unexpected lifestyle handler establishment failure.";
            throw new ApplianceException("Unexpected lifestyle handler establishment failure.", e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("identity: " + System.identityHashCode((Object)this));
            this.getLogger().debug("initialization complete");
        }
    }

    public Object resolve(Object source) throws Exception {
        return this.resolve(source, null);
    }

    public Object resolve(Object source, String ref) throws Exception {
        if (!this.m_deployed) {
            this.deploy();
        }
        if (ref != null && !this.validReference(ref)) {
            String error = "Requested service reference: " + ref + " is unknown within appliance: " + (Object)((Object)this);
            throw new ApplianceException(error);
        }
        return this.m_handler.resolve(source, ref);
    }

    public void release(Object object, Object source) {
        try {
            this.m_handler.release(object, source);
        }
        catch (Throwable e) {
            String error = "Lifestyle handler raised a release error in appliance: " + (Object)((Object)this);
            throw new ApplianceRuntimeException(error, e);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public Type getType() {
        return this.m_applianceContext.getType();
    }

    public DependencyDescriptor[] getDependencies() {
        return this.m_applianceContext.getProfile().getDependencies();
    }

    public ServiceDescriptor[] getServices() {
        return this.m_applianceContext.getProfile().getServices();
    }

    public ServiceDescriptor getService(ReferenceDescriptor reference) {
        return this.m_applianceContext.getProfile().getService(reference);
    }

    public URL getURL() {
        if (!this.m_initialized) {
            String error = "URL cannot been accessed before initialization.";
            throw new IllegalStateException("URL cannot been accessed before initialization.");
        }
        if (this.m_url == null) {
            try {
                URL base = this.m_repository.getURL();
                this.m_url = new URL(base, base.getPath() + this.m_name);
            }
            catch (Throwable e) {
                String error = "Unexpected url creation error in appliance: " + (Object)((Object)this);
                throw new ApplianceRuntimeException(error, e);
            }
        }
        return this.m_url;
    }

    public URL getURL(String type) throws UnknownServiceException {
        if (!this.validReference(type)) {
            String error = "Requested service ref: " + type + " is unknown within appliance: " + (Object)((Object)this);
            throw new UnknownServiceException(error);
        }
        try {
            URL url = this.getURL();
            return new URL(url, url.getPath() + "#" + type);
        }
        catch (Throwable e) {
            String error = "Unexpected error while creating a URL for service: " + type;
            throw new ApplianceRuntimeException(error, e);
        }
    }

    public String getPartitionName() {
        return this.getURL().getPath();
    }

    public String getPath() {
        return this.m_path;
    }

    public ContextDirective getContextDirective() {
        return this.m_applianceContext.getProfile().getContext();
    }

    public Map getContextMap() throws IllegalStateException {
        if (!this.m_assembled) {
            String error = "Appliance: '" + (Object)((Object)this) + "' has not been assembled.";
            throw new IllegalStateException(error);
        }
        return this.m_context;
    }

    public Parameters getParameters() {
        return this.m_applianceContext.getParameters();
    }

    public Configuration getConfiguration() {
        return this.m_applianceContext.getConfiguration();
    }

    public boolean getActivationPolicy() {
        return this.m_applianceContext.getActivationPolicy();
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    private void setEnabled(boolean value) {
        this.m_enabled = value;
    }

    public LoggingDirective getLoggingDirective() {
        return this.m_applianceContext.getLoggingDirective();
    }

    public void assemble() throws ApplianceException {
        this.assemble(this.getDependencyGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble(DependencyGraph graph) throws ApplianceException {
        if (!this.m_initialized) {
            throw new IllegalStateException("initialization");
        }
        if (this.m_assembled) {
            return;
        }
        if (graph == null) {
            throw new NullPointerException("graph");
        }
        DependencyGraph dependencyGraph = this.m_graph = graph;
        synchronized (dependencyGraph) {
            this.executeAssembly(this.m_graph);
        }
        if (this.isContextEnabled()) {
            this.m_context = this.buildContextMap();
        }
        this.setEnabled(true);
        this.m_assembled = true;
        if (this.getLogger().isDebugEnabled()) {
            Appliance[] providers = this.m_graph.getProviderGraph((Appliance)this);
            StringBuffer buffer = new StringBuffer(" providers: (" + providers.length + ") ");
            int k = 0;
            while (k < providers.length) {
                if (k > 0) {
                    buffer.append(", " + providers[k]);
                } else {
                    buffer.append(providers[k].toString());
                }
                ++k;
            }
            this.getLogger().debug(buffer.toString());
        }
    }

    public void disassemble() {
        if (!this.m_assembled) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("disassembly");
        }
        Appliance[] consumers = this.getDependencyGraph().getConsumerGraph((Appliance)this);
        int i = 0;
        while (i < consumers.length) {
            Appliance consumer = consumers[i];
            this.m_graph.remove(consumer);
            ++i;
        }
        this.m_assembled = false;
    }

    protected DependencyGraph getDependencyGraph() {
        if (this.m_graph == null) {
            String error = "Missing assembly graph.";
            throw new IllegalStateException("Missing assembly graph.");
        }
        return this.m_graph;
    }

    private boolean isContextEnabled() {
        if (this.getContextProvider() != null) {
            return true;
        }
        if (this.getType().getStages().length > 0) {
            return true;
        }
        if ((class$org$apache$avalon$assembly$locator$Contextualizable == null ? (class$org$apache$avalon$assembly$locator$Contextualizable = DefaultAppliance.class$("org.apache.avalon.assembly.locator.Contextualizable")) : class$org$apache$avalon$assembly$locator$Contextualizable).isAssignableFrom(this.m_class)) {
            return true;
        }
        return (class$org$apache$avalon$framework$context$Contextualizable == null ? (class$org$apache$avalon$framework$context$Contextualizable = DefaultAppliance.class$("org.apache.avalon.framework.context.Contextualizable")) : class$org$apache$avalon$framework$context$Contextualizable).isAssignableFrom(this.m_class);
    }

    private Map buildContextMap() throws ApplianceException {
        ContextDescriptor descriptor = this.getType().getContext();
        Map map = this.m_applianceContext.getDeploymentMap();
        try {
            map.put("urn:avalon:name", this.m_name);
            map.put("urn:avalon:partition", this.getURL().getPath());
            File base = (File)this.m_system.get((Object)"urn:assembly:home");
            File working = new File(base, "working");
            File home = new File(working, "home");
            File work = new File(working, "temp");
            work.deleteOnExit();
            File tmp = new File(work, this.m_path);
            tmp.deleteOnExit();
            map.put("urn:avalon:home", new File(home, this.m_path));
            map.put("urn:avalon:work", tmp);
            map.put("block.name", this.m_name);
            map.put("app.home", new File(home, this.m_path));
        }
        catch (Throwable e) {
            String error = "Unexpected exception while preparing deployment context in appliance: " + (Object)((Object)this);
            throw new ApplianceException(error, e);
        }
        try {
            DefaultContext source = new DefaultContext(map, (Context)this.m_system);
            ContextDirective directive = this.m_applianceContext.getContextDirective();
            RepositoryManager repository = this.m_engine.getRepository();
            ServiceRepository services = repository.getServiceRepository();
            return ContextBuilder.buildContextMap(this.m_engine, services, descriptor, directive, (Context)source);
        }
        catch (Throwable e) {
            String error = "Unable to create context map in appliance: " + (Object)((Object)this);
            throw new ApplianceException(error, e);
        }
    }

    public Appliance getContextProvider() {
        return this.m_contextProvider;
    }

    private void setContextProvider(Appliance appliance) {
        if (this.m_contextProvider != null) {
            throw new IllegalStateException("appliance");
        }
        this.m_contextProvider = appliance;
    }

    public Appliance[] getServiceProviders() {
        return this.m_providers.values().toArray(new Appliance[0]);
    }

    public Appliance getServiceProvider(String role) {
        return (Appliance)this.m_providers.get(role);
    }

    private void addServiceProvider(String role, Appliance appliance) {
        this.m_providers.put(role, appliance);
    }

    private void addExtensionProvider(StageDescriptor stage, Appliance appliance) {
        this.m_managers.put(stage, appliance);
    }

    public Appliance[] getExtensionProviders() {
        return this.m_managers.values().toArray(new Appliance[0]);
    }

    public Appliance getExtensionProvider(StageDescriptor stage) {
        return (Appliance)this.m_managers.get(stage);
    }

    public String toString() {
        try {
            return "[appliance:/" + this.getURL().getPath() + "]";
        }
        catch (Throwable e) {
            return "[appliance:/?]";
        }
    }

    public void deploy() throws Exception {
        if (this.m_deployed) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("deployment");
        }
        if (!this.m_assembled) {
            String message = "invoking self assembly in appliance: " + (Object)((Object)this);
            this.getLogger().debug(message);
            try {
                this.assemble();
            }
            catch (ApplianceException e) {
                String error = "Unable to resolve service due to a self assembly failure in appliance: " + (Object)((Object)this);
                throw new ApplianceException(error, (Throwable)e);
            }
        }
        this.m_deployed = true;
    }

    public void decommission() {
        if (!this.m_deployed) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("decommissioning");
        }
        try {
            this.m_handler.decommission();
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to decommission the handler in appliance: " + (Object)((Object)this);
            this.getLogger().warn(error, e);
        }
        this.m_deployed = false;
    }

    public void terminate() {
        if (!this.m_initialized) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("termination");
        }
        this.m_handler.terminate();
        this.m_initialized = false;
    }

    private void executeAssembly(DependencyGraph graph) throws ApplianceException {
        this.getLogger().debug("assembly");
        this.m_visited.add(this);
        ContextDescriptor context = this.getType().getContext();
        String ext = context.getAttribute("urn:assembly:lifecycle.context.strategy");
        if (ext != null && this.getContextProvider() == null) {
            Appliance supplier;
            String message = "resolving context handler for: " + (Object)((Object)this);
            this.getLogger().debug(message);
            ReferenceDescriptor ref = new ReferenceDescriptor(ext);
            StageDescriptor stage = new StageDescriptor(ref);
            try {
                supplier = this.m_engine.resolve(graph, stage, this.getURL().getPath());
            }
            catch (Throwable e) {
                this.setEnabled(false);
                String error = "Unable to resolve a supplier for a context stage: " + ext + " in appliance: " + (Object)((Object)this);
                throw new ApplianceException(error, e);
            }
            if (supplier == null) {
                String error = "Unresolved context strategy handler: " + ext;
                this.setEnabled(false);
                throw new ApplianceException(error);
            }
            this.setContextProvider(supplier);
            graph.add(supplier);
            this.getLogger().debug("assigning context strategy handler: " + supplier);
        }
        DependencyDescriptor[] dependencies = this.getDependencies();
        int i = 0;
        while (i < dependencies.length) {
            DependencyDescriptor dependency = dependencies[i];
            String role = dependency.getKey();
            if (this.getServiceProvider(role) == null) {
                this.getLogger().debug("resolving role: [" + role + "] in " + (Object)((Object)this));
                Appliance supplier = null;
                try {
                    supplier = this.m_engine.resolve(graph, dependency, this.getURL().getPath());
                }
                catch (Throwable e) {
                    this.setEnabled(false);
                    String error = "Unable to deploy a supplier for a service dependency.\n  appliance: " + (Object)((Object)this) + "\n  dependency: " + dependency;
                    throw new ApplianceException(error, e);
                }
                if (supplier == null) {
                    String message = "Unresolved supplied for the dependency: " + dependency.getReference() + ", for the role: " + dependency.getKey();
                    this.setEnabled(false);
                    throw new ApplianceException(message);
                }
                this.addServiceProvider(role, supplier);
                this.getLogger().debug("associated supplier: " + supplier.getName() + " under the key: " + role);
                graph.add(supplier);
            }
            ++i;
        }
        StageDescriptor[] stages = this.getType().getStages();
        int i2 = 0;
        while (i2 < stages.length) {
            StageDescriptor stage = stages[i2];
            if (this.getExtensionProvider(stage) == null) {
                Appliance supplier = null;
                try {
                    supplier = this.m_engine.resolve(graph, stage, this.getURL().getPath());
                }
                catch (Throwable e) {
                    String error = "Unable to resolve a supplier for a stage: " + stage;
                    throw new ApplianceException(error, e);
                }
                if (supplier == null) {
                    String message = "Unresolved supplied for the stage: " + stage;
                    this.setEnabled(false);
                    throw new ApplianceException(message);
                }
                this.addExtensionProvider(stage, supplier);
                this.getLogger().debug("associated extension provider: " + supplier);
                graph.add(supplier);
            }
            ++i2;
        }
    }

    protected boolean validReference(String ref) {
        ReferenceDescriptor reference = new ReferenceDescriptor(ref);
        return null != this.m_applianceContext.getProfile().getService(reference);
    }

    private DeploymentService createDeploymentService() throws ApplianceException {
        try {
            DefaultDeploymentService deployment = new DefaultDeploymentService();
            deployment.enableLogging(this.getLogger());
            DefaultLocator locator = new DefaultLocator();
            locator.put("urn:assembly:logging", this.m_system.get((Object)"urn:assembly:logging"));
            deployment.contextualize(locator);
            deployment.initialize();
            return deployment;
        }
        catch (Throwable e) {
            String error = "Internal error while attempting to create a deployment service.";
            throw new ApplianceException("Internal error while attempting to create a deployment service.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ApplianceHolder
    implements Resolvable {
        private Appliance m_appliance;

        public ApplianceHolder(Appliance appliance) {
            this.m_appliance = appliance;
        }

        public Object resolve(Object source) {
            return this.resolve(source, null);
        }

        public Object resolve(Object source, String ref) {
            return this.m_appliance;
        }
    }
}

