/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.appliance.impl;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.assembly.appliance.ApplianceContext;
import org.apache.avalon.assembly.locator.impl.DefaultLocator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.meta.info.CategoryDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.Category;
import org.apache.avalon.meta.model.ContextDirective;
import org.apache.avalon.meta.model.LoggingDirective;
import org.apache.avalon.meta.model.Profile;
import org.apache.excalibur.configuration.CascadingConfiguration;

public class DefaultApplianceContext
extends DefaultLocator
implements ApplianceContext {
    private Profile m_profile;
    private boolean m_activation = false;
    private String m_partition;
    private String m_name;
    private LoggingDirective m_logging;
    private Parameters m_parameters;
    private Configuration m_config;
    private String m_classname;
    private String m_factory;

    public DefaultApplianceContext(Profile profile) {
        this(profile, null);
    }

    public DefaultApplianceContext(Profile profile, Map map) {
        super(map);
        this.setProfile(profile);
    }

    public void setApplianceClassname(String classname) {
        this.checkWriteable();
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        this.m_classname = classname;
    }

    public String getApplianceClassname() {
        if (this.m_classname == null) {
            return this.getType().getInfo().getAttribute("urn:assembly:appliance.class");
        }
        return this.m_classname;
    }

    public void setApplianceFactoryClassname(String classname) {
        this.checkWriteable();
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        this.m_factory = classname;
    }

    public String getApplianceFactoryClassname() {
        if (this.m_factory == null) {
            return this.getType().getInfo().getAttribute("urn:assembly:appliance.factory");
        }
        return this.m_factory;
    }

    public void setName(String name) throws NullPointerException, IllegalStateException {
        this.checkWriteable();
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.m_name = name;
    }

    public String getName() {
        if (this.m_name == null) {
            return this.getProfile().getName();
        }
        return this.m_name;
    }

    private void setProfile(Profile profile) {
        this.checkWriteable();
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        this.m_profile = profile;
        this.m_activation = profile.getActivationPolicy();
    }

    public Profile getProfile() {
        return this.m_profile;
    }

    public Type getType() {
        return this.m_profile.getType();
    }

    public void setLoggingDirective(LoggingDirective directives) throws IllegalStateException, NullPointerException {
        this.checkWriteable();
        if (directives == null) {
            throw new NullPointerException("logging");
        }
        this.m_logging = this.buildLoggingDirectives(directives);
    }

    public LoggingDirective getLoggingDirective() {
        if (this.m_logging == null) {
            LoggingDirective client = new LoggingDirective(this.m_profile.getType());
            this.m_logging = this.buildLoggingDirectives(client);
        }
        return this.m_logging;
    }

    public ContextDirective getContextDirective() {
        return this.m_profile.getContext();
    }

    public void setPartitionName(String name) throws IllegalStateException {
        this.checkWriteable();
        this.m_partition = name == null ? "/" : (!name.endsWith("/") ? name + "/" : name);
    }

    public String getPartitionName() {
        if (this.m_partition == null) {
            return "/";
        }
        return this.m_partition;
    }

    public void setActivationPolicy(boolean policy) {
        this.checkWriteable();
        this.m_activation = policy;
    }

    public boolean getActivationPolicy() {
        return this.m_activation;
    }

    public Map getDeploymentMap() {
        return super.getData();
    }

    public void addParameters(Parameters parameters) throws IllegalStateException, NullPointerException {
        this.checkWriteable();
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        this.m_parameters = new Parameters();
        this.m_parameters.merge(this.m_profile.getParameters());
        this.m_parameters.merge(parameters);
    }

    public Parameters getParameters() {
        if (this.m_parameters == null) {
            return this.m_profile.getParameters();
        }
        return this.m_parameters;
    }

    public void setConfiguration(Configuration config) throws IllegalStateException, NullPointerException {
        this.checkWriteable();
        if (config == null) {
            throw new NullPointerException("configuration");
        }
        this.m_config = new CascadingConfiguration(config, this.m_profile.getConfiguration());
    }

    public Configuration getConfiguration() {
        if (this.m_config == null) {
            return this.m_profile.getConfiguration();
        }
        return this.m_config;
    }

    private LoggingDirective buildLoggingDirectives(LoggingDirective directive) {
        LoggingDirective categories = this.m_profile.getCategories();
        CategoryDescriptor[] loggers = this.m_profile.getType().getCategories();
        ArrayList<Category> list = new ArrayList<Category>();
        int i = 0;
        while (i < loggers.length) {
            String name = loggers[i].getName();
            Category category = this.getCategory(name, directive, categories);
            if (category != null) {
                list.add(category);
            } else {
                list.add(new Category(name));
            }
            ++i;
        }
        return new LoggingDirective(categories.getName(), categories.getPriority(), categories.getTarget(), list.toArray(new Category[0]));
    }

    private Category getCategory(String name, LoggingDirective primary, LoggingDirective secondary) {
        Category category = primary.getCategory(name);
        if (category == null) {
            category = secondary.getCategory(name);
        }
        return category;
    }

    public String toString() {
        return "[" + this.getName() + "]";
    }
}

