/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.appliance.impl;

import java.util.Map;
import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.appliance.ApplianceContext;
import org.apache.avalon.assembly.appliance.ApplianceException;
import org.apache.avalon.assembly.appliance.ApplianceFactory;
import org.apache.avalon.assembly.appliance.ApplianceRepository;
import org.apache.avalon.assembly.appliance.DependencyGraph;
import org.apache.avalon.assembly.appliance.impl.DefaultAppliance;
import org.apache.avalon.assembly.appliance.impl.DefaultApplianceContext;
import org.apache.avalon.assembly.engine.Engine;
import org.apache.avalon.assembly.engine.impl.EngineClassLoader;
import org.apache.avalon.assembly.locator.Contextualizable;
import org.apache.avalon.assembly.locator.Locator;
import org.apache.avalon.assembly.locator.impl.DefaultLocator;
import org.apache.avalon.assembly.logging.LoggingManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.Profile;
import org.apache.excalibur.mpool.PoolManager;

public class DefaultApplianceFactory
extends AbstractLogEnabled
implements ApplianceFactory,
Contextualizable,
Initializable {
    private Context m_system;
    private ApplianceRepository m_repository;
    private PoolManager m_pool;
    private LoggingManager m_logging;
    static /* synthetic */ Class class$org$apache$avalon$assembly$appliance$impl$DefaultApplianceFactory;
    static /* synthetic */ Class class$org$apache$avalon$assembly$appliance$impl$DefaultAppliance;

    public static ApplianceFactory createApplianceFactory(EngineClassLoader loader, Logger logger, LoggingManager logging, ApplianceRepository repository, Locator system) throws ApplianceException {
        return DefaultApplianceFactory.createApplianceFactory(loader, (class$org$apache$avalon$assembly$appliance$impl$DefaultApplianceFactory == null ? (class$org$apache$avalon$assembly$appliance$impl$DefaultApplianceFactory = DefaultApplianceFactory.class$("org.apache.avalon.assembly.appliance.impl.DefaultApplianceFactory")) : class$org$apache$avalon$assembly$appliance$impl$DefaultApplianceFactory).getName(), logger, logging, repository, system);
    }

    public static ApplianceFactory createApplianceFactory(Engine loader, String classname, Logger logger, LoggingManager logging, ApplianceRepository repository, Locator system) throws ApplianceException {
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        if (classname.equals((class$org$apache$avalon$assembly$appliance$impl$DefaultApplianceFactory == null ? (class$org$apache$avalon$assembly$appliance$impl$DefaultApplianceFactory = DefaultApplianceFactory.class$("org.apache.avalon.assembly.appliance.impl.DefaultApplianceFactory")) : class$org$apache$avalon$assembly$appliance$impl$DefaultApplianceFactory).getName())) {
            return DefaultApplianceFactory.createDefaultApplianceFactory(logger, logging, system, repository);
        }
        try {
            Type type = loader.getRepository().getTypeRepository().getType(classname);
            Profile profile = loader.getRepository().getProfileRepository().getProfile(type);
            DefaultApplianceContext context = new DefaultApplianceContext(profile);
            context.put("urn:assembly:appliance.repository", repository);
            context.put("urn:assembly:logging", logging);
            context.makeReadOnly();
            Appliance appliance = loader.createAppliance((ApplianceContext)context, true);
            appliance.assemble(new DependencyGraph());
            appliance.deploy();
            Object factory = appliance.resolve((Object)loader);
            if (factory instanceof ApplianceFactory) {
                return (ApplianceFactory)factory;
            }
            String error = "Supplied classname '" + classname + "' does not implement the ApplianceFactory interface.";
            throw new ApplianceException(error);
        }
        catch (Throwable e) {
            String error = "Could not create appliance factory using : " + classname;
            throw new ApplianceException(error, e);
        }
    }

    private static ApplianceFactory createDefaultApplianceFactory(Logger logger, LoggingManager logging, Locator context, ApplianceRepository repository) throws ApplianceException {
        DefaultApplianceFactory factory = new DefaultApplianceFactory();
        factory.enableLogging(logger);
        try {
            DefaultLocator locator = new DefaultLocator(context);
            Logger log = logger.getChildLogger("deployment");
            locator.put("urn:assembly:appliance.repository", repository);
            locator.put("urn:assembly:logging", logging);
            factory.contextualize(locator);
            factory.initialize();
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to create default appliance factory.";
            throw new ApplianceException("Unexpected error while attempting to create default appliance factory.", e);
        }
        return factory;
    }

    public void contextualize(Locator context) throws ContextException {
        this.m_system = context;
        this.m_repository = (ApplianceRepository)context.get((Object)"urn:assembly:appliance.repository");
        this.m_pool = (PoolManager)context.get((Object)PoolManager.ROLE);
        this.m_logging = (LoggingManager)context.get((Object)"urn:assembly:logging");
    }

    public void initialize() throws Exception {
        if (this.m_system == null) {
            throw new IllegalStateException("context");
        }
    }

    public Appliance createAppliance(Locator system, Engine engine, ApplianceContext context) throws ApplianceException {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this.m_repository == null) {
            String error = "repository";
            throw new IllegalStateException("repository");
        }
        String path = context.getPartitionName() + context.getName();
        Logger logger = this.m_logging.getSystemLoggerForCategory(path);
        DefaultLocator locator = null;
        try {
            locator = new DefaultLocator((Locator)context);
            locator.put(PoolManager.ROLE, this.m_pool);
            locator.put("urn:assembly:appliance.repository", this.m_repository);
            locator.put("urn:assembly:appliance.context", context);
            locator.put("urn:assembly:engine", engine);
            locator.put("urn:assembly:appliance.system", system);
            locator.makeReadOnly();
        }
        catch (Throwable e) {
            String error = "Unexpected error while building appliance context.";
            throw new ApplianceException("Unexpected error while building appliance context.", e);
        }
        String classname = context.getApplianceClassname();
        if (classname == null || classname.equals((class$org$apache$avalon$assembly$appliance$impl$DefaultAppliance == null ? (class$org$apache$avalon$assembly$appliance$impl$DefaultAppliance = DefaultApplianceFactory.class$("org.apache.avalon.assembly.appliance.impl.DefaultAppliance")) : class$org$apache$avalon$assembly$appliance$impl$DefaultAppliance).getName())) {
            this.getLogger().debug("creating a classic appliance: " + path);
            DefaultAppliance appliance = new DefaultAppliance();
            appliance.enableLogging(logger);
            try {
                appliance.contextualize(locator);
                appliance.initialize();
                return appliance;
            }
            catch (Throwable e) {
                String error = "Unable to create appliance from context: " + context.getName();
                throw new ApplianceException(error, e);
            }
        }
        this.getLogger().debug("custom appliance using: " + classname);
        try {
            Map map = context.getDeploymentMap();
            Type type = engine.getRepository().getTypeRepository().getType(classname);
            Profile profile = engine.getRepository().getProfileRepository().getProfile(type);
            DefaultApplianceContext cntx = new DefaultApplianceContext(profile, map);
            cntx.setName(context.getName() + "$bootstrap");
            cntx.setPartitionName(context.getPartitionName());
            cntx.put("urn:assembly:appliance.context", context);
            cntx.put("urn:assembly:appliance.repository", this.m_repository);
            cntx.put(PoolManager.ROLE, this.m_pool);
            cntx.put("urn:assembly:appliance.system", system);
            cntx.put("urn:assembly:engine", engine);
            cntx.makeReadOnly();
            Appliance appliance = engine.createAppliance((ApplianceContext)cntx, false);
            appliance.assemble(new DependencyGraph());
            Object object = appliance.resolve((Object)this);
            if (object instanceof Appliance) {
                return (Appliance)object;
            }
            String error = "Supplied classname '" + classname + "' does not implement the Appliance interface." + "\nclass: " + object.getClass().getName() + "\nobject: " + object;
            throw new ApplianceException(error);
        }
        catch (Throwable e) {
            String error = "Could not create appliance using : " + classname;
            throw new ApplianceException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

