/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.appliance.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.appliance.ApplianceRepository;
import org.apache.avalon.assembly.appliance.ApplianceResolver;
import org.apache.avalon.assembly.appliance.ApplianceRuntimeException;
import org.apache.avalon.assembly.appliance.ApplianceSelector;
import org.apache.avalon.assembly.appliance.DuplicateApplianceException;
import org.apache.avalon.assembly.appliance.impl.BlockURLHandler;
import org.apache.avalon.assembly.appliance.impl.DefaultApplianceSelector;
import org.apache.avalon.assembly.engine.Engine;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;

public final class DefaultApplianceRepository
implements ApplianceRepository {
    private ApplianceRepository m_parent;
    private final Map m_appliances = new Hashtable();
    private final Map m_children = new Hashtable();
    private String m_name;
    private URL m_url;

    public DefaultApplianceRepository() {
        this.m_name = "/";
        try {
            this.m_url = new URL("block", "localhost", -1, this.m_name, new BlockURLHandler(this));
        }
        catch (Throwable e) {
            String error = "Unexpected error while creating the root repository URL.";
            throw new ApplianceRuntimeException("Unexpected error while creating the root repository URL.", e);
        }
    }

    private DefaultApplianceRepository(ApplianceRepository parent, String name) {
        this.m_parent = parent;
        this.m_name = name;
        URL url = parent.getURL();
        try {
            this.m_url = name.endsWith("/") ? new URL(url, url.getPath() + name) : new URL(url, url.getPath() + name + "/");
        }
        catch (Throwable e) {
            String error = "Unable to construct a valid URL from the base: " + parent.getURL() + " with the name: " + name;
            throw new ApplianceRuntimeException(error, e);
        }
    }

    public ApplianceRepository createChild(Engine engine, String name) {
        DefaultApplianceRepository repository = new DefaultApplianceRepository(this, name);
        String key = repository.getURL().getPath().substring(this.getURL().getPath().length());
        this.m_children.put(key, repository);
        return repository;
    }

    public URL getURL() {
        return this.m_url;
    }

    public Appliance[] getAppliances(DependencyDescriptor dependency) {
        ReferenceDescriptor reference = dependency.getReference();
        return this.getAppliances(reference);
    }

    public Appliance[] getAppliances(ReferenceDescriptor reference) {
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        if (this.m_parent != null) {
            Appliance[] appliances = this.m_parent.getAppliances(reference);
            int i = 0;
            while (i < appliances.length) {
                list.add(appliances[i]);
                ++i;
            }
        }
        Iterator iterator = this.m_appliances.values().iterator();
        while (iterator.hasNext()) {
            Appliance appliance = (Appliance)iterator.next();
            ServiceDescriptor service = appliance.getService(reference);
            if (service == null) continue;
            list.add(appliance);
        }
        return list.toArray(new Appliance[0]);
    }

    public Appliance[] getAppliances() {
        return this.m_appliances.values().toArray(new Appliance[0]);
    }

    public Appliance[] getAppliances(StageDescriptor stage) {
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        if (this.m_parent != null) {
            Appliance[] appliances = this.m_parent.getAppliances(stage);
            int i = 0;
            while (i < appliances.length) {
                list.add(appliances[i]);
                ++i;
            }
        }
        Iterator iterator = this.m_appliances.values().iterator();
        while (iterator.hasNext()) {
            Appliance appliance = (Appliance)iterator.next();
            if (!appliance.isEnabled() || appliance.getType().getExtension(stage) == null) continue;
            list.add(appliance);
        }
        return list.toArray(new Appliance[0]);
    }

    public Appliance getAppliance(DependencyDescriptor dependency, ApplianceSelector selector) {
        Appliance[] appliances = this.getAppliances(dependency);
        return selector.select(appliances, dependency);
    }

    public Appliance getAppliance(ReferenceDescriptor reference) {
        return this.getAppliance(reference, (ApplianceSelector)new DefaultApplianceSelector());
    }

    public Appliance getAppliance(ReferenceDescriptor reference, ApplianceSelector selector) {
        Appliance[] appliances = this.getAppliances(reference);
        DependencyDescriptor dependency = new DependencyDescriptor("", reference);
        return selector.select(appliances, dependency);
    }

    public Appliance getAppliance(StageDescriptor stage, ApplianceSelector selector) {
        Appliance[] appliances = this.getAppliances(stage);
        return selector.select(appliances, stage);
    }

    public Appliance getAppliance(DependencyDescriptor dependency) {
        return this.getAppliance(dependency, (ApplianceSelector)new DefaultApplianceSelector());
    }

    public Appliance getAppliance(StageDescriptor stage) {
        return this.getAppliance(stage, (ApplianceSelector)new DefaultApplianceSelector());
    }

    public void addAppliance(Appliance appliance) throws DuplicateApplianceException, NullPointerException {
        String key;
        if (appliance == null) {
            throw new NullPointerException("appliance");
        }
        String local = this.getURL().getPath();
        if (appliance.getURL().getPath().startsWith(local)) {
            key = this.getKey(appliance);
            if (this.m_appliances.get(key) != null) {
                String error = "Illegal attempt to register a duplicate key: " + key;
                throw new DuplicateApplianceException(error);
            }
        } else {
            String error = "Appliance URL " + appliance.getURL() + " does not match repository URL " + this.getURL();
            throw new ApplianceRuntimeException(error);
        }
        this.m_appliances.put(key, appliance);
    }

    public Appliance resolveAppliance(String uri) {
        if (!uri.startsWith(this.m_url.getPath())) {
            String error = "Invalid path: " + uri;
            throw new IllegalArgumentException(error);
        }
        String relative = uri.substring(this.m_url.getPath().length());
        String key = this.getKey(relative);
        Appliance appliance = (Appliance)this.m_appliances.get(key);
        if (appliance == null) {
            String error = "Unresolvable path: " + uri;
            throw new IllegalArgumentException(error);
        }
        if (relative.indexOf("/") > -1) {
            if (appliance instanceof ApplianceResolver) {
                return ((ApplianceResolver)appliance).resolveAppliance(uri);
            }
            String error = "Unresolvable path: " + uri;
            throw new IllegalArgumentException(error);
        }
        return appliance;
    }

    public String toString() {
        return "[repository:" + this.m_url.getPath() + "]";
    }

    private String getKey(Appliance appliance) {
        String local = this.getURL().getPath();
        String path = appliance.getURL().getPath();
        String key = path.substring(local.length());
        return this.getKey(key);
    }

    private String getKey(String key) {
        int n = key.indexOf("/");
        if (n > -1) {
            return key.substring(0, n);
        }
        return key;
    }
}

