/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.engine.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.assembly.engine.model.Classpath;
import org.apache.avalon.assembly.engine.model.ClasspathDescriptor;
import org.apache.avalon.assembly.engine.model.ClasspathRuntimeException;
import org.apache.avalon.assembly.engine.model.FilesetDescriptor;
import org.apache.avalon.assembly.engine.model.IncludeDescriptor;
import org.apache.avalon.assembly.engine.model.ResourceDescriptor;
import org.apache.avalon.composition.repository.Repository;
import org.apache.avalon.composition.repository.RepositoryException;

public class DefaultClasspath
implements Classpath {
    private final ClasspathDescriptor m_classpath;

    public DefaultClasspath(ClasspathDescriptor classpath) throws IllegalArgumentException {
        this.m_classpath = classpath;
    }

    public URL[] expand(File system, File base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        ArrayList list = new ArrayList();
        this.expand(base, list);
        if (system != null) {
            this.expandResources(system, list);
        }
        return list.toArray(new URL[0]);
    }

    public URL[] expand(Repository repository, File base) throws RepositoryException {
        if (base == null) {
            throw new NullPointerException("base");
        }
        ArrayList list = new ArrayList();
        this.expand(base, list);
        this.expand(repository, list);
        return list.toArray(new URL[0]);
    }

    private void expand(File base, List list) {
        FilesetDescriptor[] dirs = this.m_classpath.getFilesetDescriptors();
        int i = 0;
        while (i < dirs.length) {
            FilesetDescriptor descriptor = dirs[i];
            File anchor = new File(base, descriptor.getBaseDirectory());
            if (!anchor.exists()) {
                String error = "Fileset base directory does not exist: " + anchor;
                throw new ClasspathRuntimeException(error);
            }
            IncludeDescriptor[] includes = descriptor.getIncludeDescriptors();
            int j = 0;
            while (j < includes.length) {
                String inc = includes[j].getPath();
                try {
                    URL url = new File(anchor, inc).getCanonicalFile().toURL();
                    list.add(url);
                }
                catch (Throwable e) {
                    String error = "Error processing a classpath include: " + inc;
                    throw new ClasspathRuntimeException(error, e);
                }
                ++j;
            }
            ++i;
        }
    }

    private void expand(Repository repository, List list) throws RepositoryException {
        ResourceDescriptor[] resources = this.m_classpath.getResourceDescriptors();
        if (repository == null && resources.length > 0) {
            throw new IllegalStateException("repository");
        }
        int i = 0;
        while (i < resources.length) {
            ResourceDescriptor resource = resources[i];
            String group = resource.getGroupID();
            String name = resource.getName();
            String version = resource.getVersion();
            list.add(repository.getArtifact(group, name, version, "jar"));
            ++i;
        }
    }

    public ClasspathDescriptor getClasspathDescriptor() {
        return this.m_classpath;
    }

    private void expandResources(File system, List list) {
        ResourceDescriptor[] resources = this.m_classpath.getResourceDescriptors();
        int i = 0;
        while (i < resources.length) {
            ResourceDescriptor resource = resources[i];
            String group = resource.getGroupID();
            String name = resource.getName();
            String version = resource.getVersion();
            File repository = new File(system, "repository");
            File jars = new File(new File(repository, group), "jars");
            File target = new File(jars, name + "-" + version + ".jar");
            if (target.exists()) {
                try {
                    URL url = target.toURL();
                    list.add(url);
                }
                catch (Throwable e) {
                    String error = "Malformed URL error while attempting add resource: " + resource;
                    throw new IllegalArgumentException(error);
                }
            } else {
                String error = "Supplied resource declaration unresolvable: " + resource;
                throw new IllegalArgumentException(error);
            }
            ++i;
        }
    }

    private static File getBaseDirectory(URL url) {
        File file;
        File base = null;
        if (url.getProtocol().equals("file") && (base = (file = new File(url.toString().substring(5))).isFile() ? file.getParentFile() : file).isDirectory()) {
            return base;
        }
        String error = "Cannot resolve base directory from supplied URL: " + url;
        throw new IllegalArgumentException(error);
    }
}

