/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.engine.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.assembly.engine.impl.DefaultProfileSelector;
import org.apache.avalon.assembly.engine.profile.DuplicateProfileException;
import org.apache.avalon.assembly.engine.profile.ProfileException;
import org.apache.avalon.assembly.engine.profile.ProfileRepository;
import org.apache.avalon.assembly.engine.profile.ProfileRuntimeException;
import org.apache.avalon.assembly.engine.profile.ProfileSelector;
import org.apache.avalon.assembly.engine.type.UnknownTypeException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.Profile;
import org.apache.avalon.meta.model.builder.ProfileBuilder;
import org.apache.avalon.meta.model.verifier.ProfileVerifier;
import org.apache.avalon.meta.verifier.VerifyException;
import org.apache.excalibur.configuration.ConfigurationUtil;

public class DefaultProfileRepository
extends AbstractLogEnabled
implements ProfileRepository {
    private static final ProfileBuilder PROFILE_BUILDER = new ProfileBuilder();
    private ClassLoader m_classloader;
    private ProfileRepository m_parent;
    private final List m_profiles = new ArrayList();
    private final DefaultProfileSelector m_selector = new DefaultProfileSelector();

    public DefaultProfileRepository(ClassLoader classloader) throws NullPointerException {
        this(classloader, null);
    }

    public DefaultProfileRepository(ClassLoader classloader, ProfileRepository parent) throws NullPointerException {
        if (classloader == null) {
            throw new NullPointerException("classloader");
        }
        this.m_classloader = classloader;
        this.m_parent = parent;
    }

    public Profile[] loadProfiles(Type type) throws ProfileException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            return PROFILE_BUILDER.build(this.m_classloader, type);
        }
        catch (Throwable e) {
            String error = "Unable to create packaged profiles for type: " + type.getInfo().getClassname();
            throw new ProfileException(error, e);
        }
    }

    public Profile createProfile(Type type, Configuration config) throws ProfileException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (config == null) {
            throw new NullPointerException("config");
        }
        try {
            return PROFILE_BUILDER.build(type, config);
        }
        catch (Throwable e) {
            String error = "Profile build error while constructing a profile from supplied configuration:\n" + ConfigurationUtil.list((Configuration)config);
            throw new ProfileException(error, e);
        }
    }

    public void addProfiles(Profile[] profiles) throws DuplicateProfileException, ProfileException {
        int i = 0;
        while (i < profiles.length) {
            Profile profile = profiles[i];
            this.addProfile(profile);
            ++i;
        }
    }

    public void addProfile(Profile profile) throws DuplicateProfileException, ProfileException {
        this.addProfile(profile, true);
    }

    public void addProfile(Profile profile, boolean replace) throws DuplicateProfileException, ProfileException {
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        if (this.getLogger() == null) {
            throw new IllegalStateException("logging");
        }
        try {
            this.verify(profile);
        }
        catch (Throwable e) {
            String error = "Could not register the profile: " + profile + " due to a verification failure.";
            throw new ProfileException(error, e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("add: " + profile + " " + profile.getMode());
        }
        this.m_profiles.add(profile);
    }

    public Profile getProfile(Type type) throws UnknownTypeException {
        Iterator iterator = this.m_profiles.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!profile.getType().equals((Object)type)) continue;
            return profile;
        }
        if (this.m_parent != null) {
            return this.m_parent.getProfile(type);
        }
        return null;
    }

    public Profile[] getProfiles(Type type) throws UnknownTypeException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.m_parent != null) {
            Profile[] profiles = this.m_parent.getProfiles(type);
            int i = 0;
            while (i < profiles.length) {
                list.add(profiles[i]);
                ++i;
            }
        }
        Iterator iterator = this.m_profiles.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!profile.getType().equals((Object)type)) continue;
            list.add(type);
        }
        return list.toArray(new Profile[0]);
    }

    public Profile[] getProfiles(DependencyDescriptor dependency) {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        ArrayList<Profile> list = new ArrayList<Profile>();
        if (this.m_parent != null) {
            Profile[] profiles = this.m_parent.getProfiles(dependency);
            int i = 0;
            while (i < profiles.length) {
                list.add(profiles[i]);
                ++i;
            }
        }
        ReferenceDescriptor reference = dependency.getReference();
        Iterator iterator = this.m_profiles.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            ServiceDescriptor service = profile.getService(reference);
            if (service == null) continue;
            list.add(profile);
        }
        return list.toArray(new Profile[0]);
    }

    public Profile[] getProfiles(StageDescriptor stage) {
        if (stage == null) {
            throw new NullPointerException("stage");
        }
        ArrayList<Profile> list = new ArrayList<Profile>();
        if (this.m_parent != null) {
            Profile[] profiles = this.m_parent.getProfiles(stage);
            int i = 0;
            while (i < profiles.length) {
                list.add(profiles[i]);
                ++i;
            }
        }
        Iterator iterator = this.m_profiles.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (profile.getType().getExtension(stage) == null) continue;
            list.add(profile);
        }
        return list.toArray(new Profile[0]);
    }

    public Profile getProfile(DependencyDescriptor dependency) {
        String classname = dependency.getAttribute("urn:avalon:profile.selector", null);
        if (classname == null) {
            return this.getProfile(dependency, (ProfileSelector)this.m_selector);
        }
        try {
            Class<?> clazz = this.m_classloader.loadClass(classname);
            ProfileSelector selector = (ProfileSelector)clazz.newInstance();
            if (selector instanceof LogEnabled) {
                ((LogEnabled)selector).enableLogging(this.getLogger().getChildLogger("selector"));
            }
            return this.getProfile(dependency, selector);
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to create a custom seletor: " + classname;
            throw new ProfileRuntimeException(error, e);
        }
    }

    public Profile getProfile(DependencyDescriptor dependency, ProfileSelector selector) {
        Profile[] profiles = this.getProfiles(dependency);
        return selector.select(profiles, dependency);
    }

    public Profile getProfile(StageDescriptor stage) {
        return this.getProfile(stage, (ProfileSelector)this.m_selector);
    }

    public Profile getProfile(StageDescriptor stage, ProfileSelector selector) {
        Profile[] profiles = this.getProfiles(stage);
        return selector.select(profiles, stage);
    }

    private void verify(Profile profile) throws VerifyException {
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        ProfileVerifier verifier = new ProfileVerifier();
        verifier.verifyType(profile, this.m_classloader);
    }
}

