/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.engine.impl;

import org.apache.avalon.assembly.engine.profile.ProfileSelector;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.model.Mode;
import org.apache.avalon.meta.model.Profile;

class DefaultProfileSelector
implements ProfileSelector {
    DefaultProfileSelector() {
    }

    public Profile select(Profile[] profiles, DependencyDescriptor dependency) {
        if (profiles.length == 0) {
            return null;
        }
        Profile profile = this.select(profiles, dependency, Mode.EXPLICIT);
        if (profile == null) {
            profile = this.select(profiles, dependency, Mode.PACKAGED);
        }
        if (profile == null) {
            profile = this.select(profiles, dependency, Mode.IMPLICIT);
        }
        if (profile != null) {
            return profile;
        }
        if (profiles.length > 0) {
            return profiles[0];
        }
        return null;
    }

    public Profile select(Profile[] profiles, StageDescriptor stage) {
        if (profiles.length == 0) {
            return null;
        }
        Profile profile = this.select(profiles, stage, Mode.EXPLICIT);
        if (profile == null) {
            profile = this.select(profiles, stage, Mode.PACKAGED);
        }
        if (profile == null) {
            profile = this.select(profiles, stage, Mode.IMPLICIT);
        }
        if (profile != null) {
            return profile;
        }
        if (profiles.length > 0) {
            return profiles[0];
        }
        return null;
    }

    private Profile select(Profile[] profiles, DependencyDescriptor dependency, Mode mode) {
        int i = 0;
        while (i < profiles.length) {
            Profile profile = profiles[i];
            if (profile.getService(dependency.getReference()) != null && profile.getMode().equals((Object)mode)) {
                return profile;
            }
            ++i;
        }
        return null;
    }

    private Profile select(Profile[] profiles, StageDescriptor stage, Mode mode) {
        int i = 0;
        while (i < profiles.length) {
            Profile profile = profiles[i];
            if (profile.getType().getExtension(stage) != null && profile.getMode().equals((Object)mode)) {
                return profile;
            }
            ++i;
        }
        return null;
    }
}

