/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.engine.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.apache.avalon.assembly.engine.EngineRuntimeException;
import org.apache.avalon.assembly.engine.RepositoryManager;
import org.apache.avalon.assembly.engine.impl.DefaultProfileRepository;
import org.apache.avalon.assembly.engine.impl.DefaultServiceRepository;
import org.apache.avalon.assembly.engine.impl.DefaultTypeRepository;
import org.apache.avalon.assembly.engine.profile.ProfileRepository;
import org.apache.avalon.assembly.engine.service.ServiceRepository;
import org.apache.avalon.assembly.engine.type.TypeRepository;
import org.apache.avalon.assembly.util.ExceptionHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.meta.info.Service;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.Profile;

public class DefaultRepositoryManager
extends AbstractLogEnabled
implements Initializable,
RepositoryManager {
    private static final String X_INFO = ".xinfo";
    private static final String X_TYPE = ".xtype";
    private static final String X_SERVICE = ".xservice";
    private RepositoryManager m_parent;
    private ClassLoader m_classloader;
    private TypeRepository m_types;
    private ServiceRepository m_services;
    private ProfileRepository m_profiles;
    private List m_scanned = new ArrayList();

    DefaultRepositoryManager(ClassLoader classloader, File home) {
        this(classloader, null, home);
    }

    DefaultRepositoryManager(ClassLoader classloader, RepositoryManager parent, File home) {
        if (classloader == null) {
            throw new NullPointerException("classloader");
        }
        if (home == null) {
            throw new NullPointerException("home");
        }
        this.m_classloader = classloader;
        this.m_parent = parent;
    }

    public void initialize() throws Exception {
        if (this.getLogger() == null) {
            throw new IllegalStateException("logging");
        }
        DefaultServiceRepository services = null;
        DefaultProfileRepository profiles = null;
        DefaultTypeRepository types = null;
        if (this.m_parent == null) {
            types = new DefaultTypeRepository(this.m_classloader);
            services = new DefaultServiceRepository(this.m_classloader);
            profiles = new DefaultProfileRepository(this.m_classloader);
        } else {
            types = new DefaultTypeRepository(this.m_classloader, this.m_parent.getTypeRepository());
            services = new DefaultServiceRepository(this.m_classloader, this.m_parent.getServiceRepository());
            profiles = new DefaultProfileRepository(this.m_classloader, this.m_parent.getProfileRepository());
        }
        types.enableLogging(this.getLogger().getChildLogger("types"));
        services.enableLogging(this.getLogger().getChildLogger("services"));
        profiles.enableLogging(this.getLogger().getChildLogger("profiles"));
        this.m_types = types;
        this.m_services = services;
        this.m_profiles = profiles;
    }

    public TypeRepository getTypeRepository() {
        return this.m_types;
    }

    public ServiceRepository getServiceRepository() {
        return this.m_services;
    }

    public ProfileRepository getProfileRepository() {
        return this.m_profiles;
    }

    public void install(URL url) {
        if (this.m_scanned.contains(url)) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("scanning: " + url);
        }
        if (this.isDirectory(url)) {
            File dir = this.getDirectory(url);
            try {
                this.load(dir, dir);
                this.m_scanned.add(url);
            }
            catch (IOException e) {
                String error = "Unexpected IO error while attempting to scan directory: " + dir;
                throw new EngineRuntimeException(error, (Throwable)e);
            }
            return;
        }
        if (url.getProtocol().equals("jar")) {
            this.loadJarFile(url);
            this.m_scanned.add(url);
            return;
        }
        if (this.isFile(url)) {
            try {
                URL resource = this.getJarURL(url);
                this.loadJarFile(resource);
                this.m_scanned.add(url);
                return;
            }
            catch (Throwable e) {
                String error = "Unexpected exception while loading a file: " + url;
                throw new EngineRuntimeException(error, e);
            }
        }
        try {
            Object object = url.getContent();
            if (object instanceof InputStream) {
                JarInputStream stream = new JarInputStream((InputStream)object);
                this.loadJarInputStream(stream);
                this.m_scanned.add(url);
                return;
            }
            this.getLogger().warn("unrecognized content type [" + object.getClass() + "] in url: " + url);
            return;
        }
        catch (Throwable e) {
            this.getLogger().warn("content error related to url: " + url, e);
            return;
        }
    }

    private void loadJarFile(URL url) {
        if (!url.getProtocol().equals("jar")) {
            String error = "Supplied URL is not the jar protocol.";
            throw new IllegalArgumentException("Supplied URL is not the jar protocol.");
        }
        if (!url.toString().endsWith("!/")) {
            String error = "Embeded jar file loading not supported: " + url;
            throw new IllegalArgumentException(error);
        }
        try {
            JarURLConnection jar = (JarURLConnection)url.openConnection();
            JarFile base = jar.getJarFile();
            this.m_scanned.add(url);
            this.load(base);
            return;
        }
        catch (Throwable e) {
            String error = "Unexpected error while handling url: " + url;
            throw new EngineRuntimeException(error);
        }
    }

    private URL getJarURL(URL url) throws MalformedURLException {
        if (url.getProtocol().equals("jar")) {
            return url;
        }
        return new URL("jar:" + url.toString() + "!/");
    }

    private void load(File base, File dir) throws IOException {
        ArrayList types = new ArrayList();
        this.load(types, base, dir);
        Type[] created = types.toArray(new Type[0]);
        int i = 0;
        while (i < created.length) {
            Type type = created[i];
            try {
                Profile[] profiles = this.m_profiles.loadProfiles(type);
                this.m_profiles.addProfiles(profiles);
            }
            catch (Throwable e) {
                String error = "Profile registration error from type: " + type.getInfo().getClassname();
                String warning = ExceptionHelper.packException((String)error, (Throwable)e, (boolean)false);
                this.getLogger().warn(warning, e);
            }
            ++i;
        }
    }

    private void load(List types, File base, File dir) throws IOException {
        File[] files = dir.listFiles();
        String path = base.toString();
        int j = path.length();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                this.getLogger().debug("scanning dir: " + file);
                this.load(types, base, file);
            } else {
                String filename = file.toString();
                String name = filename.substring(j, filename.length());
                if (name.endsWith(X_TYPE)) {
                    this.addType(types, name);
                } else if (name.endsWith(X_INFO)) {
                    this.addType(types, name);
                } else if (name.endsWith(X_SERVICE)) {
                    this.addService(name);
                }
            }
            ++i;
        }
    }

    private void addType(List types, String name) {
        block2: {
            String classname = this.parseResourceName(name);
            try {
                Type type = this.m_types.createType(classname);
                this.m_types.addType(type);
                types.add(type);
            }
            catch (Throwable e) {
                String error = "Could not create type from classname: " + classname;
                if (!this.getLogger().isWarnEnabled()) break block2;
                String warning = ExceptionHelper.packException((String)error, (Throwable)e, (boolean)false);
                this.getLogger().warn(warning);
            }
        }
    }

    private void addService(String name) {
        block2: {
            String classname = this.parseResourceName(name);
            try {
                Service service = this.m_services.createService(classname);
                this.m_services.addService(service);
            }
            catch (Throwable e) {
                String error = "Could not create service defintion from classname: " + classname;
                if (!this.getLogger().isWarnEnabled()) break block2;
                String warning = ExceptionHelper.packException((String)error, (Throwable)e, (boolean)false);
                this.getLogger().warn(warning);
            }
        }
    }

    private void loadJarInputStream(JarInputStream base) {
        ZipEntry entry = null;
        try {
            entry = base.getNextEntry();
        }
        catch (Throwable e) {
            entry = null;
        }
        ArrayList types = new ArrayList();
        while (entry != null) {
            String name = entry.getName();
            if (name.endsWith(X_TYPE)) {
                this.addType(types, name);
            } else if (name.endsWith(X_INFO)) {
                this.addType(types, name);
            }
            if (name.endsWith(X_SERVICE)) {
                this.addService(name);
            }
            try {
                entry = base.getNextEntry();
            }
            catch (Throwable e) {
                entry = null;
            }
        }
        Type[] created = types.toArray(new Type[0]);
        int i = 0;
        while (i < created.length) {
            Type type = created[i];
            try {
                Profile[] profiles = this.m_profiles.loadProfiles(type);
                this.m_profiles.addProfiles(profiles);
            }
            catch (Throwable e) {
                String error = "Profile registration error from type: " + type.getInfo().getClassname();
                String warning = ExceptionHelper.packException((String)error, (Throwable)e, (boolean)false);
                this.getLogger().warn(warning);
            }
            ++i;
        }
    }

    private void load(JarFile base) {
        ArrayList types = new ArrayList();
        Enumeration<JarEntry> entries = base.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.endsWith(X_TYPE)) {
                this.addType(types, name);
            } else if (name.endsWith(X_INFO)) {
                this.addType(types, name);
            }
            if (!name.endsWith(X_SERVICE)) continue;
            this.addService(name);
        }
        Type[] created = types.toArray(new Type[0]);
        int i = 0;
        while (i < created.length) {
            Type type = created[i];
            try {
                Profile[] profiles = this.m_profiles.loadProfiles(type);
                this.m_profiles.addProfiles(profiles);
            }
            catch (Throwable e) {
                String error = "Profile registration error from type: " + type.getInfo().getClassname();
                String warning = ExceptionHelper.packException((String)error, (Throwable)e, (boolean)false);
                this.getLogger().warn(warning);
            }
            ++i;
        }
    }

    private boolean isDirectory(URL url) {
        if (this.isFile(url)) {
            return this.getFile(url).isDirectory();
        }
        return false;
    }

    private boolean isFile(URL url) {
        return url.getProtocol().equals("file");
    }

    private File getDirectory(URL url) throws IllegalArgumentException {
        File file = this.getFile(url);
        if (file.isDirectory()) {
            return file;
        }
        throw new IllegalArgumentException("URL does not refer to a directory: " + url);
    }

    private File getFile(URL url) throws IllegalArgumentException {
        if (url.getProtocol().equals("file")) {
            return new File(url.toString().substring(5));
        }
        throw new IllegalArgumentException("URL protocol does not match the required file: protocol: " + url);
    }

    private String parseResourceName(String resource) {
        int i = resource.lastIndexOf(".");
        String name = resource.substring(0, i);
        String name2 = name.replace('/', '.');
        String name3 = name2.replace('\\', '.');
        if (name3.startsWith(".")) {
            return name3.substring(1, name3.length());
        }
        return name3;
    }
}

