/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.engine.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.assembly.engine.service.DuplicateServiceException;
import org.apache.avalon.assembly.engine.service.ServiceException;
import org.apache.avalon.assembly.engine.service.ServiceRepository;
import org.apache.avalon.assembly.engine.service.UnknownServiceException;
import org.apache.avalon.framework.Version;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.Service;
import org.apache.avalon.meta.info.builder.ServiceBuilder;

public class DefaultServiceRepository
extends AbstractLogEnabled
implements ServiceRepository {
    private ClassLoader m_classloader;
    private ServiceRepository m_parent;
    private static final ServiceBuilder DEFAULT_BUILDER = new ServiceBuilder();
    private List m_services = new ArrayList();

    public DefaultServiceRepository(ClassLoader classloader) throws NullPointerException {
        this(classloader, null);
    }

    public DefaultServiceRepository(ClassLoader classloader, ServiceRepository parent) throws NullPointerException {
        if (classloader == null) {
            throw new NullPointerException("classloader");
        }
        this.m_classloader = classloader;
        this.m_parent = parent;
    }

    public Service createService(Class clazz) throws ServiceException {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        try {
            return DEFAULT_BUILDER.build(clazz.getName(), clazz.getClassLoader());
        }
        catch (Throwable e) {
            String error = "Could not create a service relative to the path: " + clazz.getName() + " due to a service build error.";
            throw new ServiceException(error, e);
        }
    }

    public Service createService(String classname) throws ServiceException {
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        try {
            Class<?> clazz = this.m_classloader.loadClass(classname);
            return this.createService(clazz);
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to build a service from the classname: " + classname;
            throw new ServiceException(error, e);
        }
    }

    public Service getService(String classname, Version version) throws UnknownServiceException {
        return this.getService(new ReferenceDescriptor(classname, version));
    }

    public Service getService(ReferenceDescriptor reference) throws UnknownServiceException {
        Service service = this.getLocalService(reference);
        if (service == null) {
            if (this.m_parent != null) {
                return this.m_parent.getService(reference);
            }
            String error = "Unknown service defintion: " + reference;
            throw new UnknownServiceException(error);
        }
        return service;
    }

    private Service getLocalService(ReferenceDescriptor reference) {
        Iterator iterator = this.m_services.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            if (!service.equals((Object)reference)) continue;
            return service;
        }
        return null;
    }

    public void addService(Service service) throws DuplicateServiceException, ServiceException {
        if (this.getLogger() == null) {
            throw new IllegalStateException("logging");
        }
        try {
            this.getService(service.getReference());
            throw new DuplicateServiceException(service.toString());
        }
        catch (UnknownServiceException use) {
            this.verifyService(service);
            this.m_services.add(service);
            if (this.getLogger().isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("add: " + service.getClassname());
                buffer.append(":" + service.getVersion());
                buffer.append(", entries: " + service.getEntries().length);
                buffer.append(", attributes: " + service.getAttributeNames().length);
                this.getLogger().debug(buffer.toString());
            }
            return;
        }
    }

    private void verifyService(Service service) throws ServiceException {
        try {
            Class<?> clazz = this.m_classloader.loadClass(service.getClassname());
        }
        catch (Throwable e) {
            String error = "Unresolvable service class.";
            throw new ServiceException("Unresolvable service class.", e);
        }
    }
}

