/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.engine.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.avalon.assembly.engine.type.DuplicateTypeException;
import org.apache.avalon.assembly.engine.type.TypeException;
import org.apache.avalon.assembly.engine.type.TypeRepository;
import org.apache.avalon.assembly.engine.type.TypeRuntimeException;
import org.apache.avalon.assembly.engine.type.UnknownTypeException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.info.builder.TypeBuilder;
import org.apache.avalon.meta.verifier.ComponentVerifier;

public class DefaultTypeRepository
extends AbstractLogEnabled
implements TypeRepository {
    private static final TypeBuilder DEFAULT_BUILDER = new TypeBuilder();
    private ClassLoader m_classloader;
    private TypeRepository m_parent;
    private final Hashtable m_types = new Hashtable();

    public DefaultTypeRepository(ClassLoader classloader) throws NullPointerException {
        this(classloader, null);
    }

    public DefaultTypeRepository(ClassLoader classloader, TypeRepository parent) throws NullPointerException {
        if (classloader == null) {
            throw new NullPointerException("classloader");
        }
        this.m_classloader = classloader;
        this.m_parent = parent;
    }

    public Type createType(Class clazz) throws TypeException {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        try {
            return DEFAULT_BUILDER.buildType(clazz);
        }
        catch (Throwable e) {
            String error = "Could not register a type relative to the path: " + clazz.getName() + " due to a type build error.";
            throw new TypeException(error, e);
        }
    }

    public Type createType(String classname) throws TypeException {
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        try {
            Class<?> clazz = this.m_classloader.loadClass(classname);
            return this.createType(clazz);
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to build a type from the classname: " + classname;
            throw new TypeException(error, e);
        }
    }

    public void addType(Type type) throws DuplicateTypeException, TypeException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (this.getLogger() == null) {
            throw new IllegalStateException("logging");
        }
        String classname = type.getInfo().getClassname();
        try {
            type = this.getType(classname);
            return;
        }
        catch (UnknownTypeException ute) {
            try {
                this.verify(type);
            }
            catch (Throwable e) {
                String error = "Could not register the type: " + classname + " due to a verification failure.";
                throw new TypeException(error, e);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("add: " + type);
            }
            this.m_types.put(classname, type);
            return;
        }
    }

    public Type getType(Class clazz) throws UnknownTypeException {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return this.getType(clazz.getName());
    }

    public Type getType(String classname) throws UnknownTypeException {
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        Type type = (Type)this.m_types.get(classname);
        if (type == null) {
            if (this.m_parent != null) {
                return this.m_parent.getType(classname);
            }
            throw new UnknownTypeException(classname);
        }
        return type;
    }

    public Type[] getTypes(DependencyDescriptor dependency) {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        ArrayList<Type> list = new ArrayList<Type>();
        if (this.m_parent != null) {
            Type[] types = this.m_parent.getTypes(dependency);
            int i = 0;
            while (i < types.length) {
                list.add(types[i]);
                ++i;
            }
        }
        ReferenceDescriptor reference = dependency.getReference();
        Enumeration enumeration = this.m_types.elements();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            ServiceDescriptor service = type.getService(reference);
            if (service == null) continue;
            list.add(type);
        }
        return list.toArray(new Type[0]);
    }

    public Type[] getTypes(StageDescriptor stage) {
        if (stage == null) {
            throw new NullPointerException("stage");
        }
        ArrayList<Type> list = new ArrayList<Type>();
        if (this.m_parent != null) {
            Type[] types = this.m_parent.getTypes(stage);
            int i = 0;
            while (i < types.length) {
                list.add(types[i]);
                ++i;
            }
        }
        Iterator iterator = this.m_types.entrySet().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (type.getExtension(stage) == null) continue;
            list.add(type);
        }
        return list.toArray(new Type[0]);
    }

    private void verify(Type type) throws Exception {
        String name = type.getInfo().getName();
        Class clazz = this.getComponentClass(type);
        Class[] classes = this.getServiceClasses(type);
        ComponentVerifier verifier = new ComponentVerifier();
        verifier.verifyComponent(name, clazz, classes);
    }

    private Class[] getServiceClasses(Type type) {
        ArrayList<Class> list = new ArrayList<Class>();
        ServiceDescriptor[] services = type.getServices();
        int i = 0;
        while (i < services.length) {
            ServiceDescriptor service = services[i];
            if (service.getAttribute("urn:avalon:service.protocol", "native").equals("native") && service.getAttribute("urn:avalon:service.accessor", null) == null) {
                list.add(this.getServiceClass(services[i]));
            }
            ++i;
        }
        return list.toArray(new Class[0]);
    }

    private Class getComponentClass(Type type) throws TypeException {
        if (null == type) {
            throw new NullPointerException("type");
        }
        String classname = type.getInfo().getClassname();
        try {
            return this.m_classloader.loadClass(classname);
        }
        catch (Throwable e) {
            String error = "Could not load implementation class for component type: " + classname;
            throw new TypeException(error, e);
        }
    }

    private Class getServiceClass(ServiceDescriptor service) throws TypeRuntimeException {
        String classname = service.getReference().getClassname();
        try {
            return this.m_classloader.loadClass(classname);
        }
        catch (Throwable e) {
            String error = "Could not load implementation class for service type: " + classname;
            throw new TypeRuntimeException(error, e);
        }
    }
}

