/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.engine.impl;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.appliance.ApplianceContext;
import org.apache.avalon.assembly.appliance.ApplianceException;
import org.apache.avalon.assembly.appliance.ApplianceFactory;
import org.apache.avalon.assembly.appliance.ApplianceRepository;
import org.apache.avalon.assembly.appliance.DependencyGraph;
import org.apache.avalon.assembly.appliance.impl.DefaultApplianceContext;
import org.apache.avalon.assembly.appliance.impl.DefaultApplianceFactory;
import org.apache.avalon.assembly.appliance.impl.DefaultApplianceRepository;
import org.apache.avalon.assembly.engine.Engine;
import org.apache.avalon.assembly.engine.EngineException;
import org.apache.avalon.assembly.engine.EngineRuntimeException;
import org.apache.avalon.assembly.engine.RepositoryManager;
import org.apache.avalon.assembly.engine.impl.DefaultClasspath;
import org.apache.avalon.assembly.engine.impl.DefaultRepositoryManager;
import org.apache.avalon.assembly.engine.model.Classpath;
import org.apache.avalon.assembly.engine.model.ClasspathDescriptor;
import org.apache.avalon.assembly.engine.model.IncludeDescriptor;
import org.apache.avalon.assembly.engine.model.LibraryDescriptor;
import org.apache.avalon.assembly.engine.profile.ProfileRepository;
import org.apache.avalon.assembly.engine.type.TypeRepository;
import org.apache.avalon.assembly.locator.Contextualizable;
import org.apache.avalon.assembly.locator.Locator;
import org.apache.avalon.assembly.locator.impl.DefaultLocator;
import org.apache.avalon.assembly.logging.LoggingManager;
import org.apache.avalon.composition.repository.Repository;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.extension.Extension;
import org.apache.avalon.extension.manager.ExtensionManager;
import org.apache.avalon.extension.manager.OptionalPackage;
import org.apache.avalon.extension.manager.PackageManager;
import org.apache.avalon.extension.manager.impl.DefaultExtensionManager;
import org.apache.avalon.extension.manager.impl.DelegatingExtensionManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.Mode;
import org.apache.avalon.meta.model.Profile;
import org.apache.excalibur.mpool.PoolManager;

public class EngineClassLoader
extends URLClassLoader
implements Engine,
LogEnabled,
Contextualizable,
Initializable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$assembly$engine$impl$EngineClassLoader == null ? (class$org$apache$avalon$assembly$engine$impl$EngineClassLoader = EngineClassLoader.class$("org.apache.avalon.assembly.engine.impl.EngineClassLoader")) : class$org$apache$avalon$assembly$engine$impl$EngineClassLoader));
    private URL[] m_urls = new URL[0];
    private URL[] m_parsable = new URL[0];
    private Locator m_system;
    private ApplianceRepository m_manager;
    private DefaultRepositoryManager m_meta;
    private Map m_map;
    private LoggingManager m_logging;
    private Logger m_logger;
    private File m_home;
    private File m_root;
    private LibraryDescriptor m_descriptor;
    private Classpath m_classpath;
    private PackageManager m_packages;
    private ExtensionManager m_extensions;
    private boolean m_bootstrap = false;
    private ApplianceFactory m_factory;
    private PoolManager m_pool;
    private Repository m_repository;
    static /* synthetic */ Class class$org$apache$avalon$assembly$engine$impl$EngineClassLoader;

    public EngineClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public EngineClassLoader(ClassLoader parent) {
        this(new URL[0], parent);
    }

    public EngineClassLoader(URL[] urls, ClassLoader parent) {
        super(new URL[0], parent);
        this.m_urls = urls;
        this.m_parsable = this.getParentURLs();
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    public void contextualize(Locator context) throws ContextException {
        this.m_repository = (Repository)context.get((Object)"urn:assembly:repository");
        if (context.hasEntry((Object)"urn:assembly:system")) {
            this.m_root = (File)context.get((Object)"urn:assembly:system");
        }
        if (context.hasEntry((Object)"urn:assembly:system-map")) {
            this.m_map = (Map)context.get((Object)"urn:assembly:system-map");
        }
        if (context.hasEntry((Object)"urn:assembly:engine.extensions")) {
            String scope = "home";
            this.m_descriptor = (LibraryDescriptor)context.get((Object)"urn:assembly:engine.extensions");
            if (this.m_descriptor.isSystem()) {
                scope = "system";
            }
            String message = "registering " + scope + " extension descriptor (" + this.m_descriptor.getIncludeDescriptors().length + ")";
            this.getLogger().debug(message);
        }
        this.m_classpath = context.hasEntry((Object)"urn:assembly:engine.classpath") ? (Classpath)context.get((Object)"urn:assembly:engine.classpath") : new DefaultClasspath(new ClasspathDescriptor());
        this.m_home = context.hasEntry((Object)"urn:assembly:home") ? (File)context.get((Object)"urn:assembly:home") : new File(System.getProperty("user.dir"));
        if (context.hasEntry((Object)"urn:assembly:engine.bootstrap")) {
            this.m_bootstrap = "true".equals(context.get((Object)"urn:assembly:engine.bootstrap"));
        }
        if (context.hasEntry((Object)"urn:assembly:logging")) {
            this.m_logging = (LoggingManager)context.get((Object)"urn:assembly:logging");
        } else {
            this.getLoggingManager();
        }
        this.m_manager = context.hasEntry((Object)"urn:assembly:appliance.repository") ? (ApplianceRepository)context.get((Object)"urn:assembly:appliance.repository") : new DefaultApplianceRepository();
        if (context.hasEntry((Object)PoolManager.ROLE)) {
            this.m_pool = (PoolManager)context.get((Object)PoolManager.ROLE);
        } else {
            try {
                this.m_pool = this.getPoolManager();
            }
            catch (IllegalStateException ise) {
                throw new ContextException(PoolManager.ROLE);
            }
        }
    }

    public void initialize() throws Exception {
        if (this.getLogger() == null) {
            throw new IllegalStateException("logger");
        }
        if (this.m_manager == null) {
            throw new IllegalStateException("manager");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(REZ.getString("initialization"));
        }
        this.m_meta = this.createRepositoryManager();
        this.m_factory = DefaultApplianceFactory.createApplianceFactory(this, this.getLogger(), this.getLoggingManager(), this.m_manager, this.getSystemContext());
        ArrayList<File> list = new ArrayList<File>();
        File anchor = null;
        if (this.m_descriptor != null) {
            String warning;
            if (this.m_descriptor.isSystem()) {
                if (this.m_root != null) {
                    anchor = new File(this.m_root, this.m_descriptor.getBaseDirectory()).getCanonicalFile();
                } else {
                    warning = "Cannot process system extension descriptor in " + this + " due to undeclared system path.";
                    this.getLogger().warn(warning);
                }
            } else if (this.m_home != null) {
                String base = this.m_descriptor.getBaseDirectory();
                anchor = new File(this.m_home, base).getCanonicalFile();
            } else {
                warning = "Cannot process home extension descriptor in " + this + " due to undeclared home path.";
                this.getLogger().warn(warning);
            }
            if (anchor != null) {
                IncludeDescriptor[] includes = this.m_descriptor.getIncludeDescriptors();
                int j = 0;
                while (j < includes.length) {
                    File include = new File(anchor, includes[j].getPath()).getCanonicalFile();
                    if (!include.isDirectory()) {
                        String error = REZ.getString("error.include", (Object)include);
                        throw new IllegalArgumentException(error);
                    }
                    list.add(include);
                    this.getLogger().debug(REZ.getString("kernel.extension", (Object)include));
                    ++j;
                }
            }
        }
        if (this.m_bootstrap) {
            String sep = System.getProperty("path.separator");
            String exts = System.getProperty("java.ext.dirs");
            StringTokenizer tokenizer = new StringTokenizer(exts, sep);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                File test = new File(token).getCanonicalFile();
                if (test.exists()) {
                    list.add(test);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    String msg = REZ.getString("system.extension", (Object)token);
                    this.getLogger().debug(msg);
                    continue;
                }
                File file = new File(this.m_home, token).getCanonicalFile();
                if (file.exists()) {
                    list.add(file);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug(REZ.getString("relative.extension", (Object)file));
                    continue;
                }
                if (!this.getLogger().isWarnEnabled()) continue;
                this.getLogger().warn(REZ.getString("extension.warning", (Object)token));
            }
        }
        File[] files = list.toArray(new File[0]);
        if (this.getParent() instanceof EngineClassLoader) {
            EngineClassLoader parent = (EngineClassLoader)this.getParent();
            DefaultExtensionManager local = new DefaultExtensionManager(files);
            ExtensionManager root = parent.getExtensionManager();
            this.m_extensions = new DelegatingExtensionManager(new ExtensionManager[]{local, root});
        } else {
            this.m_extensions = new DefaultExtensionManager(files);
        }
        this.m_packages = new PackageManager(this.m_extensions);
        if (this.m_bootstrap) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(REZ.getString("bootstrap.classpath"));
            }
            String sep = System.getProperty("path.separator");
            String classpath = System.getProperty("java.class.path");
            StringTokenizer tokenizer = new StringTokenizer(classpath, sep);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                URL url = new File(token).getCanonicalFile().toURL();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(REZ.getString("bootstrap.path", (Object)url));
                }
                this.addURL(url);
            }
        }
        int k = 0;
        while (k < this.m_parsable.length) {
            this.m_meta.install(this.m_parsable[k]);
            ++k;
        }
        try {
            this.addClasspath(this.m_classpath);
        }
        catch (Throwable e) {
            String error = REZ.getString("error.classpath");
            throw new EngineException(error, e);
        }
        int i = 0;
        while (i < this.m_urls.length) {
            URL url = this.m_urls[i];
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(REZ.getString("processing.url", (Object)url));
            }
            this.addURL(url);
            ++i;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(REZ.getString("ready"));
        }
    }

    protected LoggingManager getLoggingManager() {
        if (this.m_logging == null) {
            if (this.getParent() instanceof EngineClassLoader) {
                this.m_logging = ((EngineClassLoader)this.getParent()).getLoggingManager();
            } else {
                throw new IllegalStateException("logging");
            }
        }
        return this.m_logging;
    }

    protected PoolManager getPoolManager() {
        if (this.m_pool == null) {
            if (this.getParent() instanceof EngineClassLoader) {
                this.m_pool = ((EngineClassLoader)this.getParent()).getPoolManager();
            } else {
                throw new IllegalStateException("pool");
            }
        }
        return this.m_pool;
    }

    protected ExtensionManager getExtensionManager() {
        return this.m_extensions;
    }

    protected void scanDependencies(Extension[] required, Extension[] available, List dependencies, List unsatisfied) {
        ArrayList localunsatisfied = new ArrayList();
        this.m_packages.scanDependencies(required, available, dependencies, localunsatisfied);
        if (0 != localunsatisfied.size() && this.getParent() instanceof EngineClassLoader) {
            EngineClassLoader parent = (EngineClassLoader)this.getParent();
            parent.scanDependencies(required, available, dependencies, unsatisfied);
        }
    }

    public EngineClassLoader newInstance(String name, LibraryDescriptor extensions, Classpath classpath) throws EngineException {
        return this.newInstance(name, extensions, classpath, new URL[0]);
    }

    public EngineClassLoader newInstance(String name, LibraryDescriptor extensions, Classpath classpath, URL[] urls) throws EngineException {
        try {
            EngineClassLoader engine = new EngineClassLoader(urls, (ClassLoader)this);
            engine.enableLogging(this.getLogger());
            DefaultLocator context = new DefaultLocator();
            ApplianceRepository manager = this.m_manager.createChild((Engine)engine, name);
            context.put("urn:assembly:appliance.repository", manager);
            context.put("urn:assembly:logging", this.m_logging);
            context.put("urn:assembly:home", this.m_home);
            context.put("urn:assembly:engine.bootstrap", "false");
            context.put(PoolManager.ROLE, this.m_pool);
            if (this.m_root != null) {
                context.put("urn:assembly:system", this.m_root);
            }
            if (this.m_repository != null) {
                context.put("urn:assembly:repository", this.m_repository);
            }
            if (extensions != null) {
                context.put("urn:assembly:engine.extensions", extensions);
            }
            if (classpath != null) {
                context.put("urn:assembly:engine.classpath", classpath);
            }
            context.makeReadOnly();
            engine.contextualize(context);
            engine.initialize();
            return engine;
        }
        catch (Throwable e) {
            String error = "Engine creation failure.";
            throw new EngineException("Engine creation failure.", e);
        }
    }

    protected void addURL(URL url) {
        this.addExtensions(url);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(REZ.getString("add.url", (Object)url));
        }
        super.addURL(url);
        this.m_meta.install(url);
    }

    private void addClasspath(Classpath classpath) {
        if (classpath == null) {
            throw new NullPointerException("classpath");
        }
        if (this.getLogger() == null) {
            throw new IllegalStateException("logging");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(REZ.getString("add.classpath"));
        }
        try {
            URL[] urls = classpath.expand(this.m_repository, this.m_home);
            int j = 0;
            while (j < urls.length) {
                URL inc = urls[j];
                try {
                    this.addURL(inc);
                }
                catch (Throwable e) {
                    throw new EngineRuntimeException(REZ.getString("classpath.include.error", (Object)inc), e);
                }
                ++j;
            }
            return;
        }
        catch (Throwable e) {
            String error = REZ.getString("classpath.expand.error");
            throw new EngineRuntimeException(error, e);
        }
    }

    private void addExtensions(URL url) {
        if (this.isDirectory(url)) {
            return;
        }
        try {
            String[] path = this.urlsToStrings(new URL[]{url});
            File[] extensions = this.getOptionalPackagesFor(path);
            int i = 0;
            while (i < extensions.length) {
                File ext = extensions[i];
                try {
                    URL target = ext.toURL();
                    this.addURL(target);
                }
                catch (Throwable e) {
                    String error = REZ.getString("add.ext.error", (Object)ext);
                    throw new EngineRuntimeException(error, e);
                }
                ++i;
            }
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to add extensions declared in url: " + url;
            throw new EngineRuntimeException(error, e);
        }
    }

    public RepositoryManager getRepository() {
        return this.m_meta;
    }

    public void register(String path) throws EngineRuntimeException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(REZ.getString("register.path", (Object)path));
        }
        TypeRepository types = this.getRepository().getTypeRepository();
        ProfileRepository profiles = this.getRepository().getProfileRepository();
        try {
            Type type = types.createType(path);
            types.addType(type);
            Profile[] packaged = profiles.loadProfiles(type);
            profiles.addProfiles(packaged);
        }
        catch (Throwable e) {
            String error = "Unexpected error during type registration.";
            throw new EngineRuntimeException("Unexpected error during type registration.", e);
        }
    }

    public Appliance resolve(ReferenceDescriptor reference) throws Exception {
        DependencyDescriptor dependency = new DependencyDescriptor("", reference);
        return this.resolve(new DependencyGraph(), dependency, "");
    }

    public Appliance resolve(DependencyGraph graph, DependencyDescriptor dependency) throws Exception {
        return this.resolve(graph, dependency, "");
    }

    public Appliance resolve(DependencyGraph graph, DependencyDescriptor dependency, String partition) throws Exception {
        Appliance appliance;
        if (graph == null) {
            throw new IllegalStateException("graph");
        }
        if (dependency == null) {
            throw new IllegalStateException("dependency");
        }
        if (partition == null) {
            throw new IllegalStateException("partition");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("resolving appliance for: " + dependency);
        }
        if ((appliance = this.m_manager.getAppliance(dependency)) == null) {
            Profile profile = this.getRepository().getProfileRepository().getProfile(dependency);
            if (profile == null) {
                String error = REZ.getString("resolve.fail", (Object)dependency);
                throw new EngineException(error);
            }
            DefaultApplianceContext context = new DefaultApplianceContext(profile);
            context.setPartitionName(partition);
            context.makeReadOnly();
            appliance = this.createAppliance(context, !profile.getMode().equals((Object)Mode.IMPLICIT));
        }
        try {
            appliance.assemble(graph);
        }
        catch (Throwable e) {
            throw new ApplianceException("Unresolvable assembly graph for appliance: " + appliance, e);
        }
        return appliance;
    }

    public Appliance resolve(DependencyGraph graph, StageDescriptor stage) throws Exception {
        return this.resolve(graph, stage, "");
    }

    public Appliance resolve(DependencyGraph graph, StageDescriptor stage, String partition) throws Exception {
        Appliance appliance;
        if (stage == null) {
            throw new IllegalStateException("stage");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(REZ.getString("resolve.stage.notice", (Object)stage));
        }
        if ((appliance = this.m_manager.getAppliance(stage)) == null) {
            Profile profile = this.getRepository().getProfileRepository().getProfile(stage);
            if (profile == null) {
                String error = REZ.getString("resolve.stage.fail", (Object)stage);
                throw new EngineException(error);
            }
            DefaultApplianceContext context = new DefaultApplianceContext(profile);
            context.setPartitionName(partition);
            context.makeReadOnly();
            appliance = this.createAppliance(context, !profile.getMode().equals((Object)Mode.IMPLICIT));
        }
        try {
            appliance.assemble(graph);
        }
        catch (Throwable e) {
            throw new ApplianceException("Unresolvable assembly graph for appliance: " + appliance);
        }
        return appliance;
    }

    public Appliance createAppliance(ApplianceContext context) throws ApplianceException {
        return this.createAppliance(context, true);
    }

    public Appliance createAppliance(ApplianceContext context, boolean shared) throws ApplianceException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        String path = context.getPartitionName() + context.getName();
        Logger logger = this.getLoggingManager().getSystemLoggerForCategory(path);
        String classname = context.getApplianceFactoryClassname();
        ApplianceFactory factory = classname == null ? this.m_factory : DefaultApplianceFactory.createApplianceFactory(this, classname, logger, this.getLoggingManager(), this.m_manager, this.getSystemContext());
        Appliance appliance = factory.createAppliance(this.getSystemContext(), (Engine)this, context);
        if (shared) {
            this.m_manager.addAppliance(appliance);
        }
        return appliance;
    }

    private URL[] getParentURLs() {
        if (this.getParent() instanceof EngineClassLoader) {
            return new URL[0];
        }
        ArrayList list = new ArrayList();
        this.getParentURLs(list, this.getParent());
        return list.toArray(new URL[0]);
    }

    private void getParentURLs(List list, ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            int i = 0;
            while (i < urls.length) {
                list.add(urls[i]);
                ++i;
            }
            if (loader.getParent() instanceof URLClassLoader) {
                this.getParentURLs(list, loader.getParent());
            }
        }
    }

    private DefaultRepositoryManager createRepositoryManager() throws Exception {
        ClassLoader parent = this.getParent();
        DefaultRepositoryManager manager = parent != null && parent instanceof EngineClassLoader ? new DefaultRepositoryManager(this, ((EngineClassLoader)parent).getRepository(), this.m_home) : new DefaultRepositoryManager(this, this.m_home);
        manager.enableLogging(this.getLogger());
        manager.initialize();
        return manager;
    }

    private Locator getSystemContext() {
        if (this.m_system != null) {
            return this.m_system;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("resolving system context");
        }
        DefaultLocator context = this.m_map != null ? new DefaultLocator(this.m_map) : new DefaultLocator();
        try {
            context.get("urn:assembly:home");
        }
        catch (ContextException ce) {
            context.put("urn:assembly:home", this.m_home);
        }
        try {
            context.get("urn:assembly:domain");
        }
        catch (ContextException ce) {
            context.put("urn:assembly:domain", "localhost");
        }
        context.put("urn:assembly:logging", this.getLoggingManager());
        context.put(PoolManager.ROLE, this.getPoolManager());
        this.m_system = context;
        return this.m_system;
    }

    private boolean isDirectory(URL url) {
        if (url.getProtocol().equals("file")) {
            File file = new File(url.toString().substring(5));
            return file.isDirectory();
        }
        return false;
    }

    private String[] urlsToStrings(URL[] urls) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < urls.length) {
            list.add(urls[i].toString());
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    protected File[] getOptionalPackagesFor(String[] classPath) throws Exception {
        Manifest[] manifests = this.getManifests(classPath);
        Extension[] available = Extension.getAvailable((Manifest[])manifests);
        Extension[] required = Extension.getRequired((Manifest[])manifests);
        ArrayList dependencies = new ArrayList();
        ArrayList unsatisfied = new ArrayList();
        this.scanDependencies(required, available, dependencies, unsatisfied);
        if (0 != unsatisfied.size()) {
            int size = unsatisfied.size();
            if (this.getLogger().isWarnEnabled()) {
                int i = 0;
                while (i < size) {
                    Extension extension = (Extension)unsatisfied.get(i);
                    Object[] params = new Object[]{extension.getExtensionName(), extension.getSpecificationVendor(), extension.getSpecificationVersion(), extension.getImplementationVendor(), extension.getImplementationVendorID(), extension.getImplementationVersion(), extension.getImplementationURL()};
                    String message = REZ.format("missing.extension", params);
                    this.getLogger().warn(message);
                    ++i;
                }
            }
            String message = REZ.getString("unsatisfied.extensions", (Object)new Integer(size));
            throw new Exception(message);
        }
        OptionalPackage[] packages = dependencies.toArray(new OptionalPackage[0]);
        return OptionalPackage.toFiles((OptionalPackage[])packages);
    }

    private Manifest[] getManifests(String[] classPath) throws Exception {
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        int i = 0;
        while (i < classPath.length) {
            String element = classPath[i];
            if (element.endsWith(".jar") || element.startsWith("jar:")) {
                try {
                    URL url = null;
                    url = element.startsWith("jar:") ? new URL(element) : new URL("jar:" + element + "!/");
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    Manifest manifest = connection.getManifest();
                    manifests.add(manifest);
                }
                catch (IOException ioe) {
                    String message = REZ.getString("bad-classpath-entry", (Object)element);
                    throw new EngineException(message + ": " + element, (Throwable)ioe);
                }
            }
            ++i;
        }
        return manifests.toArray(new Manifest[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

