/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.engine.impl;

import java.util.ArrayList;
import org.apache.avalon.assembly.engine.model.ClasspathDescriptor;
import org.apache.avalon.assembly.engine.model.FilesetDescriptor;
import org.apache.avalon.assembly.engine.model.IncludeDescriptor;
import org.apache.avalon.assembly.engine.model.LibraryDescriptor;
import org.apache.avalon.assembly.engine.model.ResourceDescriptor;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class EngineConfigurationHelper {
    public static ClasspathDescriptor createClasspathDescriptor(Configuration config) throws ConfigurationException {
        ArrayList<FilesetDescriptor> list = new ArrayList<FilesetDescriptor>();
        Configuration[] configs = config.getChildren("fileset");
        int i = 0;
        while (i < configs.length) {
            Configuration c = configs[i];
            list.add(EngineConfigurationHelper.createFilesetDescriptor(c));
            ++i;
        }
        FilesetDescriptor[] filesets = list.toArray(new FilesetDescriptor[0]);
        ArrayList<ResourceDescriptor> res = new ArrayList<ResourceDescriptor>();
        Configuration repository = config.getChild("repository");
        Configuration[] resources = repository.getChildren("resource");
        int i2 = 0;
        while (i2 < resources.length) {
            Configuration resource = resources[i2];
            String id = resource.getAttribute("id");
            String version = resource.getAttribute("version", null);
            res.add(new ResourceDescriptor(id, version));
            ++i2;
        }
        ResourceDescriptor[] descriptors = res.toArray(new ResourceDescriptor[0]);
        return new ClasspathDescriptor(filesets, descriptors);
    }

    public static FilesetDescriptor createFilesetDescriptor(Configuration config) throws ConfigurationException {
        String base = config.getAttribute("dir", ".");
        ArrayList<IncludeDescriptor> list = new ArrayList<IncludeDescriptor>();
        Configuration[] includeConfigs = config.getChildren("include");
        int i = 0;
        while (i < includeConfigs.length) {
            Configuration includeConfig = includeConfigs[i];
            list.add(EngineConfigurationHelper.createIncludeDescriptor(includeConfig));
            ++i;
        }
        IncludeDescriptor[] includes = list.toArray(new IncludeDescriptor[0]);
        return new FilesetDescriptor(base, includes);
    }

    public static IncludeDescriptor createIncludeDescriptor(Configuration config) throws ConfigurationException {
        String filename = config.getAttribute("name");
        return new IncludeDescriptor(filename);
    }

    public static LibraryDescriptor createLibraryDescriptor(Configuration config) throws ConfigurationException {
        if (config == null) {
            return new LibraryDescriptor();
        }
        String base = config.getAttribute("dir", ".");
        String scope = config.getAttribute("scope", "home");
        ArrayList<IncludeDescriptor> list = new ArrayList<IncludeDescriptor>();
        Configuration[] configs = config.getChildren("include");
        int i = 0;
        while (i < configs.length) {
            Configuration c = configs[i];
            list.add(EngineConfigurationHelper.createIncludeDescriptor(c));
            ++i;
        }
        IncludeDescriptor[] dirs = list.toArray(new IncludeDescriptor[0]);
        return new LibraryDescriptor(scope, base, dirs);
    }
}

