/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.lifecycle.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.avalon.assembly.lifecycle.LifecycleException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.Type;

final class ComponentInvocationHandler
implements InvocationHandler {
    private transient Object m_object;
    private transient Component m_proxy;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$Component;

    protected ComponentInvocationHandler(Object object, Type type) throws Exception {
        ClassLoader loader = object.getClass().getClassLoader();
        Class[] interfaces = this.getClasses(type, loader);
        this.m_object = object;
        this.m_proxy = (Component)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
    }

    public void invalidate() {
        this.m_object = null;
        this.m_proxy = null;
    }

    public Component getProxy() {
        return this.m_proxy;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (null == this.m_object) {
            throw new IllegalStateException("Object has not been initialized.");
        }
        try {
            return method.invoke(this.m_object, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private Class[] getClasses(Type type, ClassLoader loader) throws Exception {
        try {
            ServiceDescriptor[] services = type.getServices();
            Class[] classes = new Class[services.length + 1];
            int i = 0;
            while (i < services.length) {
                classes[i] = loader.loadClass(services[i].getReference().getClassname());
                ++i;
            }
            classes[services.length] = class$org$apache$avalon$framework$component$Component == null ? (class$org$apache$avalon$framework$component$Component = ComponentInvocationHandler.class$("org.apache.avalon.framework.component.Component")) : class$org$apache$avalon$framework$component$Component;
            return classes;
        }
        catch (Throwable e) {
            String error = "Unable to create a Component proxy for an type: " + type;
            throw new LifecycleException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

