/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.lifecycle.impl;

import java.util.Map;
import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.lifecycle.Contextualization;
import org.apache.avalon.assembly.lifecycle.impl.AvalonContextualizer;
import org.apache.avalon.assembly.lifecycle.impl.ContextualizationService;
import org.apache.avalon.assembly.lifecycle.impl.DefaultContextualizer;
import org.apache.avalon.assembly.locator.Contextualizable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class DefaultContextualizationService
extends AbstractLogEnabled
implements ContextualizationService {
    public void contextualize(ClassLoader loader, Appliance appliance, Object object) throws Exception {
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        if (appliance == null) {
            throw new NullPointerException("appliance");
        }
        if (object == null) {
            throw new NullPointerException("object");
        }
        Map context = appliance.getContextMap();
        if (context != null) {
            Appliance provider = appliance.getContextProvider();
            if (provider != null) {
                if (this.getLogger().isDebugEnabled()) {
                    String message = "activating custom context provider: " + provider + " for appliance: " + appliance;
                    this.getLogger().debug(message);
                }
                try {
                    Contextualization handler = (Contextualization)provider.resolve((Object)this);
                    handler.contextualize(loader, appliance.getContextDirective(), object, context);
                    provider.release((Object)handler, (Object)this);
                    return;
                }
                catch (Throwable e) {
                    String error = "Contextualization handler failure in appliance: " + appliance;
                    throw new ContextException(error, e);
                }
            }
            if (object instanceof Contextualizable) {
                DefaultContextualizer contextualizer = new DefaultContextualizer();
                if (this.getLogger().isDebugEnabled()) {
                    String message = appliance.toString() + " (Locator Policy)";
                    this.getLogger().debug(message);
                }
                try {
                    contextualizer.contextualize(loader, appliance.getContextDirective(), object, context);
                }
                catch (Throwable e) {
                    String error = "Unexpected exception during contextualization of target: " + appliance;
                    throw new ContextException(error, e);
                }
            }
            if (object instanceof org.apache.avalon.framework.context.Contextualizable) {
                AvalonContextualizer contextualizer = new AvalonContextualizer();
                if (this.getLogger().isDebugEnabled()) {
                    String message = appliance.toString() + " (Avalon Policy)";
                    this.getLogger().debug(message);
                }
                try {
                    contextualizer.contextualize(loader, appliance.getContextDirective(), object, context);
                }
                catch (ContextException e) {
                    String error = "Target component is requesting a context entry that has not been declared. Please check component xinfo descriptor context criteria in type: " + appliance.getType();
                    throw new ContextException(error, (Throwable)e);
                }
                catch (Throwable e) {
                    String error = "Unexpected exception during contextualization of target: " + appliance;
                    throw new ContextException(error, e);
                }
            }
        }
    }
}

