/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.lifecycle.impl;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.lifecycle.DeploymentException;
import org.apache.avalon.assembly.lifecycle.DeploymentService;
import org.apache.avalon.assembly.lifecycle.DeploymentStageExtension;
import org.apache.avalon.assembly.lifecycle.impl.ContextualizationService;
import org.apache.avalon.assembly.lifecycle.impl.DefaultContextualizationService;
import org.apache.avalon.assembly.lifecycle.impl.StandardServiceManager;
import org.apache.avalon.assembly.lifecycle.impl.WrapperComponentManager;
import org.apache.avalon.assembly.locator.Contextualizable;
import org.apache.avalon.assembly.locator.Locator;
import org.apache.avalon.assembly.locator.impl.DefaultLocator;
import org.apache.avalon.assembly.logging.LoggingManager;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Executable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.lifecycle.Creator;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.model.LoggingDirective;
import org.apache.excalibur.configuration.ConfigurationUtil;

public class DefaultDeploymentService
extends AbstractLogEnabled
implements Contextualizable,
Initializable,
DeploymentService {
    private LoggingManager m_logging;
    private ContextualizationService m_contextualization;
    private boolean m_initialized = false;

    public void contextualize(Locator context) throws ContextException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.m_logging = (LoggingManager)context.get((Object)"urn:assembly:logging");
    }

    public void initialize() throws Exception {
        try {
            DefaultContextualizationService service = new DefaultContextualizationService();
            service.enableLogging(this.getLogger().getChildLogger("context"));
            this.m_contextualization = service;
        }
        catch (Throwable e) {
            String error = "Internal error while attempting to build the bootstrap contextualization service.";
            throw new DeploymentException("Internal error while attempting to build the bootstrap contextualization service.", e);
        }
        this.m_initialized = true;
    }

    public Object deploy(Appliance appliance, ClassLoader classloader) throws DeploymentException {
        if (!this.m_initialized) {
            throw new IllegalStateException("initialization");
        }
        if (appliance == null) {
            throw new NullPointerException("appliance");
        }
        if (classloader == null) {
            throw new NullPointerException("classloader");
        }
        try {
            String message;
            StageDescriptor[] stages;
            Object instance;
            try {
                String classname = appliance.getType().getInfo().getClassname();
                Class<?> clazz = classloader.loadClass(classname);
                instance = clazz.newInstance();
                if (this.getLogger().isDebugEnabled()) {
                    int id = System.identityHashCode(instance);
                    this.getLogger().debug("component instance: " + id);
                }
            }
            catch (Throwable e) {
                String error = "Component implementation instantiation error in appliance: " + appliance;
                throw new DeploymentException(error, e);
            }
            if (instance instanceof LogEnabled) {
                this.handleLogging(appliance, (LogEnabled)instance);
            }
            this.m_contextualization.contextualize(classloader, appliance, instance);
            if (instance instanceof Serviceable || instance instanceof Composable) {
                this.handleServiceable(appliance, instance);
            }
            if (instance instanceof Configurable) {
                this.handleConfiguration(appliance, (Configurable)instance);
            }
            if (instance instanceof Parameterizable) {
                this.handleParameterization(appliance, (Parameterizable)instance);
            }
            if ((stages = appliance.getType().getStages()).length > 0) {
                int i = 0;
                while (i < stages.length) {
                    StageDescriptor stage = stages[i];
                    this.processCreateStage(appliance, stage, instance);
                    ++i;
                }
            }
            if (instance instanceof Initializable) {
                if (this.getLogger().isDebugEnabled()) {
                    message = "initializing " + appliance;
                    this.getLogger().debug(message);
                }
                ((Initializable)instance).initialize();
            }
            if (instance instanceof Startable) {
                if (this.getLogger().isDebugEnabled()) {
                    message = "starting " + appliance;
                    this.getLogger().debug(message);
                }
                ((Startable)instance).start();
            } else if (instance instanceof Executable) {
                if (this.getLogger().isDebugEnabled()) {
                    message = "executing " + appliance;
                    this.getLogger().debug(message);
                }
                ((Executable)instance).execute();
            }
            return instance;
        }
        catch (CascadingException ce) {
            if (ce.getCause() instanceof ClassNotFoundException) {
                throw this.buildDeploymentException(ce, (ClassNotFoundException)ce.getCause());
            }
            String error = "Component deployment failure in appliance: " + appliance;
            throw new DeploymentException(error, (Throwable)ce);
        }
        catch (ClassNotFoundException cnfe) {
            throw this.buildDeploymentException(cnfe, cnfe);
        }
        catch (Throwable e) {
            String error = "Component deployment failure in appliance: " + appliance;
            throw new DeploymentException(error, e);
        }
    }

    private DeploymentException buildDeploymentException(Throwable e, ClassNotFoundException cnfe) {
        StringBuffer buffer = new StringBuffer("Class not found: " + cnfe.getMessage());
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader instanceof URLClassLoader) {
            buffer.append(" in classloader containing: ");
            URL[] urls = ((URLClassLoader)loader).getURLs();
            int i = 0;
            while (i < urls.length) {
                buffer.append("\n  " + urls[i]);
                ++i;
            }
        }
        String error = buffer.toString();
        return new DeploymentException(error, e);
    }

    public void decommission(Appliance appliance, Object instance) {
        this.decommission(appliance, instance, true);
    }

    public void decommission(Appliance appliance, Object instance, boolean disassemble) {
        String message;
        StageDescriptor[] stages;
        if (appliance == null) {
            throw new NullPointerException("appliance");
        }
        if (instance == null) {
            throw new NullPointerException("instance");
        }
        if (disassemble) {
            appliance.disassemble();
        }
        if (instance instanceof Startable) {
            if (this.getLogger().isDebugEnabled()) {
                String message2 = "stopping " + appliance;
                this.getLogger().debug(message2);
            }
            try {
                ((Startable)instance).stop();
            }
            catch (Throwable se) {
                String warning = "Component related error while process stop phase under appliance: " + appliance.toString();
                this.getLogger().warn(warning);
            }
        }
        if ((stages = appliance.getType().getStages()).length > 0) {
            if (this.getLogger().isDebugEnabled()) {
                message = "destroy stage extension handling for appliance:" + appliance;
                this.getLogger().debug(message);
            }
            int i = 0;
            while (i < stages.length) {
                StageDescriptor stage = stages[i];
                this.processDestroyStage(appliance, stage, instance);
                ++i;
            }
        }
        if (instance instanceof Disposable) {
            if (this.getLogger().isDebugEnabled()) {
                message = "disposal " + appliance;
                this.getLogger().debug(message);
            }
            ((Disposable)instance).dispose();
        }
    }

    private void handleLogging(Appliance appliance, LogEnabled object) throws Exception {
        LoggingDirective logging = appliance.getLoggingDirective();
        String path = appliance.getPath();
        if (object instanceof Appliance) {
            if (path.endsWith("$bootstrap")) {
                path = path.substring(0, path.length() - 10);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("logging (sys): " + appliance + " on path: " + path);
            }
            this.m_logging.addSystemCategories(path, logging);
            Logger logger = this.m_logging.getSystemLoggerForCategory(path);
            object.enableLogging(logger);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("logging: " + appliance + " on path: " + path);
            }
            this.m_logging.addCategories(path, logging);
            Logger logger = this.m_logging.getLoggerForCategory(path);
            object.enableLogging(logger);
        }
    }

    private void handleConfiguration(Appliance appliance, Configurable object) throws Exception {
        Configuration config = appliance.getConfiguration();
        if (config == null) {
            config = new DefaultConfiguration("configuration", ((Object)((Object)this)).getClass().getName());
        }
        if (this.getLogger().isDebugEnabled()) {
            String message = "configure: " + appliance + "\n" + ConfigurationUtil.list((Configuration)config);
            this.getLogger().debug(message);
        }
        object.configure(config);
    }

    private void handleParameterization(Appliance appliance, Parameterizable object) throws Exception {
        Parameters params = appliance.getParameters();
        if (params == null) {
            params = Parameters.EMPTY_PARAMETERS;
        }
        if (this.getLogger().isDebugEnabled()) {
            String message = "parameterize: " + appliance.toString();
            this.getLogger().debug(message);
        }
        object.parameterize(params);
    }

    private void handleServiceable(Appliance appliance, Object object) throws Exception {
        if (object instanceof Serviceable) {
            if (this.getLogger().isDebugEnabled()) {
                String message = "servicing: " + appliance.toString();
                this.getLogger().debug(message);
            }
            StandardServiceManager manager = new StandardServiceManager(appliance);
            manager.enableLogging(this.getLogger().getChildLogger("manager"));
            ((Serviceable)object).service((ServiceManager)manager);
        } else if (object instanceof Composable) {
            if (this.getLogger().isDebugEnabled()) {
                String message = "composing: " + appliance.toString();
                this.getLogger().debug(message);
            }
            StandardServiceManager manager = new StandardServiceManager(appliance);
            manager.enableLogging(this.getLogger().getChildLogger("manager"));
            ((Composable)object).compose((ComponentManager)new WrapperComponentManager(manager));
        }
    }

    private void processCreateStage(Appliance appliance, StageDescriptor stage, Object object) {
        block7: {
            try {
                Appliance provider = appliance.getExtensionProvider(stage);
                if (provider == null) {
                    String error = "Missing extension provider in appliance: '" + appliance + "' for the stage: " + stage;
                    throw new DeploymentException(error);
                }
                try {
                    Object handler = provider.resolve((Object)this);
                    if (handler instanceof Creator) {
                        ((Creator)handler).create(object, (Context)new DefaultLocator(appliance.getContextMap()));
                    }
                    if (handler instanceof DeploymentStageExtension) {
                        ((DeploymentStageExtension)handler).create(appliance, stage, object);
                    }
                    provider.release(handler, (Object)this);
                }
                catch (Throwable e) {
                    String error = "Extension handler execution error in appliance: '" + appliance.toString() + "' under stage: '" + stage + "' for target: '" + object + "'";
                    throw new DeploymentException(error, e);
                }
            }
            catch (Throwable e) {
                if (!this.getLogger().isWarnEnabled()) break block7;
                String warning = "Ignoring extension related error during destroy stage.";
                this.getLogger().warn("Ignoring extension related error during destroy stage.", e);
            }
        }
    }

    private void processDestroyStage(Appliance appliance, StageDescriptor stage, Object object) {
        block7: {
            try {
                Appliance provider = appliance.getExtensionProvider(stage);
                if (provider == null) {
                    String error = "Missing extension provider in appliance: '" + appliance + "' for the stage: " + stage;
                    throw new DeploymentException(error);
                }
                try {
                    Object handler = provider.resolve((Object)this);
                    if (handler instanceof Creator) {
                        ((Creator)handler).destroy(object, (Context)new DefaultLocator(appliance.getContextMap()));
                    }
                    if (handler instanceof DeploymentStageExtension) {
                        ((DeploymentStageExtension)handler).destroy(appliance, stage, object);
                    }
                    provider.release(handler, (Object)this);
                }
                catch (Throwable e) {
                    String error = "Extension handler execution error in appliance: '" + appliance.toString() + "' under stage: '" + stage + "' for target: '" + object + "'";
                    throw new DeploymentException(error, e);
                }
            }
            catch (Throwable e) {
                if (!this.getLogger().isWarnEnabled()) break block7;
                String warning = "Ignoring extension related error during destroy stage.";
                this.getLogger().warn("Ignoring extension related error during destroy stage.", e);
            }
        }
    }
}

