/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.lifecycle.impl;

import java.util.Hashtable;
import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.meta.info.DependencyDescriptor;

class StandardServiceManager
extends AbstractLogEnabled
implements ServiceManager {
    private Appliance m_appliance;
    private Hashtable m_table = new Hashtable();

    public StandardServiceManager(Appliance appliance) {
        this.m_appliance = appliance;
    }

    public boolean hasService(String role) {
        return this.m_appliance.getServiceProvider(role) != null;
    }

    public Object lookup(String role) throws ServiceException {
        if (role == null) {
            throw new NullPointerException("role");
        }
        DependencyDescriptor dependency = this.m_appliance.getType().getDependency(role);
        if (dependency == null) {
            String error = "Component: '" + this.m_appliance + "' is requesting an unknown role'";
            throw new ServiceException(role, error);
        }
        Appliance provider = this.m_appliance.getServiceProvider(role);
        if (provider == null) {
            String error = "Internal error - incorrect assembly in appliance: " + this.m_appliance + ". A null provider was returned for the dependency: " + dependency;
            throw new ServiceException(role, error);
        }
        try {
            Object object = provider.resolve((Object)this);
            this.m_table.put(this.getKey(object), provider);
            return object;
        }
        catch (Throwable e) {
            String error = "Unexpected internal error while accessing a service provider in appliance: " + this.m_appliance + " for the role: " + role;
            throw new ServiceException(role, error, e);
        }
    }

    public void release(Object object) {
        if (object == null) {
            return;
        }
        Appliance provider = (Appliance)this.m_table.get(this.getKey(object));
        if (provider == null) {
            if (this.getLogger().isWarnEnabled()) {
                String warning = "Inconsistent release request - the object: " + object.getClass().getName() + "/" + System.identityHashCode(object) + " was not provided by this manager.";
                this.getLogger().warn(warning);
            }
        } else {
            provider.release(object, (Object)this);
            this.m_table.remove(object);
        }
    }

    private String getKey(Object object) {
        return object.getClass().getName() + "/" + System.identityHashCode(object);
    }
}

