/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.lifecycle.impl;

import org.apache.avalon.assembly.engine.Engine;
import org.apache.avalon.assembly.lifecycle.impl.ComponentInvocationHandler;
import org.apache.avalon.assembly.lifecycle.impl.WrapperComponentSelector;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.meta.info.Type;

class WrapperComponentManager
implements ComponentManager {
    private final ServiceManager m_manager;

    public WrapperComponentManager(ServiceManager manager) {
        if (null == manager) {
            throw new NullPointerException("manager");
        }
        this.m_manager = manager;
    }

    public Component lookup(String key) throws ComponentException {
        try {
            Object object = this.m_manager.lookup(key);
            if (object instanceof ServiceSelector) {
                return new WrapperComponentSelector(key, (ServiceSelector)object);
            }
            if (object instanceof Component) {
                return (Component)object;
            }
            Class<?> clazz = object.getClass();
            ClassLoader loader = clazz.getClassLoader();
            if (!(loader instanceof Engine)) {
                String error = "Resolved component is not contained within an engine classloader. Cannot build a Component interface proxy.";
                throw new ComponentException(key, "Resolved component is not contained within an engine classloader. Cannot build a Component interface proxy.");
            }
            Type type = ((Engine)loader).getRepository().getTypeRepository().getType(clazz);
            return new ComponentInvocationHandler(object, type).getProxy();
        }
        catch (ServiceException se) {
            throw new ComponentException(se.getKey(), se.getMessage(), se.getCause());
        }
        catch (Throwable e) {
            String error = "Unexpected error while handling component lookup request.";
            throw new ComponentException(key, "Unexpected error while handling component lookup request.", e);
        }
    }

    public boolean hasComponent(String key) {
        return this.m_manager.hasService(key);
    }

    public void release(Component component) {
        if (component instanceof WrapperComponentSelector) {
            this.m_manager.release((Object)((WrapperComponentSelector)component).getWrappedSelector());
        } else {
            this.m_manager.release((Object)component);
        }
    }
}

