/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.lifestyle.impl;

import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.lifecycle.DeploymentException;
import org.apache.avalon.assembly.lifecycle.DeploymentService;
import org.apache.avalon.assembly.lifestyle.LifestyleException;
import org.apache.avalon.assembly.lifestyle.LifestyleHandler;
import org.apache.avalon.assembly.lifestyle.LifestyleRuntimeException;
import org.apache.avalon.assembly.locator.Contextualizable;
import org.apache.avalon.assembly.locator.Locator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.lifecycle.Accessor;
import org.apache.avalon.meta.info.StageDescriptor;

public abstract class AbstractLifestyleHandler
extends AbstractLogEnabled
implements Contextualizable,
Initializable,
Disposable,
LifestyleHandler {
    private Appliance m_appliance;
    private ClassLoader m_classloader;
    protected DeploymentService m_deployment;

    public void contextualize(Locator context) throws ContextException {
        this.m_classloader = (ClassLoader)context.get((Object)"urn:avalon:classloader");
        this.m_deployment = (DeploymentService)context.get((Object)"urn:assembly:lifecycle.deployment");
        Object object = context.get((Object)"urn:assembly:appliance");
        if (!(object instanceof Appliance)) {
            String error = "Supplied appliance is not an instance of Appliance. Object: " + object;
            throw new IllegalStateException(error);
        }
        this.m_appliance = (Appliance)object;
    }

    public void initialize() throws Exception {
        if (this.getLogger() == null) {
            throw new LifestyleException("logger");
        }
        if (this.m_appliance == null) {
            throw new LifestyleException("context");
        }
    }

    public Object resolve(Object source, String ref) throws Exception {
        return this.resolve(source);
    }

    public abstract Object resolve(Object var1) throws Exception;

    public void release(Object object, Object source) {
        if (this.getLogger().isDebugEnabled()) {
            String debug = "release: " + this.getAppliance();
            this.getLogger().debug(debug);
        }
        this.processReleaseStage(object);
        this.m_deployment.decommission(this.getAppliance(), object);
    }

    public void dispose() {
        this.m_appliance = null;
        this.m_classloader = null;
        this.m_deployment = null;
    }

    protected Appliance getAppliance() {
        if (this.m_appliance == null) {
            throw new IllegalStateException("appliance");
        }
        return this.m_appliance;
    }

    protected Object newInstance() throws DeploymentException {
        return this.m_deployment.deploy(this.m_appliance, this.m_classloader);
    }

    protected void processAccessStage(Object object) throws Exception {
        StageDescriptor[] phases = this.getAppliance().getType().getStages();
        int i = 0;
        while (i < phases.length) {
            StageDescriptor stage = phases[i];
            this.processExtension(stage, object, true);
            ++i;
        }
    }

    protected void processReleaseStage(Object object) {
        StageDescriptor[] phases = this.getAppliance().getType().getStages();
        int i = phases.length - 1;
        while (i > -1) {
            block3: {
                StageDescriptor stage = phases[i];
                try {
                    this.processExtension(stage, object, false);
                }
                catch (Throwable e) {
                    if (!this.getLogger().isWarnEnabled()) break block3;
                    String warning = "Ignoring release exception.";
                    this.getLogger().warn("Ignoring release exception.", e);
                }
            }
            --i;
        }
    }

    private void processExtension(StageDescriptor stage, Object object, boolean access) throws Exception {
        Appliance provider = this.m_appliance.getExtensionProvider(stage);
        if (provider == null) {
            String error = "Null provider returned from appliance: " + this.m_appliance + " stage: " + stage;
            throw new IllegalStateException(error);
        }
        Object handler = provider.resolve((Object)this);
        if (handler != null && handler instanceof Accessor) {
            Accessor extension = (Accessor)handler;
            try {
                DefaultContext context = new DefaultContext(this.getAppliance().getContextMap());
                if (access) {
                    extension.access(object, (Context)context);
                } else {
                    extension.release(object, (Context)context);
                }
                provider.release((Object)extension, (Object)this);
            }
            catch (Throwable e) {
                String error = "Extension provider appliance: " + provider + " raised a execution exception while processing an inner stage: " + stage + " in appliance: " + this.m_appliance;
                throw new LifestyleException(error, e);
            }
        }
    }

    private Class getImplementationClass() {
        try {
            String classname = this.m_appliance.getType().getInfo().getClassname();
            return this.m_classloader.loadClass(classname);
        }
        catch (Throwable e) {
            String error = "Internal error while attempting to load the implementation class for an appliance: " + this.m_appliance;
            throw new LifestyleRuntimeException(error, e);
        }
    }

    public abstract void decommission() throws Exception;

    public void terminate() {
        this.dispose();
    }
}

