/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.lifestyle.impl;

import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.lifecycle.DeploymentException;
import org.apache.avalon.assembly.lifestyle.LifestyleException;
import org.apache.avalon.assembly.lifestyle.impl.AbstractLifestyleHandler;
import org.apache.avalon.assembly.locator.Contextualizable;
import org.apache.avalon.assembly.locator.Locator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.excalibur.mpool.ObjectFactory;
import org.apache.excalibur.mpool.Pool;
import org.apache.excalibur.mpool.PoolManager;

public class PooledLifestyleHandler
extends AbstractLifestyleHandler
implements ObjectFactory,
Configurable,
Contextualizable,
Initializable,
Disposable {
    private Appliance m_appliance;
    private Locator m_context;
    private PoolManager m_poolManager;
    private Pool m_pool;
    private int m_size = 5;
    private Class m_class;

    public void configure(Configuration config) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("config");
        }
        this.m_size = config.getAttributeAsInteger("size", 5);
    }

    public void contextualize(Locator context) throws ContextException {
        super.contextualize(context);
        this.m_poolManager = (PoolManager)context.get((Object)PoolManager.ROLE);
        this.m_context = context;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.m_appliance = (Appliance)this.m_context.get((Object)"urn:assembly:appliance");
        ClassLoader classloader = (ClassLoader)this.m_context.get((Object)"urn:avalon:classloader");
        this.m_class = classloader.loadClass(this.m_appliance.getType().getInfo().getClassname());
    }

    public Object resolve(Object partition) throws Exception {
        return this.access();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object access() throws Exception {
        try {
            if (this.m_pool == null) {
                PoolManager poolManager = this.m_poolManager;
                synchronized (poolManager) {
                    if (this.m_pool == null) {
                        this.m_pool = this.m_poolManager.getManagedPool((ObjectFactory)this, this.m_size);
                    }
                }
            }
            Object object = this.m_pool.acquire();
            super.processAccessStage(object);
            return object;
        }
        catch (Throwable e) {
            String error = "Pooled object creation error.";
            throw new LifestyleException("Pooled object creation error.", e);
        }
    }

    public void release(Object object, Object partition) {
        block3: {
            if (object == null) {
                return;
            }
            try {
                super.processReleaseStage(object);
                this.m_pool.release(object);
            }
            catch (Throwable e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                String warning = "Unexpected error occured while releasing a pooled object.";
                this.getLogger().warn("Unexpected error occured while releasing a pooled object.");
            }
        }
    }

    public void decommission() throws Exception {
    }

    public Class getCreatedClass() {
        return this.m_class;
    }

    public void dispose(Object object) throws Exception {
        this.m_deployment.decommission(this.m_appliance, object);
    }

    public Object newInstance() throws DeploymentException {
        return super.newInstance();
    }

    public void dispose() {
        if (this.m_pool instanceof Disposable) {
            try {
                ((Disposable)this.m_pool).dispose();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.m_pool = null;
        this.m_poolManager = null;
    }
}

