/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.lifestyle.impl;

import org.apache.avalon.assembly.lifecycle.DeploymentException;
import org.apache.avalon.assembly.lifestyle.impl.AbstractLifestyleHandler;

public class SingletonLifestyleHandler
extends AbstractLifestyleHandler {
    private Object m_instance;

    public Object resolve(Object source) throws Exception {
        return this.access();
    }

    private Object access() throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            String debug = "access in appliance: " + this.getAppliance();
            this.getLogger().debug(debug);
        }
        Object object = this.newInstance();
        super.processAccessStage(object);
        if (this.getLogger().isDebugEnabled()) {
            String debug = "access complete: " + this.getAppliance();
            this.getLogger().debug(debug);
        }
        return object;
    }

    public void release(Object object, Object source) {
    }

    public void decommission() throws Exception {
        if (this.m_instance != null) {
            super.release(this.m_instance, (Object)this);
            this.m_instance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object newInstance() throws DeploymentException {
        if (this.m_instance == null) {
            SingletonLifestyleHandler singletonLifestyleHandler = this;
            synchronized (singletonLifestyleHandler) {
                if (this.m_instance == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        String debug = "new instance in appliance: " + this.getAppliance();
                        this.getLogger().debug(debug);
                    }
                    this.m_instance = super.newInstance();
                }
            }
        }
        return this.m_instance;
    }
}

