/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.lifestyle.impl;

import org.apache.avalon.assembly.lifestyle.impl.AbstractLifestyleHandler;
import org.apache.avalon.assembly.locator.LocatorException;

public class ThreadLocalLifestyleHandler
extends AbstractLifestyleHandler {
    private ThreadLocalComponent m_instance;

    public Object resolve(Object source) throws LocatorException {
        return this.access();
    }

    public Object access() throws LocatorException {
        if (this.getLogger().isDebugEnabled()) {
            String message = "access using thread local policy on appliance: " + this.getAppliance();
            this.getLogger().debug(message);
        }
        if (this.m_instance == null) {
            this.m_instance = new ThreadLocalComponent(this);
        }
        try {
            Object object = this.m_instance.get();
            super.processAccessStage(object);
            return object;
        }
        catch (Throwable e) {
            String error = "Access stage error.";
            throw new LocatorException((Object)"Access stage error.", e);
        }
    }

    public void release(Object object, Object partition) {
        if (object == null) {
            return;
        }
        if (object.equals(this.m_instance.get())) {
            super.processReleaseStage(object);
        }
    }

    public void decommission() throws Exception {
        if (this.m_instance != null) {
            super.release(this.m_instance.get(), (Object)this);
            this.m_instance = null;
        }
    }

    private static final class ThreadLocalComponent
    extends ThreadLocal {
        private final ThreadLocalLifestyleHandler m_handler;

        protected ThreadLocalComponent(ThreadLocalLifestyleHandler handler) {
            this.m_handler = handler;
        }

        protected Object initialValue() {
            try {
                return this.m_handler.newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

