/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.locator.impl;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.assembly.locator.Locator;
import org.apache.avalon.assembly.locator.LocatorException;
import org.apache.avalon.assembly.locator.Reclaimable;
import org.apache.avalon.assembly.locator.Resolvable;
import org.apache.avalon.assembly.locator.impl.Dictionary;
import org.apache.avalon.framework.context.ContextException;

public class DefaultLocator
implements Locator {
    private static final Hidden m_hiddenMarker = new Hidden();
    private final Map m_data;
    private final Locator m_parent;
    private final Dictionary m_dictionary;
    private boolean m_readOnly;
    private final Map m_reclaimers = new Hashtable();

    public DefaultLocator() {
        this((Locator)null);
    }

    public DefaultLocator(Map data) {
        this(data, null);
    }

    public DefaultLocator(Locator parent) {
        this(null, parent);
    }

    public DefaultLocator(Map data, Locator parent) {
        this(data, parent, new Dictionary());
    }

    public DefaultLocator(Map data, Locator parent, Dictionary dictionary) throws NullPointerException {
        this.m_data = data == null ? new Hashtable() : data;
        if (dictionary == null) {
            throw new NullPointerException("dictionary");
        }
        this.m_dictionary = dictionary;
        this.m_parent = parent;
    }

    public boolean hasEntry(Object key) {
        try {
            Object object = this.getObject(this.m_dictionary.translate(key));
            return object != null;
        }
        catch (ContextException le) {
            return false;
        }
    }

    protected Object getObject(Object key) throws ContextException {
        Object data = this.m_data.get(key);
        if (null != data) {
            if (data instanceof Hidden) {
                String message = "Unable to locate key: " + key;
                throw new LocatorException(key, message);
            }
            return data;
        }
        if (null == this.m_parent) {
            String message = "Unable to resolve key: " + key;
            throw new LocatorException(key, message);
        }
        if (this.m_parent instanceof DefaultLocator) {
            return ((DefaultLocator)this.m_parent).getObject(key);
        }
        return this.m_parent.get(key);
    }

    public Object get(Object key) throws ContextException {
        Object data = this.getObject(this.m_dictionary.translate(key));
        if (data == null) {
            String error = "Unexpected state. Mapped source returned a null object reference.";
            throw new IllegalStateException("Unexpected state. Mapped source returned a null object reference.");
        }
        if (data instanceof Reclaimable) {
            Object object = null;
            try {
                object = ((Resolvable)data).resolve((Object)this);
            }
            catch (Throwable e) {
                String error = "Unable to resolve entry: " + key;
                throw new LocatorException(key, error, e);
            }
            if (object == null) {
                String error = "Reclaimable source returned a null reference for key: " + key;
                throw new IllegalStateException(error);
            }
            this.m_reclaimers.put(object, data);
            return object;
        }
        if (data instanceof Resolvable) {
            Object object = null;
            try {
                object = ((Resolvable)data).resolve((Object)this);
            }
            catch (Throwable e) {
                String error = "Unable to resolve entry: " + key;
                throw new LocatorException(key, error, e);
            }
            if (object == null) {
                String error = "Resolvable source returned a null reference for key: " + key;
                throw new IllegalStateException(error);
            }
            return object;
        }
        return data;
    }

    public void release() {
        Iterator iterator = this.m_reclaimers.entrySet().iterator();
        while (iterator.hasNext()) {
            this.release(iterator.next());
        }
    }

    public void release(Object object) {
        Reclaimable reclaimer = (Reclaimable)this.m_reclaimers.get(object);
        if (reclaimer != null) {
            this.m_reclaimers.remove(object);
            reclaimer.release(object, (Object)this);
        }
    }

    public void put(Object key, Object value) throws IllegalStateException {
        this.checkWriteable();
        if (null == value) {
            this.m_data.remove(key);
        } else {
            this.m_data.put(key, value);
        }
    }

    public void hide(Object key) throws IllegalStateException {
        this.checkWriteable();
        this.m_data.put(key, m_hiddenMarker);
    }

    protected final Map getData() {
        return this.m_data;
    }

    protected final Locator getParent() {
        return this.m_parent;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            String message = "Locator is write protected.";
            throw new IllegalStateException("Locator is write protected.");
        }
    }

    private static final class Hidden
    implements Serializable {
        private Hidden() {
        }
    }
}

