/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.logging.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.avalon.assembly.locator.Contextualizable;
import org.apache.avalon.assembly.locator.Locator;
import org.apache.avalon.assembly.logging.LoggerException;
import org.apache.avalon.assembly.logging.LoggingDescriptor;
import org.apache.avalon.assembly.logging.LoggingManager;
import org.apache.avalon.assembly.logging.TargetDescriptor;
import org.apache.avalon.assembly.logging.TargetProvider;
import org.apache.avalon.assembly.logging.impl.FileTargetProvider;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AvalonFormatter;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.meta.model.Category;
import org.apache.avalon.meta.model.LoggingDirective;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.StreamTarget;

public class DefaultLoggingManager
implements LoggingManager,
Initializable,
Contextualizable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$assembly$logging$impl$DefaultLoggingManager == null ? (class$org$apache$avalon$assembly$logging$impl$DefaultLoggingManager = DefaultLoggingManager.class$("org.apache.avalon.assembly.logging.impl.DefaultLoggingManager")) : class$org$apache$avalon$assembly$logging$impl$DefaultLoggingManager));
    public static final String DEFAULT_PRIORITY = "INFO";
    public static final String DEFAULT_TARGET = "default";
    private static final String DEFAULT_FORMAT = "[%7.7{priority}] (%{category}): %{message}\\n%{throwable}";
    private static final StreamTarget DEFAULT_STREAM = new StreamTarget((OutputStream)System.out, (Formatter)new AvalonFormatter("[%7.7{priority}] (%{category}): %{message}\\n%{throwable}"));
    private File m_baseDirectory;
    private LoggingDescriptor m_descriptor;
    private Hierarchy m_logHierarchy;
    private org.apache.avalon.framework.logger.Logger m_logger;
    private final HashMap m_targets = new HashMap();
    private String m_system = "system";
    static /* synthetic */ Class class$org$apache$avalon$assembly$logging$impl$DefaultLoggingManager;

    public void contextualize(Locator context) throws ContextException {
        this.m_baseDirectory = (File)context.get((Object)"urn:assembly:home");
        if (context.hasEntry((Object)"urn:avalon:assembly.logging.system-category")) {
            this.m_system = (String)context.get((Object)"urn:avalon:assembly.logging.system-category");
            if (this.m_system.startsWith("/") || this.m_system.startsWith(".")) {
                String error = "Invalid system category - cannot start with '.' or '/' character.";
                throw new IllegalArgumentException("Invalid system category - cannot start with '.' or '/' character.");
            }
        }
        try {
            this.m_descriptor = (LoggingDescriptor)context.get((Object)"urn:assembly:logging.descriptor");
        }
        catch (ContextException ce) {
            this.m_descriptor = new LoggingDescriptor("", null, null, new TargetDescriptor[0], new Category("logging", "DEBUG", null));
        }
    }

    public void initialize() throws Exception {
        if (this.m_baseDirectory == null) {
            throw new IllegalStateException("context");
        }
        this.m_logHierarchy = new Hierarchy();
        this.getHierarchy().setDefaultLogTarget((LogTarget)DEFAULT_STREAM);
        this.m_targets.put(DEFAULT_TARGET, DEFAULT_STREAM);
        String priority = this.m_descriptor.getPriority() != null ? this.m_descriptor.getPriority() : DEFAULT_PRIORITY;
        this.getHierarchy().setDefaultPriority(Priority.getPriorityForName((String)priority));
        Category bootstrap = this.m_descriptor.getBootstrapCategory();
        this.m_logger = new LogKitLogger(this.addCategory(bootstrap.getName(), bootstrap.getPriority(), bootstrap.getTarget(), false));
        this.m_logger.debug("setting default priority: " + priority);
        TargetDescriptor[] targets = this.m_descriptor.getTargetDescriptors();
        int i = 0;
        while (i < targets.length) {
            this.addTarget(targets[i]);
            ++i;
        }
        String name = this.m_descriptor.getTarget();
        if (name != null) {
            LogTarget target = (LogTarget)this.m_targets.get(name);
            if (target != null) {
                this.getHierarchy().setDefaultLogTarget(target);
            } else {
                throw new LoggerException("Supplied default logging target: '" + name + "' does not exist.");
            }
        }
    }

    public void addCategories(LoggingDirective descriptor) {
        this.addCategories("", descriptor);
    }

    public void addCategories(String path, LoggingDirective descriptor) {
        this.addCategory(path, descriptor.getPriority(), descriptor.getTarget());
        Category[] categories = descriptor.getCategories();
        int i = 0;
        while (i < categories.length) {
            Category category = categories[i];
            String priority = category.getPriority();
            String target = category.getTarget();
            if (path.equals("")) {
                this.addCategory(category.getName(), priority, target);
            } else {
                this.addCategory(path + "." + category.getName(), priority, target);
            }
            ++i;
        }
    }

    public void addSystemCategories(String path, LoggingDirective descriptor) {
        String category = this.convertToSystem(path);
        this.addCategories(category, descriptor);
    }

    public org.apache.avalon.framework.logger.Logger getSystemLoggerForCategory(String path) {
        String category = this.convertToSystem(path);
        return this.getLoggerForCategory(category);
    }

    private String convertToSystem(String path) {
        return this.m_system + "." + this.filter(path);
    }

    public org.apache.avalon.framework.logger.Logger getLoggerForCategory(String name, String target, String priority) throws Exception {
        return new LogKitLogger(this.addCategory(name, target, priority));
    }

    public org.apache.avalon.framework.logger.Logger getLoggerForCategory(Category category) throws Exception {
        return new LogKitLogger(this.addCategory(category.getName(), category.getPriority(), category.getTarget()));
    }

    public org.apache.avalon.framework.logger.Logger getLoggerForCategory(String category) {
        if (category == null) {
            return new LogKitLogger(this.getHierarchy().getLoggerFor(""));
        }
        String cat = this.filter(category);
        try {
            return new LogKitLogger(this.getHierarchy().getLoggerFor(cat));
        }
        catch (Throwable e) {
            throw new RuntimeException("Bad category: " + cat);
        }
    }

    public org.apache.avalon.framework.logger.Logger getDefaultLogger() {
        if (this.m_logger == null) {
            this.m_logger = this.getLoggerForCategory("");
        }
        return this.m_logger;
    }

    private Logger addCategory(String path, String priority, String target) {
        return this.addCategory(path, priority, target, true);
    }

    private Logger addCategory(String path, String priority, String target, boolean notify) {
        LogTarget logTarget;
        Logger logger;
        String name = this.filter(path);
        try {
            logger = this.getHierarchy().getLoggerFor(name);
        }
        catch (Throwable e) {
            throw new RuntimeException("Bad category: " + path + " or trans: " + name);
        }
        if (priority != null) {
            Priority priorityValue = Priority.getPriorityForName((String)priority);
            if (!priorityValue.getName().equals(priority)) {
                String message = REZ.getString("unknown-priority", (Object)priority, (Object)path);
                throw new IllegalArgumentException(message);
            }
            logger.setPriority(priorityValue);
        }
        if (target != null && !target.equals(DEFAULT_TARGET) && (logTarget = (LogTarget)this.m_targets.get(target)) != null) {
            logger.setLogTargets(new LogTarget[]{logTarget});
        }
        if (notify && this.getLogger().isInfoEnabled()) {
            String message = REZ.getString("category-create", (Object)name, (Object)target, (Object)priority);
            this.getLogger().debug(message);
        }
        return logger;
    }

    private String filter(String name) {
        String path = name.replace('/', '.');
        if (path.startsWith(".")) {
            path = path.substring(1);
            return this.filter(path);
        }
        if (path.endsWith(".")) {
            path = path.substring(0, path.length() - 1);
            return this.filter(path);
        }
        return path;
    }

    private void addTarget(TargetDescriptor target) throws Exception {
        String name = target.getName();
        TargetProvider provider = target.getProvider();
        if (provider instanceof FileTargetProvider) {
            FileTargetProvider fileProvider = (FileTargetProvider)provider;
            String filename = fileProvider.getLocation();
            AvalonFormatter formatter = new AvalonFormatter(DEFAULT_FORMAT);
            File file = new File(this.m_baseDirectory, filename);
            try {
                FileTarget logTarget = new FileTarget(file.getAbsoluteFile(), false, (Formatter)formatter);
                this.m_targets.put(name, logTarget);
            }
            catch (IOException ioe) {
                String message = REZ.getString("target.nocreate", (Object)name, (Object)file, (Object)ioe.getMessage());
                throw new LoggerException(message, (Throwable)ioe);
            }
        } else {
            String error = "Unrecognized logging provider: " + provider.getClass().getName();
            throw new IllegalArgumentException(error);
        }
    }

    private org.apache.avalon.framework.logger.Logger getLogger() {
        return this.m_logger;
    }

    private Hierarchy getHierarchy() {
        return this.m_logHierarchy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

