/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.component.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.DefaultComponentManager;
import org.apache.avalon.framework.component.test.RoleA;
import org.apache.avalon.framework.component.test.RoleB;

public final class DefaultComponentManagerTestCase
extends TestCase {
    private DefaultComponentManager m_componentManager;
    protected boolean m_exceptionThrown;

    public DefaultComponentManagerTestCase() {
        this("DefaultComponentManager Test Case");
    }

    public DefaultComponentManagerTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.m_componentManager = new DefaultComponentManager();
        this.m_exceptionThrown = false;
    }

    protected void tearDown() throws Exception {
        this.m_componentManager = null;
    }

    public void testlookup1() throws Exception {
        DefaultRoleB roleBinBase = new DefaultRoleB();
        DefaultRoleB roleBinParent = new DefaultRoleB();
        DefaultRoleA roleAinParent = new DefaultRoleA();
        this.m_componentManager.put(RoleA.ROLE, roleAinParent);
        this.m_componentManager.put(RoleB.ROLE, roleBinParent);
        DefaultComponentManager baseComponentManager = new DefaultComponentManager(this.m_componentManager);
        baseComponentManager.put(RoleB.ROLE, roleBinBase);
        Component lookupAinBase = baseComponentManager.lookup(RoleA.ROLE);
        Component lookupBinBase = baseComponentManager.lookup(RoleB.ROLE);
        Component lookupBinParent = this.m_componentManager.lookup(RoleB.ROLE);
        Assert.assertTrue((boolean)(lookupAinBase instanceof RoleA));
        Assert.assertEquals((Object)lookupBinBase, (Object)roleBinBase);
        Assert.assertEquals((Object)lookupBinParent, (Object)roleBinParent);
        Assert.assertEquals((Object)lookupAinBase, (Object)roleAinParent);
    }

    public void testlookup2() throws Exception {
        this.m_componentManager.put(RoleA.ROLE, new DefaultRoleA());
        Component o = null;
        try {
            o = this.m_componentManager.lookup(RoleB.ROLE);
        }
        catch (ComponentException ce) {
            this.m_exceptionThrown = true;
        }
        if (o == null) {
            Assert.assertTrue((String)"ComponentException was not thrown when component was not found by lookup.", (boolean)this.m_exceptionThrown);
        } else {
            Assert.assertTrue((String)"component was found by lookup ,when there was no component.", (boolean)false);
        }
    }

    public void testhasComponent() throws Exception {
        this.m_componentManager.put(RoleA.ROLE, new DefaultRoleA());
        Assert.assertTrue((boolean)this.m_componentManager.hasComponent(RoleA.ROLE));
        Assert.assertTrue((!this.m_componentManager.hasComponent(RoleB.ROLE) ? 1 : 0) != 0);
    }

    public void testmakeReadOnly() throws Exception {
        this.m_componentManager.put(RoleA.ROLE, new DefaultRoleA());
        Component a = this.m_componentManager.lookup(RoleA.ROLE);
        Assert.assertTrue((boolean)(a instanceof RoleA));
        this.m_componentManager.makeReadOnly();
        try {
            this.m_componentManager.put(RoleB.ROLE, new DefaultRoleB());
        }
        catch (IllegalStateException se) {
            this.m_exceptionThrown = true;
        }
        Assert.assertTrue((String)"IllegalStateException was not thrown in  put after makeReadOnly.", (boolean)this.m_exceptionThrown);
    }

    class DefaultRoleB
    implements Component,
    RoleB {
    }

    class DefaultRoleA
    implements Component,
    RoleA {
    }
}

