/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.xml.sax.SAXException;

public final class DefaultConfigurationBuilderTestCase
extends TestCase {
    private DefaultConfigurationBuilder m_builder;
    private DefaultConfigurationBuilder m_nsBuilder;
    private File m_file;
    private File m_nsFile;
    private File m_testDirectory = new File("test/framework/io/").getAbsoluteFile();
    private final String m_simpleFileName = "config_simple.xml";
    private final String m_nsFileName = "config_namespaces.xml";
    private final String m_path = "test/framework/io/";
    private final String simpleXML = "<?xml version=\"1.0\" ?><config boolAttr=\"true\" floatAttr=\"1.32\">   <elements-a>       <element name=\"a\"/>   </elements-a>   <elements-b>       <element name=\"b\"/>    </elements-b>   <elements-b type=\"type-b\"/>   <elements-c>   true   </elements-c></config>";
    private final String nsXML = "<?xml version=\"1.0\" ?><conf:config       boolAttr=\"true\" floatAttr=\"1.32\"       xmlns:conf=\"http://conf.com\" xmlns:a=\"http://a.com\" xmlns:b=\"http://b.com\" xmlns:c=\"http://c.com\" xmlns:d=\"http://d.com\" xmlns:e=\"http://e.com\">   <a:elements-a>       <c:element name=\"a\"/>   </a:elements-a>   <elements-b xmlns=\"http://defaultns.com\">       <element name=\"b\"/>    </elements-b>   <b:elements-b type=\"type-b\"/>   <elements-c>   true   </elements-c>   <d:element>d:element</d:element>   <e:element>e:element</e:element></conf:config>";
    private final String spaceTrimmingCheckXML = "<?xml version=\"1.0\" ?> <config>   <trimmed-item>\n    value     \n   </trimmed-item>\n   <preserved-item xml:space='preserve'>\n a space&#13; a CR, then a trailing space </preserved-item>\n   <first-level-item xml:space='preserve'>\n      <second-level-preserved> whitespace around </second-level-preserved>\n   </first-level-item>\n   <trimmed-again-item>\n    value     \n   </trimmed-again-item>\n</config>";
    private final String mixedContentXML = "<?xml version=\"1.0\" ?><a>a<a/></a>";

    private void simpleAssertions(Configuration conf) throws ConfigurationException {
        Assert.assertEquals((String)"config", (String)conf.getName());
        Assert.assertEquals((String)"getNamespace() should default to \"\"", (String)"", (String)conf.getNamespace());
        try {
            String value = conf.getValue();
            Assert.fail((String)"Should throw a ConfigurationException, as this elementcontains child elements, not a value");
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        Configuration[] children = conf.getChildren();
        Assert.assertEquals((int)4, (int)children.length);
        Assert.assertEquals((String)"elements-a", (String)children[0].getName());
        Assert.assertEquals((String)"elements-b", (String)children[1].getName());
        Assert.assertEquals((String)"b", (String)children[1].getChild("element", false).getAttribute("name"));
        Assert.assertEquals((String)"elements-b", (String)children[2].getName());
        Assert.assertEquals((String)"elements-c", (String)children[3].getName());
        String[] attrNames = conf.getAttributeNames();
        Assert.assertEquals((int)2, (int)attrNames.length);
        Assert.assertEquals((String)"default", (String)conf.getAttribute("nonexistent", "default"));
        Assert.assertEquals((boolean)true, (boolean)conf.getAttributeAsBoolean("boolAttr"));
        Assert.assertEquals((double)1.32f, (double)conf.getAttributeAsFloat("floatAttr"), (double)0.0);
        Assert.assertEquals((String)"When a non-existent child is requested, a blank node should be created", (String)"nonexistent", (String)conf.getChild("nonexistent").getName());
        Assert.assertEquals((String)"When a non-existent child is requested, a blank node should be created", (String)"baz", (String)conf.getChild("foo").getChild("bar").getChild("baz").getName());
        try {
            String value = conf.getChild("nonexistent").getValue();
            Assert.fail((String)"Auto-created child nodes should not have a value");
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"Turning auto-node-creation off failed", null, (Object)conf.getChild("nonexistent", false));
        Assert.assertEquals((String)"Standard getChild() lookup failed", (String)"elements-b", (String)conf.getChild("elements-b", false).getName());
        Assert.assertEquals((String)"Boolean value surrounded by whitespace failed", (boolean)true, (boolean)conf.getChild("elements-c").getValueAsBoolean(false));
        Assert.assertEquals((String)"A value-containing element should have no child nodes", (int)0, (int)conf.getChild("elements-c").getChildren().length);
    }

    private void simpleAssertionsNS(Configuration conf) throws ConfigurationException {
        Assert.assertEquals((String)"conf:config", (String)conf.getName());
        Assert.assertEquals((String)"getNamespace() should default to \"\"", (String)"", (String)conf.getNamespace());
        try {
            String value = conf.getValue();
            Assert.fail((String)"Should throw a ConfigurationException, as this elementcontains child elements, not a value");
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        Configuration[] children = conf.getChildren();
        Assert.assertEquals((int)6, (int)children.length);
        Assert.assertEquals((String)"a:elements-a", (String)children[0].getName());
        Assert.assertEquals((String)"elements-b", (String)children[1].getName());
        Assert.assertEquals((String)"b", (String)children[1].getChild("element", false).getAttribute("name"));
        Assert.assertEquals((String)"b:elements-b", (String)children[2].getName());
        Assert.assertEquals((String)"elements-c", (String)children[3].getName());
        String[] attrNames = conf.getAttributeNames();
        Assert.assertEquals((int)8, (int)attrNames.length);
        Assert.assertEquals((String)"true", (String)conf.getAttribute("boolAttr", null));
        Assert.assertEquals((boolean)true, (boolean)conf.getAttributeAsBoolean("boolAttr"));
        Assert.assertEquals((double)1.32f, (double)conf.getAttributeAsFloat("floatAttr"), (double)0.0);
        Assert.assertEquals((String)"http://conf.com", (String)conf.getAttribute("xmlns:conf"));
        Assert.assertEquals((String)"http://a.com", (String)conf.getAttribute("xmlns:a"));
        Assert.assertEquals((String)"http://b.com", (String)conf.getAttribute("xmlns:b"));
        Assert.assertEquals((String)"http://c.com", (String)conf.getAttribute("xmlns:c"));
        Assert.assertEquals((String)"When a non-existent child is requested, a blank node should be created", (String)"nonexistent", (String)conf.getChild("nonexistent").getName());
        Assert.assertEquals((String)"When a non-existent child is requested, a blank node should be created", (String)"baz", (String)conf.getChild("foo").getChild("bar").getChild("baz").getName());
        try {
            String value = conf.getChild("nonexistent").getValue();
            Assert.fail((String)"Auto-created child nodes should not have a value");
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"Turning auto-node-creation off failed", null, (Object)conf.getChild("nonexistent", false));
        Assert.assertEquals((String)"Standard getChild() lookup failed", (String)"b:elements-b", (String)conf.getChild("b:elements-b", false).getName());
        Assert.assertEquals((String)"Boolean value surrounded by whitespace failed", (boolean)true, (boolean)conf.getChild("elements-c").getValueAsBoolean(false));
        Assert.assertEquals((String)"A value-containing element should have no child nodes", (int)0, (int)conf.getChild("elements-c").getChildren().length);
        Assert.assertEquals((String)"d:element", (String)conf.getChild("d:element").getValue());
        Assert.assertEquals((String)"e:element", (String)conf.getChild("e:element").getValue());
    }

    private void nsAssertions(Configuration conf) throws ConfigurationException {
        Assert.assertEquals((String)"config", (String)conf.getName());
        Assert.assertEquals((String)"Namespace not set correctly", (String)"http://conf.com", (String)conf.getNamespace());
        try {
            String value = conf.getValue();
            Assert.fail((String)"Should throw a ConfigurationException, as this elementcontains child elements, not a value");
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        Configuration[] children = conf.getChildren();
        Assert.assertEquals((int)6, (int)children.length);
        Assert.assertEquals((String)"elements-a", (String)children[0].getName());
        Assert.assertEquals((String)"http://a.com", (String)children[0].getNamespace());
        Assert.assertEquals((String)"elements-b", (String)children[1].getName());
        Assert.assertEquals((String)"http://defaultns.com", (String)children[1].getNamespace());
        Assert.assertEquals((String)"b", (String)children[1].getChild("element", false).getAttribute("name"));
        Assert.assertEquals((String)"elements-b", (String)children[2].getName());
        Assert.assertEquals((String)"http://b.com", (String)children[2].getNamespace());
        Assert.assertEquals((String)"elements-c", (String)children[3].getName());
        Assert.assertEquals((String)"", (String)children[3].getNamespace());
        String[] attrNames = conf.getAttributeNames();
        Assert.assertEquals((int)2, (int)attrNames.length);
        Assert.assertEquals((String)"true", (String)conf.getAttribute("boolAttr", null));
        Assert.assertEquals((boolean)true, (boolean)conf.getAttributeAsBoolean("boolAttr"));
        Assert.assertEquals((double)1.32f, (double)conf.getAttributeAsFloat("floatAttr"), (double)0.0);
        Assert.assertEquals((String)"When a non-existent child is requested, a blank node should be created", (String)"nonexistent", (String)conf.getChild("nonexistent").getName());
        Assert.assertEquals((String)"When a non-existent child is requested, a blank node should be created", (String)"baz", (String)conf.getChild("foo").getChild("bar").getChild("baz").getName());
        try {
            String value = conf.getChild("nonexistent").getValue();
            Assert.fail((String)"Auto-created child nodes should not have a value");
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"Turning auto-node-creation off failed", null, (Object)conf.getChild("nonexistent", false));
        Assert.assertEquals((String)"Standard getChild() lookup failed", (String)"elements-b", (String)conf.getChild("elements-b", false).getName());
        Assert.assertEquals((String)"Boolean value surrounded by whitespace failed", (boolean)true, (boolean)conf.getChild("elements-c").getValueAsBoolean(false));
        Assert.assertEquals((String)"A value-containing element should have no child nodes", (int)0, (int)conf.getChild("elements-c").getChildren().length);
    }

    public DefaultConfigurationBuilderTestCase() {
        this("DefaultConfigurationBuilder Test Case");
    }

    public DefaultConfigurationBuilderTestCase(String name) {
        super(name);
        if (!this.m_testDirectory.exists()) {
            this.m_testDirectory.mkdirs();
        }
    }

    protected void setUp() throws Exception {
        this.m_file = new File(this.m_testDirectory, "config_simple.xml");
        this.m_nsFile = new File(this.m_testDirectory, "config_namespaces.xml");
        FileWriter writer = new FileWriter(this.m_file);
        writer.write("<?xml version=\"1.0\" ?><config boolAttr=\"true\" floatAttr=\"1.32\">   <elements-a>       <element name=\"a\"/>   </elements-a>   <elements-b>       <element name=\"b\"/>    </elements-b>   <elements-b type=\"type-b\"/>   <elements-c>   true   </elements-c></config>");
        writer.close();
        writer = new FileWriter(this.m_nsFile);
        writer.write("<?xml version=\"1.0\" ?><conf:config       boolAttr=\"true\" floatAttr=\"1.32\"       xmlns:conf=\"http://conf.com\" xmlns:a=\"http://a.com\" xmlns:b=\"http://b.com\" xmlns:c=\"http://c.com\" xmlns:d=\"http://d.com\" xmlns:e=\"http://e.com\">   <a:elements-a>       <c:element name=\"a\"/>   </a:elements-a>   <elements-b xmlns=\"http://defaultns.com\">       <element name=\"b\"/>    </elements-b>   <b:elements-b type=\"type-b\"/>   <elements-c>   true   </elements-c>   <d:element>d:element</d:element>   <e:element>e:element</e:element></conf:config>");
        writer.close();
    }

    protected void tearDown() throws Exception {
        this.m_builder = null;
        this.m_nsBuilder = null;
    }

    public void testBuildFromFileName() throws Exception {
        this.m_builder = new DefaultConfigurationBuilder();
        this.m_nsBuilder = new DefaultConfigurationBuilder(true);
        Configuration conf = this.m_builder.buildFromFile("test/framework/io/config_simple.xml");
        this.simpleAssertions(conf);
        conf = this.m_builder.buildFromFile("test/framework/io/config_namespaces.xml");
        this.simpleAssertionsNS(conf);
        conf = this.m_nsBuilder.buildFromFile("test/framework/io/config_namespaces.xml");
        this.nsAssertions(conf);
    }

    public void testBuildFromFile() throws Exception {
        this.m_builder = new DefaultConfigurationBuilder();
        this.m_nsBuilder = new DefaultConfigurationBuilder(true);
        Configuration conf = this.m_builder.buildFromFile(this.m_file);
        this.simpleAssertions(conf);
        conf = this.m_builder.buildFromFile(this.m_nsFile);
        this.simpleAssertionsNS(conf);
        conf = this.m_nsBuilder.buildFromFile(this.m_nsFile);
        this.nsAssertions(conf);
    }

    public void testBuild() throws Exception {
        this.m_builder = new DefaultConfigurationBuilder();
        this.m_nsBuilder = new DefaultConfigurationBuilder(true);
        Configuration conf = this.m_builder.build(this.m_file.toURL().toString());
        this.simpleAssertions(conf);
        conf = this.m_builder.buildFromFile(this.m_nsFile);
        this.simpleAssertionsNS(conf);
        conf = this.m_nsBuilder.buildFromFile(this.m_nsFile);
        this.nsAssertions(conf);
    }

    public void testSpaceTrimming() throws Exception {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        ByteArrayInputStream in = new ByteArrayInputStream("<?xml version=\"1.0\" ?> <config>   <trimmed-item>\n    value     \n   </trimmed-item>\n   <preserved-item xml:space='preserve'>\n a space&#13; a CR, then a trailing space </preserved-item>\n   <first-level-item xml:space='preserve'>\n      <second-level-preserved> whitespace around </second-level-preserved>\n   </first-level-item>\n   <trimmed-again-item>\n    value     \n   </trimmed-again-item>\n</config>".getBytes());
        Configuration conf = builder.build(in);
        Assert.assertEquals((String)"Value is trimmed by default", (String)"value", (String)conf.getChild("trimmed-item").getValue());
        Assert.assertEquals((String)"After trimming turned off value is preserved", (String)"\n a space\r a CR, then a trailing space ", (String)conf.getChild("preserved-item").getValue());
        Assert.assertEquals((String)"Trimming two levels deep works too", (String)" whitespace around ", (String)conf.getChild("first-level-item").getChild("second-level-preserved").getValue());
        Assert.assertEquals((String)"Trimming turned back on", (String)"value", (String)conf.getChild("trimmed-again-item").getValue());
    }

    public void testMixedContentDetection() throws Exception {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        ByteArrayInputStream in = new ByteArrayInputStream("<?xml version=\"1.0\" ?><a>a<a/></a>".getBytes());
        try {
            builder.build(in);
            Assert.fail((String)"Must fail on mixed content");
        }
        catch (SAXException e) {}
    }
}

