/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.data;

import java.io.Serializable;
import org.apache.avalon.meta.data.CategoryDirective;

public final class CategoriesDirective
extends CategoryDirective
implements Serializable {
    private CategoryDirective[] m_categories;

    public CategoriesDirective(String name) {
        this(name, null, null, new CategoryDirective[0]);
    }

    public CategoriesDirective(CategoryDirective[] categories) {
        this("", null, null, categories);
    }

    public CategoriesDirective(String name, String priority, String target, CategoryDirective[] categories) {
        super(name, priority, target);
        this.m_categories = categories == null ? new CategoryDirective[0] : categories;
    }

    public CategoryDirective[] getCategories() {
        return this.m_categories;
    }

    public CategoryDirective getCategoryDirective(String name) {
        int i = 0;
        while (i < this.m_categories.length) {
            CategoryDirective category = this.m_categories[i];
            if (category.getName().equalsIgnoreCase(name)) {
                return category;
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object other) {
        boolean isEqual = other instanceof CategoriesDirective;
        if (isEqual) {
            isEqual = super.equals(other);
        }
        if (isEqual) {
            CategoriesDirective oLog = (CategoriesDirective)other;
            if (isEqual) {
                boolean bl = isEqual = this.m_categories.length == oLog.m_categories.length;
            }
            if (isEqual) {
                int i = 0;
                while (i < this.m_categories.length && isEqual) {
                    isEqual = this.m_categories[i].equals(oLog.m_categories[i]);
                    ++i;
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = super.hashCode();
        int i = 0;
        while (i < this.m_categories.length) {
            hash >>>= 1;
            hash ^= this.m_categories[i].hashCode();
            ++i;
        }
        return hash;
    }
}

