/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.data;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.avalon.meta.data.FilesetDirective;
import org.apache.avalon.meta.data.IncludeDirective;
import org.apache.avalon.meta.data.RepositoryDirective;

public final class ClasspathDirective
implements Serializable {
    private static final FilesetDirective[] EMPTY_FILESETS = new FilesetDirective[0];
    private static final RepositoryDirective[] EMPTY_REPOSITORIES = new RepositoryDirective[0];
    private FilesetDirective[] m_filesets;
    private RepositoryDirective[] m_repositories;

    public ClasspathDirective() {
        this(null, null);
    }

    public ClasspathDirective(FilesetDirective[] filesets, RepositoryDirective[] repositories) {
        this.m_filesets = filesets == null ? EMPTY_FILESETS : filesets;
        this.m_repositories = repositories == null ? EMPTY_REPOSITORIES : repositories;
    }

    public RepositoryDirective[] getRepositoryDirectives() {
        return this.m_repositories;
    }

    public FilesetDirective[] getFilesets() {
        return this.m_filesets;
    }

    public File[] expandFileSetDirectives(File base) throws IOException {
        ArrayList<File> list = new ArrayList<File>();
        FilesetDirective[] filesets = this.getFilesets();
        int i = 0;
        while (i < filesets.length) {
            FilesetDirective fileset = filesets[i];
            File anchor = this.getDirectory(base, fileset.getBaseDirectory());
            IncludeDirective[] includes = fileset.getIncludes();
            if (includes.length > 0) {
                int j = 0;
                while (j < includes.length) {
                    File file = new File(anchor, includes[i].getPath());
                    list.add(file);
                    ++j;
                }
            } else {
                list.add(anchor);
            }
            ++i;
        }
        return list.toArray(new File[0]);
    }

    private File getDirectory(File base, String path) throws IOException {
        File file = new File(path);
        if (file.isAbsolute()) {
            return this.verifyDirectory(file);
        }
        return this.verifyDirectory(new File(base, path));
    }

    private File verifyDirectory(File dir) throws IOException {
        if (dir.isDirectory()) {
            return dir.getCanonicalFile();
        }
        String error = "Path does not correspond to a directory: " + dir;
        throw new IOException(error);
    }
}

