/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.data;

import java.util.ArrayList;
import org.apache.avalon.meta.data.ClassLoaderDirective;
import org.apache.avalon.meta.data.ClasspathDirective;
import org.apache.avalon.meta.data.LibraryDirective;
import org.apache.avalon.meta.data.Mode;
import org.apache.avalon.meta.data.Profile;
import org.apache.avalon.meta.data.ServiceDirective;
import org.apache.avalon.meta.info.DependencyDescriptor;

public class ContainmentProfile
extends Profile {
    public static final String DELIMITER = "/";
    private static final ServiceDirective[] EMPTY_SERVICE_DIRECTIVES = new ServiceDirective[0];
    private static final DependencyDescriptor[] EMPTY_DEPENDENCIES = new DependencyDescriptor[0];
    private static final ContainmentProfile EMPTY_IMPLEMENTATION = new ContainmentProfile();
    private static final ClassLoaderDirective EMPTY_CLASSLOADER_DIRECTIVE = new ClassLoaderDirective(new LibraryDirective(), new ClasspathDirective());
    private ClassLoaderDirective m_classloader;
    private final ServiceDirective[] m_export;
    private final DependencyDescriptor[] m_imports;
    private final Profile[] m_profiles;

    public ContainmentProfile() {
        this("container", null, null, null, new Profile[0]);
    }

    public ContainmentProfile(String name, ClassLoaderDirective classloader, DependencyDescriptor[] imports, ServiceDirective[] exports, Profile[] profiles) {
        super(name, true, Mode.EXPLICIT);
        this.m_classloader = classloader;
        this.m_profiles = profiles;
        this.m_export = exports == null ? EMPTY_SERVICE_DIRECTIVES : exports;
        this.m_imports = imports == null ? EMPTY_DEPENDENCIES : imports;
    }

    public ClassLoaderDirective getClassLoaderDirective() {
        return this.getClassLoaderDirective(true);
    }

    public ClassLoaderDirective getClassLoaderDirective(boolean create) {
        if (this.m_classloader == null && create) {
            return EMPTY_CLASSLOADER_DIRECTIVE;
        }
        return this.m_classloader;
    }

    public ServiceDirective[] getServiceDirectives() {
        return this.m_export;
    }

    public DependencyDescriptor[] getDependencies() {
        return this.m_imports;
    }

    public ServiceDirective getServiceDirective(Class clazz) {
        String classname = clazz.getName();
        ServiceDirective[] services = this.getServiceDirectives();
        int i = 0;
        while (i < services.length) {
            ServiceDirective virtual = services[i];
            if (virtual.getReference().getClassname().equals(classname)) {
                return virtual;
            }
            ++i;
        }
        return null;
    }

    public Profile[] getProfiles() {
        return this.m_profiles;
    }

    public Profile[] getProfiles(Mode mode) {
        Profile[] profiles = this.getProfiles();
        return this.selectProfileByMode(profiles, mode);
    }

    private Profile[] selectProfileByMode(Profile[] profiles, Mode mode) {
        ArrayList<Profile> list = new ArrayList<Profile>();
        int i = 0;
        while (i < profiles.length) {
            Profile profile = profiles[i];
            if (profile.getMode().equals(mode)) {
                list.add(profile);
            }
            ++i;
        }
        return list.toArray(new Profile[0]);
    }
}

