/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.data;

import java.io.Serializable;

public class ResourceDirective
implements Serializable {
    private final String m_group;
    private final String m_name;
    private final String m_version;

    public ResourceDirective(String id, String version) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        int n = id.indexOf(":");
        if (id.indexOf(":") > 0) {
            this.m_group = id.substring(0, n);
            this.m_name = id.substring(n + 1, id.length());
        } else {
            this.m_group = id;
            this.m_name = id;
        }
        this.m_version = version;
    }

    public ResourceDirective(String group, String name, String version) {
        if (group == null) {
            throw new NullPointerException("group");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.m_group = group;
        this.m_name = name;
        this.m_version = version;
    }

    public String getId() {
        return this.m_group + ":" + this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getVersion() {
        return this.m_version;
    }
}

