/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.model;

import java.io.Serializable;

public class Category
implements Serializable {
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARN = "WARN";
    public static final String ERROR = "ERROR";
    public static final String DEFAULT_LOGGING_TARGET = "default";
    public static final String DEFAULT_LOGGING_PRIORITY = "INFO";
    private final String m_name;
    private final String m_priority;
    private final String m_target;

    public Category(String name) {
        this(name, "INFO", DEFAULT_LOGGING_TARGET);
    }

    public Category(String name, String priority) {
        this(name, priority, DEFAULT_LOGGING_TARGET);
    }

    public Category(String name, String priority, String target) {
        this.m_name = name;
        this.m_target = target != null ? target : DEFAULT_LOGGING_TARGET;
        this.m_priority = priority != null ? priority.trim().toUpperCase() : "INFO";
    }

    public String getName() {
        return this.m_name;
    }

    public String getPriority() {
        return this.m_priority;
    }

    public String getTarget() {
        return this.m_target;
    }

    public boolean equals(Object other) {
        boolean isEqual = other instanceof Category;
        if (isEqual) {
            Category test = (Category)other;
            isEqual = this.m_name.equals(test.m_name);
            if (isEqual) {
                isEqual = this.m_priority.equals(test.m_priority);
            }
            if (isEqual) {
                isEqual = this.m_target.equals(test.m_target);
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = this.m_name.hashCode();
        hash >>>= 13;
        hash ^= this.m_priority.hashCode();
        hash >>>= 5;
        return hash ^= this.m_target.hashCode();
    }
}

