/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.model;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.avalon.meta.model.ModelException;

public class Parameter {
    private final String m_classname;
    private String m_argument;
    private final Parameter[] m_parameters;
    private Object m_value;
    static /* synthetic */ Class class$java$lang$String;

    public Parameter(String value) {
        if (null == value) {
            throw new NullPointerException("value");
        }
        this.m_parameters = new Parameter[0];
        this.m_classname = "java.lang.String";
        this.m_argument = value;
    }

    public Parameter(String classname, String value) {
        if (null == classname) {
            throw new NullPointerException("classname");
        }
        if (null == value) {
            throw new NullPointerException("value");
        }
        this.m_parameters = new Parameter[0];
        this.m_classname = classname;
        this.m_argument = value;
    }

    public Parameter(String classname, Parameter[] parameters) {
        if (null == classname) {
            throw new NullPointerException("classname");
        }
        if (null == parameters) {
            throw new NullPointerException("parameters");
        }
        this.m_classname = classname;
        this.m_parameters = parameters;
    }

    public String getClassname() {
        return this.m_classname;
    }

    Class getParameterClass(ClassLoader loader) throws ModelException {
        String classname = this.getClassname();
        try {
            return loader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            if (classname.equals("int")) {
                return Integer.TYPE;
            }
            if (classname.equals("short")) {
                return Short.TYPE;
            }
            if (classname.equals("long")) {
                return Long.TYPE;
            }
            if (classname.equals("byte")) {
                return Byte.TYPE;
            }
            if (classname.equals("double")) {
                return Double.TYPE;
            }
            if (classname.equals("byte")) {
                return Byte.TYPE;
            }
            if (classname.equals("float")) {
                return Float.TYPE;
            }
            if (classname.equals("char")) {
                return Character.TYPE;
            }
            if (classname.equals("char")) {
                return Character.TYPE;
            }
            if (classname.equals("boolean")) {
                return Boolean.TYPE;
            }
            throw new ModelException("Could not locate the parameter implemetation for class: '" + this.m_classname + "'.", e);
        }
    }

    public Object getValue(ClassLoader loader, Map map) throws ModelException {
        if (this.m_value != null) {
            return this.m_value;
        }
        if (this.m_argument != null) {
            if (this.m_argument.startsWith("${")) {
                if (this.m_argument.endsWith("}")) {
                    String key = this.m_argument.substring(2, this.m_argument.length() - 1);
                    this.m_value = map.get(key);
                    if (this.m_value != null) {
                        return this.m_value;
                    }
                    String error = "Missing context value: '" + key + "'.";
                    throw new IllegalArgumentException(error);
                }
                String error = "Illegal formal for context refernence: '" + this.m_argument + "'.";
                throw new IllegalArgumentException(error);
            }
            Class clazz = this.getParameterClass(loader);
            try {
                Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Parameter.class$("java.lang.String")) : class$java$lang$String};
                Constructor constructor = clazz.getConstructor(params);
                Object[] values = new Object[]{this.m_argument};
                this.m_value = constructor.newInstance(values);
                return this.m_value;
            }
            catch (NoSuchMethodException e) {
                String error = "Class: '" + clazz.getName() + "' does not implement a single string argument constructor.";
                throw new ModelException(error);
            }
            catch (InstantiationException e) {
                String error = "Unable to instantiate instance of class: " + clazz.getName() + " with the single argument: '" + this.m_argument + "'";
                throw new ModelException(error, e);
            }
            catch (IllegalAccessException e) {
                String error = "Cannot access single string parameter constructor for the class: '" + this.m_classname + "'.";
                throw new ModelException(error, e);
            }
            catch (Throwable e) {
                String error = "Unexpected exception while creating a single string parameter value for the class: '" + this.m_classname + "'.";
                throw new ModelException(error, e);
            }
        }
        if (this.m_parameters.length == 0) {
            try {
                this.m_value = this.getParameterClass(loader).newInstance();
                return this.m_value;
            }
            catch (InstantiationException e) {
                String error = "Unable to instantiate instance of class: " + this.m_classname;
                throw new ModelException(error, e);
            }
            catch (IllegalAccessException e) {
                String error = "Cannot access null constructor for the class: '" + this.m_classname + "'.";
                throw new ModelException(error, e);
            }
        }
        Class[] params = new Class[this.m_parameters.length];
        int i = 0;
        while (i < this.m_parameters.length) {
            try {
                params[i] = this.m_parameters[i].getParameterClass(loader);
            }
            catch (Throwable e) {
                String error = "Unable to resolve sub-parameter class: " + this.m_parameters[i].getClassname() + " inside the parameter " + this.m_classname;
                throw new ModelException(error, e);
            }
            ++i;
        }
        Object[] values = new Object[this.m_parameters.length];
        int i2 = 0;
        while (i2 < this.m_parameters.length) {
            try {
                values[i2] = this.m_parameters[i2].getValue(loader, map);
            }
            catch (Throwable e) {
                String error = "Unable to instantiate sub-parameter for value: " + this.m_parameters[i2].getClassname() + " inside the parameter " + this.m_classname;
                throw new ModelException(error, e);
            }
            ++i2;
        }
        Constructor constructor = null;
        try {
            constructor = this.getParameterClass(loader).getConstructor(params);
        }
        catch (NoSuchMethodException e) {
            String error = "Supplied parameters for " + this.m_classname + " does not match an available constructor. Cause: " + e.toString() + "\n" + this;
            throw new ModelException(error);
        }
        try {
            this.m_value = constructor.newInstance(values);
            return this.m_value;
        }
        catch (InstantiationException e) {
            String error = "Unable to instantiate an instance of a multi-parameter constructor for class: '" + this.m_classname + "'.";
            throw new ModelException(error, e);
        }
        catch (IllegalAccessException e) {
            String error = "Cannot access multi-parameter constructor for the class: '" + this.m_classname + "'.";
            throw new ModelException(error, e);
        }
        catch (Throwable e) {
            String error = "Unexpected error while attmpting to instantiate a multi-parameter constructor for the class: '" + this.m_classname + "'.";
            throw new ModelException(error, e);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.asString(buffer, "  ");
        return buffer.toString();
    }

    protected void asString(StringBuffer buffer, String lead) {
        buffer.append(lead + "[\n" + lead + "   type: " + this.getClass().getName() + "\n" + lead + "  class: " + this.m_classname + "\n" + lead + "    arg: " + this.m_argument + "\n" + lead + "  value: " + this.m_value + "\n" + lead + " params: " + this.m_parameters.length);
        if (this.m_parameters.length > 0) {
            buffer.append("\n");
            String str = lead + "  ";
            this.getParamsAsString(buffer, str);
        }
        buffer.append("\n" + lead + "]\n");
    }

    private void getParamsAsString(StringBuffer buffer, String lead) {
        int i = 0;
        while (i < this.m_parameters.length) {
            this.m_parameters[i].asString(buffer, lead + "  ");
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

