/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.model;

import java.io.Serializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.ContextDirective;
import org.apache.avalon.meta.model.LoggingDirective;
import org.apache.avalon.meta.model.Mode;

public class Profile
implements Serializable,
Contextualizable {
    public static final String NAME_KEY = "urn:meta:profile.name";
    public static final String TYPE_KEY = "urn:meta:profile.type";
    public static final String CATEGORIES_KEY = "urn:meta:profile.categories";
    public static final String MODE_KEY = "urn:meta:profile.mode";
    public static final String PARAMETERS_KEY = "urn:meta:profile.parameters";
    public static final String CONFIGURATION_KEY = "urn:meta:profile.configuration";
    public static final String CONTEXT_KEY = "urn:meta:profile.context";
    public static final String ACTIVATION_KEY = "urn:meta:profile.activation";
    private String m_name;
    private LoggingDirective m_categories;
    private Type m_type;
    private Parameters m_parameters;
    private Configuration m_configuration;
    private ContextDirective m_context;
    private Mode m_mode;
    private transient boolean m_activation = false;

    public void contextualize(Context context) throws ContextException {
        this.m_type = (Type)context.get((Object)TYPE_KEY);
        this.m_categories = (LoggingDirective)context.get((Object)CATEGORIES_KEY);
        this.m_mode = (Mode)context.get((Object)MODE_KEY);
        this.setName(context);
        this.setContext(context);
        this.setParameters(context);
        this.setConfiguration(context);
        this.setActivationPolicy(context);
    }

    public Type getType() {
        return this.m_type;
    }

    public ServiceDescriptor[] getServices() {
        return this.m_type.getServices();
    }

    public ServiceDescriptor getService(ReferenceDescriptor reference) {
        return this.m_type.getService(reference);
    }

    public DependencyDescriptor[] getDependencies() {
        return this.m_type.getDependencies();
    }

    public String getName() {
        return this.m_name;
    }

    public LoggingDirective getCategories() {
        return this.m_categories;
    }

    public ContextDirective getContext() {
        return this.m_context;
    }

    public Parameters getParameters() {
        return this.m_parameters;
    }

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public Mode getMode() {
        return this.m_mode;
    }

    public String toString() {
        return "[" + this.getName() + "]";
    }

    private void setActivationPolicy(Context context) {
        try {
            Boolean value = (Boolean)context.get((Object)ACTIVATION_KEY);
            if (value != null && value.booleanValue()) {
                this.m_activation = true;
            }
        }
        catch (ContextException e) {}
    }

    public void setActivationPolicy(boolean value) {
        this.m_activation = value;
    }

    public boolean getActivationPolicy() {
        return this.m_activation;
    }

    private void setParameters(Context context) {
        try {
            this.m_parameters = (Parameters)context.get((Object)PARAMETERS_KEY);
        }
        catch (ContextException e) {}
    }

    private void setContext(Context context) {
        try {
            this.m_context = (ContextDirective)context.get((Object)CONTEXT_KEY);
        }
        catch (ContextException e) {}
    }

    private void setName(Context context) {
        try {
            this.m_name = (String)context.get((Object)NAME_KEY);
        }
        catch (ContextException e) {
            this.m_name = this.m_type.getInfo().getName();
        }
    }

    private void setConfiguration(Context context) throws ContextException {
        this.m_configuration = (Configuration)context.get((Object)CONFIGURATION_KEY);
    }
}

