/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.data.builder;

import java.io.InputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.meta.ConfigurationBuilder;
import org.apache.avalon.meta.data.DeploymentProfile;
import org.apache.avalon.meta.data.ProfilePackage;
import org.apache.avalon.meta.data.builder.ProfilePackageCreator;
import org.apache.avalon.meta.data.builder.SerializedProfilePackageCreator;
import org.apache.avalon.meta.data.builder.XMLProfilePackageCreator;
import org.xml.sax.InputSource;

public final class ProfilePackageBuilder
implements ProfilePackageCreator {
    private XMLProfilePackageCreator m_xml = new XMLProfilePackageCreator();
    private final SerializedProfilePackageCreator m_serial = new SerializedProfilePackageCreator();

    public ProfilePackage createProfilePackage(Class clazz) throws Exception {
        ProfilePackage profiles = this.m_serial.createProfilePackage(clazz);
        if (profiles != null) {
            return profiles;
        }
        String classname = clazz.getName();
        String xprofile = classname.replace('.', '/') + ".xprofile";
        InputStream stream = clazz.getClassLoader().getResourceAsStream(xprofile);
        if (stream == null) {
            DeploymentProfile profile = new DeploymentProfile("default", classname);
            return new ProfilePackage(new DeploymentProfile[]{profile});
        }
        return this.buildFromXMLDescriptor(classname, stream);
    }

    private ProfilePackage buildFromSerDescriptor(InputStream inputStream) throws Exception {
        return this.m_serial.createProfilePackage(inputStream);
    }

    private ProfilePackage buildFromXMLDescriptor(String classname, InputStream inputStream) throws Exception {
        InputSource inputSource = new InputSource(inputStream);
        Configuration config = ConfigurationBuilder.build(inputSource);
        return this.m_xml.createProfilePackage(classname, config);
    }
}

