/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.data.builder;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.meta.data.ClassLoaderDirective;
import org.apache.avalon.meta.data.ClasspathDirective;
import org.apache.avalon.meta.data.ContainmentProfile;
import org.apache.avalon.meta.data.FilesetDirective;
import org.apache.avalon.meta.data.IncludeDirective;
import org.apache.avalon.meta.data.LibraryDirective;
import org.apache.avalon.meta.data.MetaDataException;
import org.apache.avalon.meta.data.Profile;
import org.apache.avalon.meta.data.RepositoryDirective;
import org.apache.avalon.meta.data.ResourceDirective;
import org.apache.avalon.meta.data.ServiceDirective;
import org.apache.avalon.meta.data.builder.XMLDeploymentProfileCreator;
import org.apache.avalon.meta.data.builder.XMLProfileCreator;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.builder.XMLTypeCreator;
import org.apache.excalibur.configuration.ConfigurationUtil;

public class XMLContainmentProfileCreator
extends XMLProfileCreator {
    private static final XMLTypeCreator TYPE_CREATOR = new XMLTypeCreator();
    private static final XMLDeploymentProfileCreator DEPLOYMENT_CREATOR = new XMLDeploymentProfileCreator();

    public ContainmentProfile createContainmentProfile(Configuration config) throws Exception {
        String name = this.getName(config);
        DependencyDescriptor[] imports = this.getDependencies(config.getChild("dependencies", false));
        ServiceDirective[] exports = this.getServicesDirectives(config.getChild("services", false));
        Configuration implementation = config;
        if (config.getChild("implementation", false) != null) {
            implementation = config.getChild("implementation", false);
        }
        ClassLoaderDirective classloader = this.getClassLoaderDirective(implementation.getChild("classloader", false));
        Profile[] profiles = this.getProfiles(implementation);
        return new ContainmentProfile(name, classloader, imports, exports, profiles);
    }

    private ClassLoaderDirective getClassLoaderDirective(Configuration config) throws ConfigurationException {
        if (config == null) {
            return null;
        }
        LibraryDirective library = this.createLibraryDirective(config.getChild("library", false));
        ClasspathDirective classpath = this.createClasspathDirective(config.getChild("classpath", false));
        return new ClassLoaderDirective(library, classpath);
    }

    private ClasspathDirective createClasspathDirective(Configuration config) throws ConfigurationException {
        if (config == null) {
            return null;
        }
        FilesetDirective[] filesets = this.getFilesetDirectives(config);
        RepositoryDirective[] repositories = this.getRepositoryDirectives(config);
        return new ClasspathDirective(filesets, repositories);
    }

    private LibraryDirective createLibraryDirective(Configuration config) throws ConfigurationException {
        if (config == null) {
            return null;
        }
        Configuration[] includes = config.getChildren("include");
        String[] inc = new String[includes.length];
        int i = 0;
        while (i < includes.length) {
            inc[i] = this.getIncludeValue(includes[i]);
            ++i;
        }
        Configuration[] groups = config.getChildren("group");
        String[] grp = new String[groups.length];
        int i2 = 0;
        while (i2 < groups.length) {
            grp[i2] = groups[i2].getValue();
            ++i2;
        }
        return new LibraryDirective(inc, grp);
    }

    private RepositoryDirective[] getRepositoryDirectives(Configuration config) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("config");
        }
        Configuration[] children = config.getChildren("repository");
        RepositoryDirective[] repositories = new RepositoryDirective[children.length];
        int i = 0;
        while (i < children.length) {
            ResourceDirective[] resources = this.getResourceDirectives(children[i]);
            repositories[i] = new RepositoryDirective(resources);
            ++i;
        }
        return repositories;
    }

    private ResourceDirective[] getResourceDirectives(Configuration config) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("config");
        }
        ArrayList<ResourceDirective> res = new ArrayList<ResourceDirective>();
        Configuration[] resources = config.getChildren("resource");
        int i = 0;
        while (i < resources.length) {
            Configuration resource = resources[i];
            String id = resource.getAttribute("id");
            String version = resource.getAttribute("version", null);
            res.add(new ResourceDirective(id, version));
            ++i;
        }
        return res.toArray(new ResourceDirective[0]);
    }

    private FilesetDirective[] getFilesetDirectives(Configuration config) throws ConfigurationException {
        ArrayList<FilesetDirective> list = new ArrayList<FilesetDirective>();
        Configuration[] children = config.getChildren("fileset");
        int i = 0;
        while (i < children.length) {
            Configuration child = children[i];
            list.add(this.createFilesetDirective(child));
            ++i;
        }
        return list.toArray(new FilesetDirective[0]);
    }

    public FilesetDirective createFilesetDirective(Configuration config) throws ConfigurationException {
        String base = config.getAttribute("dir", ".");
        IncludeDirective[] includes = this.createIncludeDirectives(config);
        return new FilesetDirective(base, includes);
    }

    protected IncludeDirective[] createIncludeDirectives(Configuration config) throws ConfigurationException {
        if (config == null) {
            return new IncludeDirective[0];
        }
        ArrayList<IncludeDirective> list = new ArrayList<IncludeDirective>();
        Configuration[] children = config.getChildren("include");
        int i = 0;
        while (i < children.length) {
            Configuration child = children[i];
            list.add(this.createIncludeDirective(child));
            ++i;
        }
        return list.toArray(new IncludeDirective[0]);
    }

    protected IncludeDirective createIncludeDirective(Configuration config) throws ConfigurationException {
        return new IncludeDirective(this.getIncludeValue(config));
    }

    private String getIncludeValue(Configuration config) throws ConfigurationException {
        if (config.getAttribute("path", null) != null) {
            return config.getAttribute("path");
        }
        if (config.getAttribute("name", null) != null) {
            return config.getAttribute("name");
        }
        return config.getValue();
    }

    protected Profile[] getProfiles(Configuration config) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        Configuration[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            Configuration child = children[i];
            if (!child.getName().equals("classloader")) {
                if (child.getName().equals("container")) {
                    list.add(this.createContainmentProfile(child));
                } else if (child.getName().equals("component")) {
                    list.add(DEPLOYMENT_CREATOR.createDeploymentProfile(child));
                } else if (child.getName().equals("include")) {
                    System.out.println("INCLUDES NOT IMPLEMENTED YET");
                }
            }
            ++i;
        }
        return list.toArray(new Profile[0]);
    }

    protected DependencyDescriptor[] getDependencies(Configuration config) throws MetaDataException {
        if (config == null) {
            return new DependencyDescriptor[0];
        }
        try {
            return TYPE_CREATOR.buildDependencies(config);
        }
        catch (Throwable ce) {
            String error = "Invalid dependencies declaration in block specification:\n" + ConfigurationUtil.list((Configuration)config);
            throw new MetaDataException(error, ce);
        }
    }

    public ServiceDirective[] getServicesDirectives(Configuration config) throws MetaDataException {
        if (config == null) {
            return new ServiceDirective[0];
        }
        Configuration[] children = config.getChildren("service");
        ArrayList<ServiceDirective> list = new ArrayList<ServiceDirective>();
        int i = 0;
        while (i < children.length) {
            list.add(this.getServiceDirective(children[i]));
            ++i;
        }
        return list.toArray(new ServiceDirective[0]);
    }

    private ServiceDirective getServiceDirective(Configuration config) throws MetaDataException {
        try {
            ServiceDescriptor service = TYPE_CREATOR.buildService(config);
            Configuration source = config.getChild("source", false);
            if (source == null) {
                String error = "Service configuration must contain a source directive.";
                throw new MetaDataException("Service configuration must contain a source directive.");
            }
            String path = source.getValue();
            return new ServiceDirective(service, path);
        }
        catch (Throwable ce) {
            String error = "Invalid service declaration in block specification:\n" + ConfigurationUtil.list((Configuration)config);
            throw new MetaDataException(error, ce);
        }
    }
}

