/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.data.builder;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.meta.data.CategoriesDirective;
import org.apache.avalon.meta.data.CategoryDirective;
import org.apache.avalon.meta.data.ConstructorDirective;
import org.apache.avalon.meta.data.ContextDirective;
import org.apache.avalon.meta.data.DeploymentProfile;
import org.apache.avalon.meta.data.EntryDirective;
import org.apache.avalon.meta.data.ImportDirective;
import org.apache.avalon.meta.data.Mode;
import org.apache.avalon.meta.data.Parameter;
import org.apache.avalon.meta.data.builder.XMLProfileCreator;

public class XMLDeploymentProfileCreator
extends XMLProfileCreator {
    public DeploymentProfile createDeploymentProfile(Configuration config) throws Exception {
        String classname = config.getAttribute("class", null);
        return this.createDeploymentProfile(classname, config);
    }

    public DeploymentProfile createDeploymentProfile(String classname, Configuration config) throws Exception {
        String name = this.getName(config);
        return this.createDeploymentProfile(classname, config, name);
    }

    public DeploymentProfile createDeploymentProfile(String classname, Configuration config, String name) throws Exception {
        boolean activation = this.getActivationPolicy(config, true);
        CategoriesDirective categories = this.getCategoriesDirective(config.getChild("categories", false), name);
        ContextDirective context = this.getContextDirective(config.getChild("context", false));
        Parameters params = this.getParameters(config.getChild("parameters", false));
        Configuration configuration = config.getChild("configuration", false);
        return new DeploymentProfile(name, activation, classname, categories, context, params, configuration, Mode.EXPLICIT);
    }

    protected CategoriesDirective getCategoriesDirective(Configuration config, String name) throws ConfigurationException {
        if (config != null) {
            String priority = config.getAttribute("priority", null);
            String target = config.getAttribute("target", null);
            CategoryDirective[] categories = this.getCategoryDirectives(config.getChildren("category"));
            return new CategoriesDirective(name, priority, target, categories);
        }
        return null;
    }

    private CategoryDirective[] getCategoryDirectives(Configuration[] children) throws ConfigurationException {
        ArrayList<CategoryDirective> list = new ArrayList<CategoryDirective>();
        int i = 0;
        while (i < children.length) {
            CategoryDirective category = this.getCategoryDirective(children[i]);
            list.add(category);
            ++i;
        }
        return list.toArray(new CategoryDirective[0]);
    }

    private CategoryDirective getCategoryDirective(Configuration config) throws ConfigurationException {
        String name = config.getAttribute("name");
        String priority = config.getAttribute("priority", null);
        String target = config.getAttribute("target", null);
        return new CategoryDirective(name, priority, target);
    }

    protected Parameters getParameters(Configuration config) throws ConfigurationException {
        if (config != null) {
            return Parameters.fromConfiguration((Configuration)config);
        }
        return null;
    }

    public ContextDirective getContextDirective(Configuration config) throws ConfigurationException {
        if (config == null) {
            return null;
        }
        if (config.getChildren("import").length > 0) {
            String error = "The 'context' tag format has changed. Please check Merlin home for details http://avalon.apache.org/sandbox/merlin/resources";
            throw new ConfigurationException("The 'context' tag format has changed. Please check Merlin home for details http://avalon.apache.org/sandbox/merlin/resources");
        }
        String classname = config.getAttribute("class", null);
        EntryDirective[] entries = this.getEntries(config.getChildren("entry"));
        return new ContextDirective(classname, entries);
    }

    protected EntryDirective[] getEntries(Configuration[] configs) throws ConfigurationException {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < configs.length) {
            Configuration conf = configs[i];
            String key = conf.getAttribute("key");
            Configuration[] children = conf.getChildren();
            if (children.length != 1) {
                String error = "Entry '" + key + "' does not contain one child element.";
                throw new ConfigurationException(error);
            }
            Configuration child = children[0];
            String name = child.getName();
            if (name.equals("import")) {
                String importKey = child.getAttribute("key");
                list.add(new ImportDirective(key, importKey));
            } else if (name.equals("constructor")) {
                String classname = child.getAttribute("class", "java.lang.String");
                Configuration[] paramsConf = child.getChildren("param");
                if (paramsConf.length > 0) {
                    Parameter[] params = this.getParameters(paramsConf);
                    list.add(new ConstructorDirective(key, classname, params));
                } else {
                    list.add(new ConstructorDirective(key, classname, child.getValue()));
                }
            } else {
                String error = "Entry child unrecognized: " + name;
                throw new ConfigurationException(error);
            }
            ++i;
        }
        return list.toArray(new EntryDirective[0]);
    }

    protected Parameter[] getParameters(Configuration[] configs) throws ConfigurationException {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        int i = 0;
        while (i < configs.length) {
            Parameter parameter = this.getParameter(configs[i]);
            list.add(parameter);
            ++i;
        }
        return list.toArray(new Parameter[0]);
    }

    protected Parameter getParameter(Configuration config) throws ConfigurationException {
        String classname = config.getAttribute("class", "java.lang.String");
        String value = config.getValue(null);
        if (value != null) {
            return new Parameter(classname, value);
        }
        Configuration[] params = config.getChildren("param");
        Parameter[] parameters = this.getParameters(params);
        return new Parameter(classname, parameters);
    }
}

