/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.data.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.avalon.meta.data.ClassLoaderDirective;
import org.apache.avalon.meta.data.ClasspathDirective;
import org.apache.avalon.meta.data.ContainmentProfile;
import org.apache.avalon.meta.data.DeploymentProfile;
import org.apache.avalon.meta.data.FilesetDirective;
import org.apache.avalon.meta.data.IncludeDirective;
import org.apache.avalon.meta.data.LibraryDirective;
import org.apache.avalon.meta.data.Profile;
import org.apache.avalon.meta.data.RepositoryDirective;
import org.apache.avalon.meta.data.ResourceDirective;
import org.apache.avalon.meta.data.ServiceDirective;
import org.apache.avalon.meta.data.writer.XMLDeploymentProfileWriter;
import org.apache.avalon.meta.info.DependencyDescriptor;

public class XMLContainmentProfileWriter
extends XMLDeploymentProfileWriter {
    public void writeContainmentProfile(ContainmentProfile profile, OutputStream output) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        this.writeHeader(writer, profile);
        this.writeContainmentProfile(writer, profile, true, "");
        ((Writer)writer).flush();
    }

    protected void writeContainmentProfile(Writer writer, ContainmentProfile profile, String pad) throws Exception {
        this.writeContainmentProfile(writer, profile, false, pad);
    }

    protected void writeContainmentProfile(Writer writer, ContainmentProfile profile, boolean flag, String pad) throws Exception {
        writer.write("\n");
        writer.write(pad + "<container name=\"" + profile.getName() + "\">");
        String padding = pad + "  ";
        this.writeServiceDirectives(writer, profile.getServiceDirectives(), padding);
        this.writeDependencies(writer, profile.getDependencies(), padding);
        this.writeClassLoader(writer, profile.getClassLoaderDirective(false), padding);
        this.writeProfiles(writer, profile.getProfiles(), padding);
        writer.write("\n" + pad + "</container>");
        writer.write("\n");
    }

    private void writeHeader(Writer writer, ContainmentProfile profile) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
    }

    private void writeServiceDirectives(Writer writer, ServiceDirective[] services, String pad) throws IOException {
        if (0 == services.length) {
            return;
        }
        writer.write("\n" + pad + "<services>");
        String padding = pad + "  ";
        int i = 0;
        while (i < services.length) {
            ServiceDirective service = services[i];
            writer.write("\n" + padding + "<service type=\"");
            writer.write(service.getReference().toString());
            writer.write("\">");
            writer.write("\n" + padding + "  " + "<source>" + service.getPath() + "</source>");
            writer.write("\n" + padding + "</service>");
            ++i;
        }
        writer.write("\n" + pad + "</services>");
    }

    private void writeDependencies(Writer writer, DependencyDescriptor[] dependencies, String pad) throws IOException {
        if (0 == dependencies.length) {
            return;
        }
        String padding = pad + "  ";
        writer.write("\n" + pad + "<dependencies>");
        int i = 0;
        while (i < dependencies.length) {
            DependencyDescriptor dependency = dependencies[i];
            writer.write("\n" + padding + "<dependency type=\"" + dependency.getReference().getClassname() + "\"");
            if (dependency.isOptional()) {
                writer.write(" optional=\"true\"");
            }
            writer.write("/>");
            ++i;
        }
        writer.write("\n" + pad + "</dependencies>");
    }

    private void writeClassLoader(Writer writer, ClassLoaderDirective classloader, String pad) throws IOException {
        if (classloader == null) {
            return;
        }
        writer.write("\n" + pad + "<classloader>");
        String padding = pad + "  ";
        LibraryDirective library = classloader.getLibrary(false);
        this.writeLibrary(writer, library, padding);
        ClasspathDirective classpath = classloader.getClasspathDirective(false);
        this.writeClasspathDirective(writer, classpath, padding);
        writer.write("\n" + pad + "</classloader>");
    }

    private void writeLibrary(Writer writer, LibraryDirective library, String pad) throws IOException {
        if (library == null) {
            return;
        }
        String padding = pad + "  ";
        writer.write("\n" + pad + "<library>");
        String[] includes = library.getIncludes();
        int i = 0;
        while (i < includes.length) {
            writer.write("\n" + padding + "<include>" + includes[i] + "</include>");
            ++i;
        }
        String[] groups = library.getGroups();
        int i2 = 0;
        while (i2 < groups.length) {
            writer.write("\n" + padding + "<group>" + groups[i2] + "</group>");
            ++i2;
        }
        writer.write("\n" + pad + "</library>");
    }

    private void writeClasspathDirective(Writer writer, ClasspathDirective classpath, String pad) throws IOException {
        RepositoryDirective[] repositories;
        if (classpath == null) {
            return;
        }
        String padding = pad + "  ";
        writer.write("\n" + pad + "<classpath>");
        FilesetDirective[] filesets = classpath.getFilesets();
        if (filesets.length > 0) {
            int i = 0;
            while (i < filesets.length) {
                this.writeFilesetDirective(writer, filesets[i], padding);
                ++i;
            }
        }
        if ((repositories = classpath.getRepositoryDirectives()).length > 0) {
            int i = 0;
            while (i < repositories.length) {
                this.writeRepositoryDirective(writer, repositories[i], padding);
                ++i;
            }
        }
        writer.write("\n" + pad + "</classpath>");
    }

    private void writeRepositoryDirective(Writer writer, RepositoryDirective repository, String pad) throws IOException {
        ResourceDirective[] resources = repository.getResources();
        if (resources.length > 0) {
            String padding = pad + "  ";
            writer.write("\n" + pad + "<repository>");
            int i = 0;
            while (i < resources.length) {
                this.writeResourceDirective(writer, resources[i], padding);
                ++i;
            }
            writer.write("\n" + pad + "</repository>");
        }
    }

    private void writeFilesetDirective(Writer writer, FilesetDirective fileset, String pad) throws IOException {
        writer.write("\n" + pad + "<fileset dir=\"" + fileset.getBaseDirectory() + "\">");
        IncludeDirective[] includes = fileset.getIncludes();
        int i = 0;
        while (i < includes.length) {
            writer.write("\n" + pad + "  " + "<include>" + includes[i].getPath() + "</include>");
            ++i;
        }
        writer.write("\n" + pad + "</fileset>");
    }

    private void writeResourceDirective(Writer writer, ResourceDirective resource, String pad) throws IOException {
        writer.write("\n" + pad + "<resource");
        writer.write(" id=\"" + resource.getId() + "\"");
        if (resource.getVersion() != null) {
            writer.write(" version=\"" + resource.getVersion() + "\"");
        }
        writer.write("/>");
    }

    private void writeProfiles(Writer writer, Profile[] profiles, String pad) throws Exception {
        int i = 0;
        while (i < profiles.length) {
            Profile profile = profiles[i];
            if (profile instanceof ContainmentProfile) {
                ContainmentProfile container = (ContainmentProfile)profile;
                writer.write("\n");
                this.writeContainmentProfile(writer, container, pad);
            } else if (profile instanceof DeploymentProfile) {
                DeploymentProfile component = (DeploymentProfile)profile;
                writer.write("\n");
                this.writeDeploymentProfile(writer, component, pad);
            } else {
                System.out.println("UNRECOGNIZED PROFILE: " + profile);
            }
            ++i;
        }
    }
}

